/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.Database;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.RowStoreAVLDisk;
import org.hsqldb.persist.TableSpaceManager;

final class DataFileDefrag {
    DataFileCache dataFileOut;
    StopWatch stopw = new StopWatch();
    String dataFileName;
    long[][] rootsList;
    Database database;
    DataFileCache dataCache;
    int scale;
    DoubleIntIndex pointerLookup;

    DataFileDefrag(Database database, DataFileCache dataFileCache, String string) {
        this.database = database;
        this.dataCache = dataFileCache;
        this.scale = dataFileCache.getDataFileScale();
        this.dataFileName = string;
    }

    void process() {
        Object object;
        Object object2;
        int n;
        Throwable throwable = null;
        this.database.logger.logDetailEvent("Defrag process begins");
        HsqlArrayList hsqlArrayList = this.database.schemaManager.getAllTables(true);
        this.rootsList = new long[hsqlArrayList.size()][];
        long l = 0L;
        int n2 = hsqlArrayList.size();
        for (n = 0; n < n2; ++n) {
            long l2;
            object2 = (Table)hsqlArrayList.get(n);
            if (((TableBase)object2).getTableType() != 5 || (l2 = (object = this.database.persistentStoreCollection.getStore(object2)).elementCount()) <= l) continue;
            l = l2;
        }
        if (l > Integer.MAX_VALUE) {
            throw Error.error(3426);
        }
        try {
            this.pointerLookup = new DoubleIntIndex((int)l, false);
            this.dataFileOut = new DataFileCache(this.database, this.dataFileName, true);
            this.pointerLookup.setKeysSearchTarget();
            n2 = hsqlArrayList.size();
            for (n = 0; n < n2; ++n) {
                object2 = (Table)hsqlArrayList.get(n);
                if (((TableBase)object2).getTableType() == 5) {
                    object = this.writeTableToDataFile((Table)object2);
                    this.rootsList[n] = (long[])object;
                } else {
                    this.rootsList[n] = null;
                }
                this.database.logger.logDetailEvent("table complete " + ((Table)object2).getName().name);
            }
            this.dataFileOut.fileModified = true;
            this.dataFileOut.close();
            this.dataFileOut = null;
            n2 = this.rootsList.length;
            for (n = 0; n < n2; ++n) {
                object2 = this.rootsList[n];
                if (object2 == null) continue;
                this.database.logger.logDetailEvent("roots: " + StringUtil.getList((long[])object2, ",", ""));
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throwable = outOfMemoryError;
            throw Error.error(460, outOfMemoryError);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw Error.error(458, throwable2);
        }
        finally {
            try {
                if (this.dataFileOut != null) {
                    this.dataFileOut.release();
                }
            }
            catch (Throwable throwable3) {}
            if (throwable instanceof OutOfMemoryError) {
                this.database.logger.logInfoEvent("defrag failed - out of memory - required: " + l * 8L);
            }
            if (throwable == null) {
                this.database.logger.logDetailEvent("Defrag transfer complete: " + this.stopw.elapsedTime());
            } else {
                this.database.logger.logSevereEvent("defrag failed ", throwable);
                this.database.logger.getFileAccess().removeElement(this.dataFileName + ".new");
            }
        }
    }

    long[] writeTableToDataFile(Table table) {
        PersistentStore persistentStore = table.database.persistentStoreCollection.getStore(table);
        TableSpaceManager tableSpaceManager = this.dataFileOut.spaceManager.getTableSpace(table.getSpaceID());
        long[] lArray = table.getIndexRootsArray();
        this.pointerLookup.clear();
        this.database.logger.logDetailEvent("lookup begins " + table.getName().name + " " + this.stopw.elapsedTime());
        RowStoreAVLDisk.moveDataToSpace(persistentStore, this.dataFileOut, tableSpaceManager, this.pointerLookup);
        for (int i = 0; i < table.getIndexCount(); ++i) {
            if (lArray[i] == -1L) continue;
            long l = this.pointerLookup.lookup(lArray[i], -1L);
            if (l == -1L) {
                throw Error.error(466);
            }
            lArray[i] = l;
        }
        long l = lArray[table.getIndexCount() * 2];
        if (l != (long)this.pointerLookup.size()) {
            this.database.logger.logSevereEvent("discrepency in row count " + table.getName().name + " " + l + " " + this.pointerLookup.size(), null);
        }
        lArray[table.getIndexCount()] = 0L;
        lArray[table.getIndexCount() * 2] = this.pointerLookup.size();
        this.database.logger.logDetailEvent("table written " + table.getName().name);
        return lArray;
    }

    public long[][] getIndexRoots() {
        return this.rootsList;
    }
}

