/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat.conference;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.chat.conference.ChatRoomConfigurationWindow;
import net.java.sip.communicator.impl.gui.main.chat.conference.ConferenceChatSession;
import net.java.sip.communicator.impl.gui.main.chat.conference.MembersListDialog;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.ErrorDialog;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.muc.ChatRoomWrapper;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ChatRoomConfigurationForm;
import net.java.sip.communicator.service.protocol.ChatRoomMemberRole;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.event.ChatRoomLocalUserRoleChangeEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomLocalUserRoleListener;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.skin.Skinnable;
import org.jitsi.service.resources.ResourceManagementService;

public class ChatRoomSubjectPanel
extends TransparentPanel
implements Skinnable,
ChatRoomLocalUserRoleListener {
    private static final Logger logger = Logger.getLogger(ChatRoomSubjectPanel.class);
    private final ConferenceChatSession chatSession;
    private final JTextField subjectField = new JTextField();
    private JButton configButton;
    private JButton membersListButton;
    private final JPanel configButtonsPanel = new TransparentPanel((LayoutManager)new FlowLayout(1, 5, 0));

    public ChatRoomSubjectPanel(ConferenceChatSession chatSession) {
        super((LayoutManager)new BorderLayout(0, 5));
        this.chatSession = chatSession;
        JLabel subjectLabel = new JLabel(GuiActivator.getResources().getI18NString("service.gui.SUBJECT") + ": ");
        this.subjectField.setText(chatSession.getChatSubject());
        this.subjectField.setEditable(false);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 0));
        this.add(subjectLabel, "West");
        this.add(this.subjectField, "Center");
        this.add(this.configButtonsPanel, "East");
        chatSession.addLocalUserRoleListener(this);
        this.updateConfigButtons();
    }

    private synchronized void updateConfigButtons() {
        ChatRoom room = ((ChatRoomWrapper)this.chatSession.getDescriptor()).getChatRoom();
        ChatRoomMemberRole role = room.getUserRole();
        if (!ConfigurationUtils.isChatRoomConfigDisabled() && (role.equals((Object)ChatRoomMemberRole.ADMINISTRATOR) || role.equals((Object)ChatRoomMemberRole.OWNER))) {
            if (this.membersListButton == null) {
                this.membersListButton = new JButton(new ImageIcon(ImageLoader.getImage(ImageLoader.CHAT_ROOM_MEMBERS_LIST_CONFIG)));
                this.membersListButton.setToolTipText(GuiActivator.getResources().getI18NString("service.gui.CHAT_ROOM_CONFIGURATION_MEMBERS_EDIT_TITLE"));
                this.membersListButton.setPreferredSize(new Dimension(26, 26));
                this.membersListButton.addActionListener(new MembersListButtonActionListener());
                this.configButtonsPanel.add(this.membersListButton);
                this.revalidate();
                this.repaint();
            }
        } else if (this.membersListButton != null) {
            this.remove(this.membersListButton);
            this.membersListButton = null;
            this.revalidate();
            this.repaint();
        }
        if (!ConfigurationUtils.isChatRoomConfigDisabled() && role.equals((Object)ChatRoomMemberRole.OWNER)) {
            if (this.configButton == null) {
                this.configButton = new JButton(new ImageIcon(ImageLoader.getImage(ImageLoader.CHAT_ROOM_CONFIG)));
                this.configButton.setToolTipText(GuiActivator.getResources().getI18NString("service.gui.CHAT_ROOM_OPTIONS"));
                this.configButton.setPreferredSize(new Dimension(26, 26));
                this.configButton.addActionListener(new ConfigButtonActionListener());
                this.configButtonsPanel.add(this.configButton);
                this.revalidate();
                this.repaint();
            }
        } else if (this.configButton != null) {
            this.remove(this.configButton);
            this.configButton = null;
            this.revalidate();
            this.repaint();
        }
    }

    public String getSubject() {
        return this.subjectField.getText();
    }

    public void setSubject(String subject) {
        this.subjectField.setText(subject);
    }

    public void localUserRoleChanged(final ChatRoomLocalUserRoleChangeEvent evt) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChatRoomSubjectPanel.this.localUserRoleChanged(evt);
                }
            });
            return;
        }
        this.updateConfigButtons();
    }

    public void loadSkin() {
        if (this.configButton != null) {
            this.configButton.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.CHAT_ROOM_CONFIG)));
        }
        if (this.membersListButton != null) {
            this.membersListButton.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.CHAT_ROOM_MEMBERS_LIST_CONFIG)));
        }
    }

    public void dispose() {
        this.chatSession.removeLocalUserRoleListener(this);
    }

    private class MembersListButtonActionListener
    implements ActionListener {
        private MembersListButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            MembersListDialog dialog = new MembersListDialog((ChatRoomWrapper)ChatRoomSubjectPanel.this.chatSession.getDescriptor(), GuiActivator.getResources().getI18NString("service.gui.CHAT_ROOM_CONFIGURATION_MEMBERS_EDIT_TITLE"), false);
            dialog.setVisible(true);
        }
    }

    private class ConfigButtonActionListener
    implements ActionListener {
        private ConfigButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                ChatRoomConfigurationForm configForm = ChatRoomSubjectPanel.this.chatSession.getChatConfigurationForm();
                ChatRoomConfigurationWindow configWindow = new ChatRoomConfigurationWindow(ChatRoomSubjectPanel.this.chatSession.getChatName(), configForm);
                configWindow.pack();
                configWindow.setVisible(true);
            }
            catch (OperationFailedException e) {
                logger.error((Object)"Failed to obtain the chat room configuration form.", (Throwable)e);
                ResourceManagementService resources = GuiActivator.getResources();
                if (e.getErrorCode() == 12) {
                    new ErrorDialog(null, resources.getI18NString("service.gui.WARNING"), resources.getI18NString("service.gui.CHAT_ROOM_CONFIGURATION_FORBIDDEN", new String[]{ChatRoomSubjectPanel.this.chatSession.getChatName()}), 1).showDialog();
                }
                new ErrorDialog(null, resources.getI18NString("service.gui.ERROR"), resources.getI18NString("service.gui.CHAT_ROOM_CONFIGURATION_FAILED", new String[]{ChatRoomSubjectPanel.this.chatSession.getChatName()}), (Throwable)e).showDialog();
            }
        }
    }
}

