/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat.conference;

import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import net.java.sip.communicator.impl.gui.main.chat.ChatSession;
import net.java.sip.communicator.service.muc.ChatRoomWrapper;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ConferenceDescription;

public class ChatConferenceCallsListModels
extends AbstractListModel {
    private final List<ConferenceDescription> chatConferenceCalls = new ArrayList<ConferenceDescription>();
    private ChatSession chatSession;

    public ChatConferenceCallsListModels(ChatSession chatSession) {
        this.chatSession = chatSession;
    }

    public void initConferences() {
        Object descriptor = this.chatSession.getDescriptor();
        if (descriptor instanceof ChatRoomWrapper) {
            ChatRoom chatRoom = ((ChatRoomWrapper)descriptor).getChatRoom();
            for (ConferenceDescription cd : chatRoom.getCachedConferenceDescriptions().values()) {
                if (cd.isAvailable()) {
                    this.addElement(cd);
                    continue;
                }
                this.removeElement(cd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addElement(ConferenceDescription chatConference) {
        if (chatConference == null) {
            throw new IllegalArgumentException("ConferenceDescription");
        }
        int index = -1;
        List<ConferenceDescription> list = this.chatConferenceCalls;
        synchronized (list) {
            int chatContactCount = this.chatConferenceCalls.size();
            if (this.findConferenceDescription(chatConference) != -1) {
                return;
            }
            index = chatContactCount;
            this.chatConferenceCalls.add(index, chatConference);
        }
        this.fireIntervalAdded(this, index, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConferenceDescription getElementAt(int index) {
        List<ConferenceDescription> list = this.chatConferenceCalls;
        synchronized (list) {
            return this.chatConferenceCalls.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        List<ConferenceDescription> list = this.chatConferenceCalls;
        synchronized (list) {
            return this.chatConferenceCalls.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElement(ConferenceDescription chatConference) {
        List<ConferenceDescription> list = this.chatConferenceCalls;
        synchronized (list) {
            int index = this.findConferenceDescription(chatConference);
            if (index >= 0) {
                this.chatConferenceCalls.remove(index);
                this.fireIntervalRemoved(this, index, index);
            }
        }
    }

    private int findConferenceDescription(ConferenceDescription cd) {
        for (int i = 0; i < this.chatConferenceCalls.size(); ++i) {
            if (!cd.compareConferenceDescription(this.chatConferenceCalls.get(i))) continue;
            return i;
        }
        return -1;
    }
}

