/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call.conference;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.call.SwingCallRenderer;
import net.java.sip.communicator.impl.gui.main.call.conference.BasicConferenceParticipantPanel;
import net.java.sip.communicator.service.protocol.ConferenceMember;
import net.java.sip.communicator.service.protocol.ConferenceMemberState;
import net.java.sip.communicator.util.skin.Skinnable;

public class ConferenceMemberPanel
extends BasicConferenceParticipantPanel<ConferenceMember>
implements PropertyChangeListener,
Skinnable {
    private static final long serialVersionUID = 0L;
    private final ConferenceMember member;

    public ConferenceMemberPanel(SwingCallRenderer callRenderer, ConferenceMember member, boolean isVideo) {
        super(callRenderer, member, isVideo);
        this.member = member;
        this.member.addPropertyChangeListener((PropertyChangeListener)this);
        this.setParticipantName(member.getDisplayName());
        this.setParticipantState(member.getState().toString());
        this.setTitleBackground(new Color(GuiActivator.getResources().getColor("service.gui.CALL_MEMBER_NAME_BACKGROUND")));
    }

    void dispose() {
        this.member.removePropertyChangeListener((PropertyChangeListener)this);
    }

    public ConferenceMember getConferenceMember() {
        return this.member;
    }

    @Override
    public void loadSkin() {
        super.loadSkin();
        this.setTitleBackground(new Color(GuiActivator.getResources().getColor("service.gui.CALL_MEMBER_NAME_BACKGROUND")));
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        String propertyName = ev.getPropertyName();
        if (propertyName.equals("displayName")) {
            String displayName = (String)ev.getNewValue();
            this.setParticipantName(displayName);
            this.revalidate();
            this.repaint();
        } else if (propertyName.equals("state")) {
            ConferenceMemberState state = (ConferenceMemberState)ev.getNewValue();
            this.setParticipantState(state.toString());
            this.revalidate();
            this.repaint();
        }
    }
}

