/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.ColorUIResource;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.call.CallManager;
import net.java.sip.communicator.impl.gui.main.call.DesktopSharingFrame;
import net.java.sip.communicator.plugin.desktoputil.SIPCommTextButton;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallState;
import net.java.sip.communicator.service.protocol.event.CallChangeAdapter;
import net.java.sip.communicator.service.protocol.event.CallChangeEvent;
import net.java.sip.communicator.service.protocol.event.CallChangeListener;
import net.java.sip.communicator.service.protocol.media.MediaAwareCall;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.MediaUseCase;

public class FullScreenShareIndicator
extends CallChangeAdapter
implements PropertyChangeListener {
    private final Call call;
    private JDialog dialog = null;

    FullScreenShareIndicator(Call call) {
        this.call = call;
        if (call instanceof MediaAwareCall) {
            ((MediaAwareCall)call).addVideoPropertyChangeListener((PropertyChangeListener)this);
        }
        call.addCallChangeListener((CallChangeListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!evt.getPropertyName().equals("LOCAL_VIDEO_STREAMING") || this.call instanceof MediaAwareCall && ((MediaAwareCall)this.call).getMediaUseCase() != MediaUseCase.DESKTOP) {
            return;
        }
        Object newValue = evt.getNewValue();
        Object oldValue = evt.getOldValue();
        if ((oldValue == null || oldValue == MediaDirection.RECVONLY) && newValue == MediaDirection.SENDRECV && DesktopSharingFrame.getFrameForCall(this.call) == null) {
            this.showDialog();
        } else if (oldValue == MediaDirection.SENDRECV && (newValue == null || newValue == MediaDirection.RECVONLY)) {
            this.closeDialog();
        }
    }

    public void callStateChanged(CallChangeEvent ev) {
        if (!"CallState".equals(ev.getPropertyName())) {
            return;
        }
        Object newValue = ev.getNewValue();
        if (CallState.CALL_INITIALIZATION.equals(newValue) || CallState.CALL_IN_PROGRESS.equals(newValue)) {
            this.showDialog();
        } else if (CallState.CALL_ENDED.equals(newValue)) {
            ev.getSourceCall().removeCallChangeListener((CallChangeListener)this);
            if (this.call instanceof MediaAwareCall) {
                ((MediaAwareCall)this.call).removeVideoPropertyChangeListener((PropertyChangeListener)this);
            }
            this.closeDialog();
        }
    }

    private void showDialog() {
        if (this.dialog != null) {
            return;
        }
        this.dialog = new JDialog((Window)null){

            @Override
            public void setVisible(boolean b) {
                this.setLocationByPlatform(false);
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                this.setLocation(screenSize.width / 2 - this.getWidth() / 2, this.getLocation().y);
                super.setVisible(b);
            }
        };
        this.dialog.setUndecorated(true);
        this.dialog.getRootPane().setWindowDecorationStyle(0);
        this.dialog.setAlwaysOnTop(true);
        JLabel label = new JLabel(GuiActivator.getResources().getI18NString("service.gui.DESKTOP_SHARING_DIALOG_INDICATE"));
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        ColorUIResource backgroundColor = new ColorUIResource(GuiActivator.getResources().getColor("service.gui.DESKTOP_BACKGROUND"));
        JPanel panel = new JPanel(new FlowLayout());
        panel.setBackground(backgroundColor);
        TransparentPanel linePanel = new TransparentPanel((LayoutManager)new BorderLayout());
        linePanel.add((Component)label, "Center");
        linePanel.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, Color.lightGray));
        panel.add((Component)linePanel);
        SIPCommTextButton stopButton = new SIPCommTextButton("Stop");
        stopButton.setBackground((Color)backgroundColor);
        panel.add((Component)stopButton);
        stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CallManager.isDesktopSharingEnabled(FullScreenShareIndicator.this.call)) {
                    CallManager.enableDesktopSharing(FullScreenShareIndicator.this.call, false);
                }
            }
        });
        panel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.dialog.getContentPane().add(panel);
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    private void closeDialog() {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            this.dialog = null;
        }
    }
}

