/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import net.java.sip.communicator.impl.gui.main.call.UIVideoHandler2;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;

public class CloseLocalVisualComponentButton
extends Button
implements MouseListener {
    private static final long serialVersionUID = 0L;
    private final Image image;
    private final UIVideoHandler2 uiVideoHandler;

    public CloseLocalVisualComponentButton(UIVideoHandler2 uiVideoHandler) {
        if (uiVideoHandler == null) {
            throw new NullPointerException("uiVideoHandler");
        }
        this.uiVideoHandler = uiVideoHandler;
        this.image = ImageLoader.getImage(ImageLoader.CLOSE_VIDEO);
        int buttonWidth = this.image.getWidth(this) + 5;
        int buttonHeight = this.image.getHeight(this) + 5;
        this.setPreferredSize(new Dimension(buttonWidth, buttonHeight));
        this.setSize(new Dimension(buttonWidth, buttonHeight));
        this.addMouseListener(this);
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(Color.GRAY);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.drawImage(this.image, this.getWidth() / 2 - this.image.getWidth(this) / 2, this.getHeight() / 2 - this.image.getHeight(this) / 2, this);
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        this.uiVideoHandler.setLocalVideoVisible(false);
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }
}

