/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.media.protocol.PushBufferStream;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.SessionAddress;
import javax.media.rtp.SessionManager;
import javax.media.rtp.event.ActiveReceiveStreamEvent;
import javax.media.rtp.event.NewReceiveStreamEvent;
import javax.media.rtp.event.RemotePayloadChangeEvent;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.protocol.rtp.DataSource;
import net.sf.fmj.media.rtp.BufferControlImpl;
import net.sf.fmj.media.rtp.RTPControlImpl;
import net.sf.fmj.media.rtp.RTPDemultiplexer;
import net.sf.fmj.media.rtp.RTPRawReceiver;
import net.sf.fmj.media.rtp.RTPSourceStream;
import net.sf.fmj.media.rtp.SSRCCache;
import net.sf.fmj.media.rtp.SSRCInfo;
import net.sf.fmj.media.rtp.SourceRTPPacket;
import net.sf.fmj.media.rtp.util.Packet;
import net.sf.fmj.media.rtp.util.PacketFilter;
import net.sf.fmj.media.rtp.util.PacketSource;
import net.sf.fmj.media.rtp.util.RTPPacket;
import net.sf.fmj.media.rtp.util.SSRCTable;
import net.sf.fmj.media.rtp.util.UDPPacket;

public class RTPReceiver
extends PacketFilter {
    static final int MAX_DROPOUT = 3000;
    static final int MAX_MISORDER = 100;
    final SSRCCache cache;
    final RTPDemultiplexer rtpdemultiplexer;
    int lastseqnum = -1;
    private boolean rtcpstarted = false;
    private final String content = "";
    final SSRCTable<RTPPacket> probationList = new SSRCTable();
    private boolean initBC = false;
    private int errorPayload = -1;

    private RTPControlImpl getDsourceRTPControlImpl(SSRCInfo ssrcinfo) {
        return ssrcinfo.dsource.getControl(RTPControlImpl.class);
    }

    public RTPReceiver(SSRCCache ssrccache, RTPDemultiplexer rtpdemultiplexer1) {
        this.cache = ssrccache;
        this.rtpdemultiplexer = rtpdemultiplexer1;
        this.setConsumer(null);
    }

    public RTPReceiver(SSRCCache ssrccache, RTPDemultiplexer rtpdemultiplexer, DatagramSocket datagramsocket) {
        this(ssrccache, rtpdemultiplexer, new RTPRawReceiver(datagramsocket, ssrccache.sm.defaultstats));
    }

    public RTPReceiver(SSRCCache ssrccache, RTPDemultiplexer rtpdemultiplexer, int i, String s) throws IOException {
        this(ssrccache, rtpdemultiplexer, new RTPRawReceiver(i & 0xFFFFFFFE, s, ssrccache.sm.defaultstats));
    }

    public RTPReceiver(SSRCCache ssrccache, RTPDemultiplexer rtpdemultiplexer, PacketSource packetsource) {
        this(ssrccache, rtpdemultiplexer);
        this.setSource(packetsource);
    }

    @Override
    public String filtername() {
        return "RTP Packet Receiver";
    }

    @Override
    public Packet handlePacket(Packet packet) {
        return this.handlePacket((RTPPacket)packet);
    }

    @Override
    public Packet handlePacket(Packet packet, int i) {
        return null;
    }

    @Override
    public Packet handlePacket(Packet packet, SessionAddress sessionaddress) {
        return null;
    }

    public Packet handlePacket(RTPPacket rtppacket) {
        int port;
        InetAddress address;
        int pt = rtppacket.payloadType;
        if (pt == 13) {
            return rtppacket;
        }
        if (pt == 126) {
            return null;
        }
        if (rtppacket.base instanceof UDPPacket) {
            UDPPacket udppacket = (UDPPacket)rtppacket.base;
            address = udppacket.remoteAddress;
            if (this.cache.sm.bindtome && !this.cache.sm.isBroadcast(this.cache.sm.dataaddress) && !address.equals(this.cache.sm.dataaddress)) {
                return null;
            }
            port = udppacket.remotePort;
        } else {
            address = null;
            port = 0;
        }
        SSRCInfo ssrcinfo = this.cache.get(rtppacket.ssrc, address, port, 1);
        if (ssrcinfo == null) {
            return null;
        }
        for (int csrc : rtppacket.csrc) {
            SSRCInfo csrcinfo = this.cache.get(csrc, address, port, 1);
            if (csrcinfo == null) continue;
            csrcinfo.lastHeardFrom = rtppacket.receiptTime;
        }
        if (!ssrcinfo.sender) {
            ssrcinfo.initsource(rtppacket.seqnum);
            ssrcinfo.payloadType = pt;
        }
        int oldprobation = ssrcinfo.probation;
        this.updateStats(ssrcinfo, rtppacket);
        int newprobation = ssrcinfo.probation;
        if (this.cache.sm.isUnicast()) {
            if (!this.rtcpstarted) {
                this.cache.sm.startRTCPReports(address);
                this.rtcpstarted = true;
                byte[] controladdress = this.cache.sm.controladdress.getAddress();
                if ((controladdress[3] & 0xFF) == 255) {
                    this.cache.sm.addUnicastAddr(this.cache.sm.controladdress);
                } else {
                    boolean addUnicastAddr;
                    InetAddress localhost;
                    try {
                        localhost = InetAddress.getLocalHost();
                        addUnicastAddr = true;
                    }
                    catch (UnknownHostException unknownhostexception) {
                        localhost = null;
                        addUnicastAddr = false;
                    }
                    if (addUnicastAddr) {
                        this.cache.sm.addUnicastAddr(localhost);
                    }
                }
            } else if (!this.cache.sm.isSenderDefaultAddr(address)) {
                this.cache.sm.addUnicastAddr(address);
            }
        }
        ++ssrcinfo.received;
        ssrcinfo.stats.update(1);
        if (newprobation > 0) {
            this.probationList.put(ssrcinfo.ssrc, rtppacket.clone());
            return null;
        }
        ssrcinfo.maxseq = rtppacket.seqnum;
        int lastPayloadType = this.updateLastPayloadType(ssrcinfo, rtppacket);
        if (!this.assertCurrentformat(ssrcinfo, pt)) {
            return rtppacket;
        }
        if (!this.initBC) {
            ((BufferControlImpl)this.cache.sm.buffercontrol).initBufferControl(ssrcinfo.currentformat);
            this.initBC = true;
        }
        this.streamconnect(ssrcinfo);
        if (ssrcinfo.dsource != null) {
            ssrcinfo.active = true;
        }
        if (!ssrcinfo.newrecvstream) {
            ssrcinfo.newrecvstream = true;
            this.cache.eventhandler.postEvent(new NewReceiveStreamEvent(this.cache.sm, (ReceiveStream)((Object)ssrcinfo)));
        }
        this.updateJitter(ssrcinfo, lastPayloadType, rtppacket);
        ssrcinfo.lastRTPReceiptTime = rtppacket.receiptTime;
        ssrcinfo.lasttimestamp = rtppacket.timestamp;
        this.updatePayloadType(ssrcinfo, rtppacket);
        ssrcinfo.bytesreceived += rtppacket.payloadlength;
        ssrcinfo.lastHeardFrom = rtppacket.receiptTime;
        if (ssrcinfo.quiet) {
            ssrcinfo.quiet = false;
            this.cache.eventhandler.postEvent(new ActiveReceiveStreamEvent((SessionManager)this.cache.sm, ssrcinfo.sourceInfo, ssrcinfo instanceof ReceiveStream ? (ReceiveStream)((Object)ssrcinfo) : null));
        }
        this.demuxpayload(ssrcinfo, oldprobation > 0 && newprobation == 0, rtppacket);
        return rtppacket;
    }

    private boolean assertCurrentformat(SSRCInfo ssrcinfo, int pt) {
        RTPControlImpl rtpcontrolimpl;
        if (ssrcinfo.currentformat == null) {
            ssrcinfo.currentformat = this.cache.sm.formatinfo.get(pt);
            if (ssrcinfo.currentformat == null) {
                if (this.errorPayload != pt) {
                    this.errorPayload = pt;
                    Log.error("No format has been registered for RTP payload type (number) " + pt + "!");
                }
                return false;
            }
            if (ssrcinfo.dstream != null) {
                ssrcinfo.dstream.setFormat(ssrcinfo.currentformat);
            }
        }
        if (ssrcinfo.dsource != null && (rtpcontrolimpl = this.getDsourceRTPControlImpl(ssrcinfo)) != null) {
            rtpcontrolimpl.currentformat = ssrcinfo.currentformat;
        }
        return true;
    }

    private void demuxpayload(SSRCInfo ssrcinfo, boolean wasOnProbation, RTPPacket rtppacket) {
        if (ssrcinfo.dsource != null) {
            RTPPacket rtppacket1;
            if (wasOnProbation && (rtppacket1 = this.probationList.remove(ssrcinfo.ssrc)) != null) {
                this.rtpdemultiplexer.demuxpayload(new SourceRTPPacket(rtppacket1, ssrcinfo));
            }
            this.rtpdemultiplexer.demuxpayload(new SourceRTPPacket(rtppacket, ssrcinfo));
        }
    }

    private int updateLastPayloadType(SSRCInfo ssrcinfo, RTPPacket rtppacket) {
        int oldpayload = ssrcinfo.lastPayloadType;
        int newpayload = rtppacket.payloadType;
        if (oldpayload != -1 && oldpayload != newpayload) {
            if (rtppacket.payloadlength == 0) {
                return oldpayload;
            }
            ssrcinfo.currentformat = null;
            if (ssrcinfo.dsource != null) {
                RTPControlImpl rtpcontrolimpl = this.getDsourceRTPControlImpl(ssrcinfo);
                if (rtpcontrolimpl != null) {
                    rtpcontrolimpl.currentformat = null;
                    rtpcontrolimpl.payload = -1;
                }
                try {
                    Log.warning("Stopping stream because of payload type mismatch: expecting pt=" + oldpayload + ", got pt=" + newpayload);
                    ssrcinfo.dsource.stop();
                }
                catch (IOException ioe) {
                    System.err.println("Stopping DataSource after PCE " + ioe.getMessage());
                }
            }
            ssrcinfo.lastPayloadType = newpayload;
            this.cache.eventhandler.postEvent(new RemotePayloadChangeEvent(this.cache.sm, (ReceiveStream)((Object)ssrcinfo), oldpayload, newpayload));
        } else {
            ssrcinfo.lastPayloadType = newpayload;
        }
        return oldpayload;
    }

    private int updatePayloadType(SSRCInfo ssrcinfo, RTPPacket rtppacket) {
        int oldpayload = ssrcinfo.payloadType;
        int newpayload = rtppacket.payloadType;
        if (oldpayload == -1 || oldpayload != newpayload && rtppacket.payloadlength != 0) {
            ssrcinfo.payloadType = rtppacket.payloadType;
        }
        return oldpayload;
    }

    private void streamconnect(SSRCInfo ssrcinfo) {
        if (!ssrcinfo.streamconnect) {
            DataSource datasource = this.cache.sm.dslist.get(ssrcinfo.ssrc);
            if (datasource == null) {
                DataSource datasource1 = this.cache.sm.getDataSource(null);
                if (datasource1 == null) {
                    datasource = this.cache.sm.createNewDS(null);
                    this.cache.sm.setDefaultDSassigned(ssrcinfo.ssrc);
                } else if (!this.cache.sm.isDefaultDSassigned()) {
                    datasource = datasource1;
                    this.cache.sm.setDefaultDSassigned(ssrcinfo.ssrc);
                } else {
                    datasource = this.cache.sm.createNewDS(ssrcinfo.ssrc);
                }
            }
            PushBufferStream[] pushbufferstreams = datasource.getStreams();
            ssrcinfo.dsource = datasource;
            ssrcinfo.dstream = (RTPSourceStream)pushbufferstreams[0];
            ssrcinfo.dstream.setContentDescriptor("");
            ssrcinfo.dstream.setFormat(ssrcinfo.currentformat);
            RTPControlImpl rtpcontrolimpl = this.getDsourceRTPControlImpl(ssrcinfo);
            if (rtpcontrolimpl != null) {
                rtpcontrolimpl.currentformat = ssrcinfo.currentformat;
                rtpcontrolimpl.stream = ssrcinfo;
            }
            ssrcinfo.streamconnect = true;
        }
    }

    private void updateJitter(SSRCInfo ssrcinfo, int lastPayloadType, RTPPacket rtppacket) {
        if (ssrcinfo.lastRTPReceiptTime != 0L && lastPayloadType == rtppacket.payloadType) {
            long l = rtppacket.receiptTime - ssrcinfo.lastRTPReceiptTime;
            l = l * (long)this.cache.clockrate[ssrcinfo.payloadType] / 1000L;
            long l1 = rtppacket.timestamp - ssrcinfo.lasttimestamp;
            double d = Math.abs((double)(l - l1));
            ssrcinfo.jitter += 0.0625 * (d - ssrcinfo.jitter);
        }
    }

    private void updateStats(SSRCInfo ssrcinfo, RTPPacket rtppacket) {
        int seqnum = rtppacket.seqnum;
        int diff = seqnum - ssrcinfo.maxseq;
        if (diff > 0) {
            if (ssrcinfo.maxseq + 1 != seqnum) {
                ssrcinfo.stats.update(0, diff - 1);
            }
        } else if (diff < 0 && diff > -100) {
            ssrcinfo.stats.update(0, -1);
        }
        if (ssrcinfo.wrapped) {
            ssrcinfo.wrapped = false;
        }
        if (ssrcinfo.probation > 0) {
            if (seqnum == ssrcinfo.maxseq + 1) {
                --ssrcinfo.probation;
                ssrcinfo.maxseq = seqnum;
            } else {
                ssrcinfo.probation = 1;
                ssrcinfo.maxseq = seqnum;
                ssrcinfo.stats.update(2);
            }
        } else if (diff < 3000 && diff != 0) {
            if (seqnum < ssrcinfo.baseseq && diff < -32767) {
                ssrcinfo.cycles += 65536;
                ssrcinfo.wrapped = true;
            }
            ssrcinfo.maxseq = seqnum;
        } else if (diff <= 65436 && diff != 0) {
            ssrcinfo.stats.update(3);
            if (seqnum == ssrcinfo.lastbadseq) {
                ssrcinfo.initsource(seqnum);
            } else {
                ssrcinfo.lastbadseq = seqnum + 1 & 0xFFFF;
            }
        } else {
            ssrcinfo.stats.update(4);
        }
    }
}

