/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtp.translator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.media.Format;
import javax.media.rtp.OutputDataStream;
import org.ice4j.util.QueueStatistics;
import org.jitsi.impl.neomedia.RTPConnectorOutputStream;
import org.jitsi.impl.neomedia.rtp.translator.OutputDataStreamDesc;
import org.jitsi.impl.neomedia.rtp.translator.Payload;
import org.jitsi.impl.neomedia.rtp.translator.RTPConnectorDesc;
import org.jitsi.impl.neomedia.rtp.translator.RTPConnectorImpl;
import org.jitsi.impl.neomedia.rtp.translator.RTPTranslatorBuffer;
import org.jitsi.impl.neomedia.rtp.translator.RTPTranslatorImpl;
import org.jitsi.impl.neomedia.rtp.translator.StreamRTPManagerDesc;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.util.ConfigUtils;
import org.jitsi.util.Logger;

class OutputDataStreamImpl
implements OutputDataStream,
Runnable {
    private static final Logger logger = Logger.getLogger(OutputDataStreamImpl.class);
    private static final String REMOVE_RTP_HEADER_EXTENSIONS_PNAME = RTPTranslatorImpl.class.getName() + ".removeRTPHeaderExtensions";
    private static final int WRITE_Q_CAPACITY = RTPConnectorOutputStream.PACKET_QUEUE_CAPACITY;
    private boolean closed;
    private final RTPConnectorImpl connector;
    private final boolean _data;
    private final boolean _removeRTPHeaderExtensions;
    private List<OutputDataStreamDesc> _streams = Collections.emptyList();
    private final Object _streamsSyncRoot = new Object();
    private final RTPTranslatorBuffer[] writeQ = new RTPTranslatorBuffer[WRITE_Q_CAPACITY];
    private int writeQHead;
    private int writeQLength;
    private final QueueStatistics writeQStats;
    private int numDroppedPackets = 0;
    private Thread writeThread;

    public OutputDataStreamImpl(RTPConnectorImpl connector, boolean data) {
        this.connector = connector;
        this._data = data;
        this._removeRTPHeaderExtensions = ConfigUtils.getBoolean(LibJitsi.getConfigurationService(), REMOVE_RTP_HEADER_EXTENSIONS_PNAME, false);
        this.writeQStats = logger.isTraceEnabled() ? new QueueStatistics(this.getClass().getSimpleName() + "-" + this.hashCode()) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStream(RTPConnectorDesc connectorDesc, OutputDataStream stream) {
        Object object = this._streamsSyncRoot;
        synchronized (object) {
            for (OutputDataStreamDesc streamDesc : this._streams) {
                if (streamDesc.connectorDesc != connectorDesc || streamDesc.stream != stream) continue;
                return;
            }
            ArrayList<OutputDataStreamDesc> newStreams = new ArrayList<OutputDataStreamDesc>(this._streams.size() * 3 / 2 + 1);
            newStreams.addAll(this._streams);
            newStreams.add(new OutputDataStreamDesc(connectorDesc, stream));
            this._streams = newStreams;
        }
    }

    public synchronized void close() {
        this.closed = true;
        this.writeThread = null;
        this.notify();
    }

    private synchronized void createWriteThread() {
        this.writeThread = new Thread((Runnable)this, this.getClass().getName());
        this.writeThread.setDaemon(true);
        this.writeThread.start();
    }

    private int doWrite(byte[] buf, int off, int len, Format format, StreamRTPManagerDesc exclusion) {
        RTPTranslatorImpl translator = this.getTranslator();
        if (translator == null) {
            return 0;
        }
        List<OutputDataStreamDesc> streams = this._streams;
        boolean removeRTPHeaderExtensions = this._removeRTPHeaderExtensions;
        int written = 0;
        int end = streams.size();
        for (int i = 0; i < end; ++i) {
            int w;
            boolean write;
            OutputDataStreamDesc s = streams.get(i);
            StreamRTPManagerDesc streamRTPManager = s.connectorDesc.streamRTPManagerDesc;
            if (streamRTPManager == exclusion) continue;
            if (this._data) {
                if (removeRTPHeaderExtensions) {
                    removeRTPHeaderExtensions = false;
                    len = OutputDataStreamImpl.removeRTPHeaderExtensions(buf, off, len);
                }
                write = this.willWriteData(streamRTPManager, buf, off, len, format, exclusion);
            } else {
                write = this.willWriteControl(streamRTPManager, buf, off, len, format, exclusion);
            }
            if (write) {
                write = translator.willWrite(exclusion, buf, off, len, streamRTPManager, this._data);
            }
            if (!write || written >= (w = s.stream.write(buf, off, len))) continue;
            written = w;
        }
        return written;
    }

    private RTPTranslatorImpl getTranslator() {
        return this.connector.translator;
    }

    private static int removeRTPHeaderExtensions(byte[] buf, int off, int len) {
        byte b0;
        int v;
        if (len >= 12 && (v = ((b0 = buf[off]) & 0xC0) >>> 6) == 2) {
            int xEnd;
            int end;
            int xLen;
            int cc;
            int xBegin;
            boolean x;
            boolean bl = x = (b0 & 0x10) == 16;
            if (x && (xBegin = off + 12 + 4 * (cc = b0 & 0xF)) + (xLen = 4) < (end = off + len) && (xEnd = xBegin + (xLen += RTPTranslatorImpl.readUnsignedShort(buf, xBegin + 2) * 4)) <= end) {
                int src = xEnd;
                int dst = xBegin;
                while (src < end) {
                    buf[dst++] = buf[src++];
                }
                len -= xLen;
                buf[off] = (byte)(b0 & 0xEF);
            }
        }
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStreams(RTPConnectorDesc connectorDesc) {
        Object object = this._streamsSyncRoot;
        synchronized (object) {
            ArrayList<OutputDataStreamDesc> newStreams = new ArrayList<OutputDataStreamDesc>(this._streams);
            Iterator i = newStreams.iterator();
            while (i.hasNext()) {
                if (((OutputDataStreamDesc)i.next()).connectorDesc != connectorDesc) continue;
                i.remove();
            }
            this._streams = newStreams;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (true) {
                int length;
                Format format;
                StreamRTPManagerDesc exclusion;
                byte[] buffer;
                RTPTranslatorBuffer write;
                int writeIndex;
                OutputDataStreamImpl outputDataStreamImpl = this;
                synchronized (outputDataStreamImpl) {
                    if (this.closed) return;
                    if (!Thread.currentThread().equals(this.writeThread)) {
                        return;
                    }
                    if (this.writeQLength < 1) {
                        boolean interrupted = false;
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ie) {
                            interrupted = true;
                        }
                        if (interrupted) {
                            Thread.currentThread().interrupt();
                        }
                        continue;
                    }
                    writeIndex = this.writeQHead++;
                    write = this.writeQ[writeIndex];
                    buffer = write.data;
                    write.data = null;
                    exclusion = write.exclusion;
                    write.exclusion = null;
                    format = write.format;
                    write.format = null;
                    length = write.length;
                    write.length = 0;
                    if (this.writeQHead >= this.writeQ.length) {
                        this.writeQHead = 0;
                    }
                    --this.writeQLength;
                    if (this.writeQStats != null) {
                        this.writeQStats.remove(System.currentTimeMillis());
                    }
                }
                try {
                    this.doWrite(buffer, 0, length, format, exclusion);
                    outputDataStreamImpl = this;
                }
                catch (Throwable throwable) {
                    OutputDataStreamImpl outputDataStreamImpl2 = this;
                    synchronized (outputDataStreamImpl2) {
                        RTPTranslatorBuffer write2 = this.writeQ[writeIndex];
                        if (write2 == null) throw throwable;
                        if (write2.data != null) throw throwable;
                        write2.data = buffer;
                        throw throwable;
                    }
                }
                synchronized (outputDataStreamImpl) {
                    write = this.writeQ[writeIndex];
                    if (write != null && write.data == null) {
                        write.data = buffer;
                    }
                }
            }
        }
        catch (Throwable t) {
            logger.error("Failed to translate RTP packet", t);
            if (!(t instanceof ThreadDeath)) return;
            throw (ThreadDeath)t;
        }
        finally {
            OutputDataStreamImpl writeIndex = this;
            synchronized (writeIndex) {
                if (Thread.currentThread().equals(this.writeThread)) {
                    this.writeThread = null;
                }
                if (!this.closed && this.writeThread == null && this.writeQLength > 0) {
                    this.createWriteThread();
                }
            }
        }
    }

    private boolean willWriteControl(StreamRTPManagerDesc destination, byte[] buffer, int offset, int length, Format format, StreamRTPManagerDesc exclusion) {
        byte b0;
        int v;
        boolean write = true;
        if (length >= 12 && (v = ((b0 = buffer[offset]) & 0xC0) >>> 6) == 2) {
            int rtcpLength;
            byte b1 = buffer[offset + 1];
            int pt = b1 & 0xFF;
            int fmt = b0 & 0x1F;
            if ((pt == 205 || pt == 206) && (rtcpLength = (RTPTranslatorImpl.readUnsignedShort(buffer, offset + 2) + 1) * 4) <= length) {
                int ssrcOfMediaSource = 0;
                if (pt == 206 && fmt == 4) {
                    if (rtcpLength < 20) {
                        write = false;
                    } else {
                        ssrcOfMediaSource = RTPTranslatorImpl.readInt(buffer, offset + 12);
                    }
                } else {
                    ssrcOfMediaSource = RTPTranslatorImpl.readInt(buffer, offset + 8);
                }
                if (destination.containsReceiveSSRC(ssrcOfMediaSource)) {
                    if (logger.isTraceEnabled()) {
                        int ssrcOfPacketSender = RTPTranslatorImpl.readInt(buffer, offset + 4);
                        String message = this.getClass().getName() + ".willWriteControl: FMT " + fmt + ", PT " + pt + ", SSRC of packet sender " + Long.toString((long)ssrcOfPacketSender & 0xFFFFFFFFL) + ", SSRC of media source " + Long.toString((long)ssrcOfMediaSource & 0xFFFFFFFFL);
                        logger.trace(message);
                    }
                } else {
                    write = false;
                }
            }
        }
        if (write && logger.isTraceEnabled()) {
            RTPTranslatorImpl.logRTCP(this, "doWrite", buffer, offset, length);
        }
        return write;
    }

    private boolean willWriteData(StreamRTPManagerDesc destination, byte[] buf, int off, int len, Format format, StreamRTPManagerDesc exclusion) {
        if (!destination.streamRTPManager.getMediaStream().getDirection().allowsSending()) {
            return false;
        }
        if (format != null && len > 0) {
            Integer pt = destination.getPayloadType(format);
            if (pt == null && exclusion != null) {
                pt = exclusion.getPayloadType(format);
            }
            if (pt != null) {
                int ptByteIndex = off + 1;
                buf[ptByteIndex] = (byte)(buf[ptByteIndex] & 0x80 | pt & 0x7F);
            }
        }
        return true;
    }

    public int write(byte[] buf, int off, int len) {
        return this.doWrite(buf, off, len, null, null);
    }

    public synchronized void write(byte[] buf, int off, int len, Format format, StreamRTPManagerDesc exclusion) {
        byte[] data;
        int writeIndex;
        if (this.closed) {
            return;
        }
        if (this.writeQLength < this.writeQ.length) {
            writeIndex = (this.writeQHead + this.writeQLength) % this.writeQ.length;
        } else {
            writeIndex = this.writeQHead++;
            if (this.writeQHead >= this.writeQ.length) {
                this.writeQHead = 0;
            }
            --this.writeQLength;
            if (this.writeQStats != null) {
                this.writeQStats.remove(System.currentTimeMillis());
            }
            ++this.numDroppedPackets;
            if (RTPConnectorOutputStream.logDroppedPacket(this.numDroppedPackets)) {
                logger.warn("Dropped " + this.numDroppedPackets + " packets hashCode=" + this.hashCode() + "): ");
            }
        }
        RTPTranslatorBuffer write = this.writeQ[writeIndex];
        if (write == null) {
            this.writeQ[writeIndex] = write = new RTPTranslatorBuffer();
        }
        if ((data = write.data) == null || data.length < len) {
            write.data = data = new byte[len];
        }
        System.arraycopy(buf, off, data, 0, len);
        write.exclusion = exclusion;
        write.format = format;
        write.length = len;
        ++this.writeQLength;
        if (this.writeQStats != null) {
            this.writeQStats.add(System.currentTimeMillis());
        }
        if (this.writeThread == null) {
            this.createWriteThread();
        } else {
            this.notify();
        }
    }

    boolean writeControlPayload(Payload controlPayload, MediaStream destination) {
        List<OutputDataStreamDesc> streams = this._streams;
        int end = streams.size();
        for (int i = 0; i < end; ++i) {
            OutputDataStreamDesc s = streams.get(i);
            if (destination != s.connectorDesc.streamRTPManagerDesc.streamRTPManager.getMediaStream()) continue;
            controlPayload.writeTo(s.stream);
            return true;
        }
        return false;
    }
}

