/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.ircaccregwizz;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.java.sip.communicator.plugin.ircaccregwizz.FirstWizardPage;
import net.java.sip.communicator.plugin.ircaccregwizz.IrcAccRegWizzActivator;
import net.java.sip.communicator.plugin.ircaccregwizz.IrcAccountRegistration;
import net.java.sip.communicator.plugin.ircaccregwizz.Resources;
import net.java.sip.communicator.service.gui.DesktopAccountRegistrationWizard;
import net.java.sip.communicator.service.gui.WizardContainer;
import net.java.sip.communicator.service.gui.WizardPage;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.Logger;
import org.osgi.framework.ServiceReference;

public class IrcAccountRegistrationWizard
extends DesktopAccountRegistrationWizard {
    private static final int WIZARD_DIALOG_HEIGHT = 500;
    private static final int WIZARD_DIALOG_WIDTH = 600;
    public static final String CONTACT_PRESENCE_TASK = "CONTACT_PRESENCE_TASK";
    public static final String CHAT_ROOM_PRESENCE_TASK = "CHAT_ROOM_PRESENCE_TASK";
    public static final String SASL_ENABLED = "SASL_ENABLED";
    public static final String SASL_USERNAME = "SASL_USERNAME";
    public static final String SASL_ROLE = "SASL_ROLE";
    public static final String RESOLVE_DNS_THROUGH_PROXY = "RESOLVE_DNS_THROUGH_PROXY";
    private final Logger logger = Logger.getLogger(IrcAccountRegistrationWizard.class);
    private FirstWizardPage firstWizardPage;
    private IrcAccountRegistration registration = new IrcAccountRegistration();
    private ProtocolProviderService protocolProvider;

    public IrcAccountRegistrationWizard(WizardContainer wizardContainer) {
        this.setWizardContainer(wizardContainer);
        wizardContainer.setFinishButtonText(Resources.getString("service.gui.SIGN_IN"));
    }

    public byte[] getIcon() {
        return Resources.getImage(Resources.IRC_LOGO);
    }

    public byte[] getPageImage() {
        return Resources.getImage(Resources.PAGE_IMAGE);
    }

    public String getProtocolName() {
        return Resources.getString("plugin.ircaccregwizz.PROTOCOL_NAME");
    }

    public String getProtocolDescription() {
        return Resources.getString("plugin.ircaccregwizz.PROTOCOL_DESCRIPTION");
    }

    public Iterator<WizardPage> getPages() {
        ArrayList<FirstWizardPage> pages = new ArrayList<FirstWizardPage>();
        String userId = "";
        String server = "";
        if (this.firstWizardPage != null) {
            userId = this.firstWizardPage.getCurrentUserId();
            server = this.firstWizardPage.getCurrentServer();
        }
        this.firstWizardPage = new FirstWizardPage(this, userId, server);
        pages.add(this.firstWizardPage);
        return pages.iterator();
    }

    public Iterator<Map.Entry<String, String>> getSummary() {
        LinkedHashMap<String, String> summaryTable = new LinkedHashMap<String, String>();
        String pass = new String();
        String port = new String();
        pass = this.registration.isRequiredPassword() ? "required" : "not required";
        port = this.registration.getPort();
        if (!port.equals("")) {
            port = ":" + port;
        }
        String yes = Resources.getString("service.gui.YES");
        String no = Resources.getString("service.gui.NO");
        summaryTable.put(Resources.getString("plugin.ircaccregwizz.USERNAME"), this.registration.getUserID());
        summaryTable.put(Resources.getString("service.gui.PASSWORD"), pass);
        summaryTable.put(Resources.getString("plugin.ircaccregwizz.IRC_SERVER"), this.registration.getServer() + port);
        summaryTable.put(Resources.getString("plugin.ircaccregwizz.USE_SECURE_CONNECTION"), this.registration.isSecureConnection() ? yes : no);
        summaryTable.put(Resources.getString("plugin.ircaccregwizz.RESOLVE_DNS_THROUGH_PROXY"), this.registration.isResolveDnsThroughProxy() ? yes : no);
        summaryTable.put(Resources.getString("plugin.ircaccregwizz.ENABLE_CONTACT_PRESENCE"), this.registration.isContactPresenceTaskEnabled() ? yes : no);
        summaryTable.put(Resources.getString("plugin.ircaccregwizz.ENABLE_CHAT_ROOM_PRESENCE"), this.registration.isChatRoomPresenceTaskEnabled() ? yes : no);
        summaryTable.put(Resources.getString("plugin.ircaccregwizz.ENABLE_SASL_AUTHENTICATION"), this.registration.isSaslEnabled() ? yes : no);
        summaryTable.put("SASL " + Resources.getString("plugin.ircaccregwizz.USERNAME"), this.registration.getSaslUser());
        summaryTable.put("SASL " + Resources.getString("plugin.ircaccregwizz.SASL_AUTHZ_ROLE"), this.registration.getSaslRole());
        return summaryTable.entrySet().iterator();
    }

    public ProtocolProviderService signin() throws OperationFailedException {
        this.firstWizardPage.commitPage();
        String password = null;
        if (this.registration.isRememberPassword() && this.registration.isRequiredPassword()) {
            password = this.registration.getPassword();
        }
        return this.signin(this.registration.getUserID(), password);
    }

    public ProtocolProviderService signin(String userName, String password) throws OperationFailedException {
        ProtocolProviderFactory factory = IrcAccRegWizzActivator.getIrcProtocolProviderFactory();
        return this.installAccount(factory, userName, password);
    }

    private ProtocolProviderService installAccount(ProtocolProviderFactory providerFactory, String user, String password) throws OperationFailedException {
        Hashtable<String, String> accountProperties = new Hashtable<String, String>();
        accountProperties.put("SERVER_ADDRESS", this.registration.getServer());
        accountProperties.put("ACCOUNT_ICON_PATH", "resources/images/protocol/irc/irc32x32.png");
        if (password != null && !password.equals("")) {
            accountProperties.put("PASSWORD", this.registration.getPassword());
        }
        if (!this.registration.getPort().equals("")) {
            accountProperties.put("SERVER_PORT", this.registration.getPort());
        }
        accountProperties.put("AUTO_CHANGE_USER_NAME", Boolean.toString(this.registration.isAutoChangeNick()));
        accountProperties.put(RESOLVE_DNS_THROUGH_PROXY, Boolean.toString(this.registration.isResolveDnsThroughProxy()));
        accountProperties.put("NO_PASSWORD_REQUIRED", Boolean.toString(!this.registration.isRequiredPassword()));
        accountProperties.put("DEFAULT_ENCRYPTION", Boolean.toString(this.registration.isSecureConnection()).toString());
        accountProperties.put(CONTACT_PRESENCE_TASK, Boolean.toString(this.registration.isContactPresenceTaskEnabled()));
        accountProperties.put(CHAT_ROOM_PRESENCE_TASK, Boolean.toString(this.registration.isChatRoomPresenceTaskEnabled()));
        accountProperties.put(SASL_ENABLED, Boolean.toString(this.registration.isSaslEnabled()));
        accountProperties.put(SASL_USERNAME, this.registration.getSaslUser());
        accountProperties.put(SASL_ROLE, this.registration.getSaslRole());
        if (this.isModification()) {
            providerFactory.modifyAccount(this.protocolProvider, accountProperties);
            this.setModification(false);
            return this.protocolProvider;
        }
        try {
            AccountID accountID = providerFactory.installAccount(user, accountProperties);
            ServiceReference serRef = providerFactory.getProviderForAccount(accountID);
            this.protocolProvider = (ProtocolProviderService)IrcAccRegWizzActivator.bundleContext.getService(serRef);
        }
        catch (IllegalStateException exc) {
            this.logger.warn((Object)exc.getMessage());
            throw new OperationFailedException("Account already exists.", 10);
        }
        catch (Exception exc) {
            this.logger.warn((Object)exc.getMessage());
            throw new OperationFailedException("Failed to add account", 1);
        }
        return this.protocolProvider;
    }

    public void loadAccount(ProtocolProviderService protocolProvider) {
        this.setModification(true);
        this.protocolProvider = protocolProvider;
        this.registration = new IrcAccountRegistration();
        this.firstWizardPage.loadAccount(protocolProvider);
    }

    public IrcAccountRegistration getRegistration() {
        return this.registration;
    }

    public Dimension getSize() {
        return new Dimension(600, 500);
    }

    public Object getFirstPageIdentifier() {
        return this.firstWizardPage.getIdentifier();
    }

    public Object getLastPageIdentifier() {
        return this.firstWizardPage.getIdentifier();
    }

    public String getUserNameExample() {
        return FirstWizardPage.USER_NAME_EXAMPLE;
    }

    public boolean isSimpleFormEnabled() {
        return false;
    }

    public Object getSimpleForm(boolean isCreateAccount) {
        this.firstWizardPage = new FirstWizardPage(this, "", "");
        return this.firstWizardPage.getSimpleForm();
    }
}

