/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.misc;

import java.awt.Frame;

public class Alerter {
    private static Alerter _alerter;

    protected Alerter() {
    }

    public static Alerter newInstance() throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        if (_alerter == null) {
            String string = System.getProperty("os.name");
            if (string.toLowerCase().startsWith("mac os x")) {
                Alerter.loadMac();
            } else if (string.toLowerCase().startsWith("windows")) {
                Alerter.loadWin();
            } else if (string.toLowerCase().startsWith("linux")) {
                Alerter.loadLinux();
            } else {
                _alerter = new Alerter();
            }
        }
        return _alerter;
    }

    private static void loadMac() throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        _alerter = (Alerter)Class.forName("org.jdesktop.jdic.misc.impl.MacOSXAlerter").newInstance();
    }

    private static void loadWin() throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        _alerter = (Alerter)Class.forName("org.jdesktop.jdic.misc.impl.WinAlerter").newInstance();
    }

    private static void loadLinux() throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        _alerter = (Alerter)Class.forName("org.jdesktop.jdic.misc.impl.LinuxAlerter").newInstance();
    }

    public void alert(Frame frame) {
    }

    public boolean isAlertSupported() {
        return false;
    }
}

