/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icbm;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.OscarTools;
import net.kano.joscar.StringBlock;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.icbm.IcbmCommand;

public abstract class TypingCmd
extends IcbmCommand {
    public static final int NULLS_DEFAULT = 0;
    public static final int CODE_DEFAULT = 1;
    public static final int STATE_TYPING = 2;
    public static final int STATE_PAUSED = 1;
    public static final int STATE_NO_TEXT = 0;
    private final long nulls;
    private final int code;
    private final String sn;
    private final int typingState;

    protected TypingCmd(int command, SnacPacket packet) {
        super(command);
        DefensiveTools.checkNull(packet, "packet");
        ByteBlock snacData = packet.getData();
        this.nulls = BinaryTools.getLong(snacData, 0);
        this.code = BinaryTools.getUShort(snacData, 8);
        ByteBlock snBlock = snacData.subBlock(10);
        StringBlock snInfo = OscarTools.readScreenname(snBlock);
        this.sn = snInfo.getString();
        ByteBlock rest = snBlock.subBlock(snInfo.getTotalSize());
        this.typingState = BinaryTools.getUShort(rest, 0);
    }

    protected TypingCmd(int command, String sn, int typingState) {
        this(command, 0L, 1, sn, typingState);
    }

    protected TypingCmd(int command, long nulls, int code, String sn, int typingState) {
        super(command);
        DefensiveTools.checkRange(code, "code", 0);
        DefensiveTools.checkNull(sn, "sn");
        DefensiveTools.checkRange(typingState, "typingState", 0);
        this.nulls = nulls;
        this.code = code;
        this.sn = sn;
        this.typingState = typingState;
    }

    public final long getNullBlockValue() {
        return this.nulls;
    }

    public final int getCode() {
        return this.code;
    }

    public final String getScreenname() {
        return this.sn;
    }

    public final int getTypingState() {
        return this.typingState;
    }

    public void writeData(OutputStream out) throws IOException {
        BinaryTools.writeLong(out, this.nulls);
        BinaryTools.writeUShort(out, this.code);
        OscarTools.writeScreenname(out, this.sn);
        BinaryTools.writeUShort(out, this.typingState);
    }

    public String toString() {
        return MiscTools.getClassName(this) + " from " + this.sn + " (nulls=" + this.nulls + ", code=" + this.code + "): " + (this.typingState == 2 ? "typing" : (this.typingState == 1 ? "typed" : (this.typingState == 0 ? "no text" : "unknown: " + this.typingState)));
    }
}

