/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.icq;

import java.beans.PropertyChangeEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import net.java.sip.communicator.service.protocol.icqconstants.IcqStatusEnum;
import net.java.sip.communicator.slick.protocol.icq.FullUserInfoCmd;
import net.java.sip.communicator.slick.protocol.icq.IcqSlickFixture;
import net.java.sip.communicator.util.Logger;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.OscarTools;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snac.CmdType;
import net.kano.joscar.snac.SnacRequestAdapter;
import net.kano.joscar.snac.SnacRequestTimeoutEvent;
import net.kano.joscar.snac.SnacResponseEvent;
import net.kano.joscar.snac.SnacResponseListener;
import net.kano.joscar.snaccmd.ExtraInfoBlock;
import net.kano.joscar.snaccmd.FullUserInfo;
import net.kano.joscar.snaccmd.conn.SetExtraInfoCmd;
import net.kano.joscar.snaccmd.error.SnacError;
import net.kano.joscar.snaccmd.icbm.SendImIcbm;
import net.kano.joscar.snaccmd.loc.GetInfoCmd;
import net.kano.joscar.snaccmd.loc.UserInfoCmd;
import net.kano.joscar.snaccmd.ssi.CreateItemsCmd;
import net.kano.joscar.snaccmd.ssi.ItemsCmd;
import net.kano.joscar.snaccmd.ssi.ServerSsiCmdFactory;
import net.kano.joscar.snaccmd.ssi.SsiCommand;
import net.kano.joscar.snaccmd.ssi.SsiDataModResponse;
import net.kano.joscar.snaccmd.ssi.SsiItem;
import net.kano.joscar.tlv.Tlv;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.AimConnection;
import net.kano.joustsim.oscar.AimConnectionProperties;
import net.kano.joustsim.oscar.AimSession;
import net.kano.joustsim.oscar.BuddyInfo;
import net.kano.joustsim.oscar.BuddyInfoManager;
import net.kano.joustsim.oscar.BuddyInfoTrackerListener;
import net.kano.joustsim.oscar.DefaultAppSession;
import net.kano.joustsim.oscar.GlobalBuddyInfoListener;
import net.kano.joustsim.oscar.State;
import net.kano.joustsim.oscar.StateEvent;
import net.kano.joustsim.oscar.StateListener;
import net.kano.joustsim.oscar.oscar.service.bos.MainBosService;
import net.kano.joustsim.oscar.oscar.service.bos.MainBosServiceListener;
import net.kano.joustsim.oscar.oscar.service.buddy.BuddyService;
import net.kano.joustsim.oscar.oscar.service.buddy.BuddyServiceListener;
import net.kano.joustsim.oscar.oscar.service.icbm.ConversationListener;
import net.kano.joustsim.oscar.oscar.service.icbm.IcbmService;
import net.kano.joustsim.oscar.oscar.service.icbm.SimpleMessage;
import net.kano.joustsim.oscar.oscar.service.icbm.TypingListener;
import net.kano.joustsim.oscar.oscar.service.icbm.TypingState;
import net.kano.joustsim.oscar.oscar.service.ssi.Buddy;
import net.kano.joustsim.oscar.oscar.service.ssi.BuddyList;
import net.kano.joustsim.oscar.oscar.service.ssi.BuddyListLayoutListener;
import net.kano.joustsim.oscar.oscar.service.ssi.Group;
import net.kano.joustsim.oscar.oscar.service.ssi.GroupListener;
import net.kano.joustsim.oscar.oscar.service.ssi.MutableBuddyList;
import net.kano.joustsim.oscar.oscar.service.ssi.MutableGroup;

public class IcqTesterAgent {
    private static final Logger logger = Logger.getLogger(IcqTesterAgent.class);
    private IcbmService icbmService = null;
    private AimConnection conn = null;
    private Object connectionLock = new Object();
    public static final long ICQ_ONLINE_MASK = 0x1000000L;
    private boolean registered = false;
    private Screenname icqUIN = null;
    private AuthCmdFactory authCmdFactory = new AuthCmdFactory();
    private RetroListener rl = new RetroListener();

    IcqTesterAgent(String icqUinString) {
        this.icqUIN = new Screenname(icqUinString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean register(String password) {
        if (this.registered || IcqSlickFixture.onlineTestingDisabled) {
            return true;
        }
        DefaultAppSession session = new DefaultAppSession();
        AimSession aimSession = session.openAimSession(this.icqUIN);
        aimSession.openConnection(new AimConnectionProperties(this.icqUIN, password));
        this.conn = aimSession.getConnection();
        this.conn.addStateListener(new AimConnStateListener());
        this.conn.getBuddyInfoManager().addGlobalBuddyInfoListener(new GlobalBuddyListener());
        this.conn.connect();
        Object object = this.connectionLock;
        synchronized (object) {
            try {
                this.connectionLock.wait(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.icbmService == null) {
            this.registered = false;
            return false;
        }
        this.conn.getBuddyService().addBuddyListener(new BuddyListener());
        this.registered = true;
        return true;
    }

    public void initializeBuddyList(Hashtable<String, List<String>> listContents) {
        logger.debug((Object)("Will Create the following contact list:\n" + listContents));
        MutableBuddyList joustSimBuddyList = this.conn.getSsiService().getBuddyList();
        List<? extends Group> groups = joustSimBuddyList.getGroups();
        for (Group group : groups) {
            joustSimBuddyList.deleteGroupAndBuddies(group);
        }
        Enumeration<String> enumeration = listContents.keys();
        LayoutEventCollector evtCollector = new LayoutEventCollector();
        while (enumeration.hasMoreElements()) {
            String groupName = enumeration.nextElement();
            logger.debug((Object)("Will add group " + groupName));
            evtCollector.addedGroups.removeAllElements();
            joustSimBuddyList.addLayoutListener(evtCollector);
            joustSimBuddyList.addGroup(groupName);
            evtCollector.waitForANewGroup(10000);
            joustSimBuddyList.removeLayoutListener(evtCollector);
            MutableGroup newlyCreatedGroup = null;
            if (evtCollector.addedGroups.size() == 0 || (newlyCreatedGroup = (MutableGroup)evtCollector.addedGroups.get(0)) == null) {
                throw new NullPointerException("Couldn't create group " + groupName);
            }
            for (String screenname : listContents.get(groupName)) {
                evtCollector.addedBuddies.removeAllElements();
                joustSimBuddyList.addLayoutListener(evtCollector);
                logger.debug((Object)("Will add buddy " + screenname));
                newlyCreatedGroup.addBuddy(screenname);
                evtCollector.waitForANewBuddy(10000);
                joustSimBuddyList.removeLayoutListener(evtCollector);
                if (evtCollector.addedBuddies.size() != 0 && evtCollector.addedBuddies.get(0) != null || this.findBuddyInBuddyList(joustSimBuddyList, screenname) != null) continue;
                throw new NullPointerException("Couldn't add buddy " + screenname);
            }
        }
    }

    public void sendTypingNotification(String buddy, TypingState state) {
        this.conn.getIcbmService().getImConversation(new Screenname(buddy)).setTypingState(state);
    }

    public void addTypingStateInfoListenerForBuddy(String buddy, ConversationListener l) throws ClassCastException {
        if (!(l instanceof TypingListener)) {
            throw new ClassCastException("In order to receive typing notifications a typing listener needs to also implement " + TypingListener.class.getName());
        }
        this.conn.getIcbmService().getImConversation(new Screenname(buddy)).addConversationListener(l);
    }

    public void removeTypingStateInfoListenerForBuddy(String buddy, ConversationListener l) {
        this.conn.getIcbmService().getImConversation(new Screenname(buddy)).removeConversationListener(l);
    }

    public void sendMessage(String buddy, String body) {
        this.conn.getIcbmService().getImConversation(new Screenname(buddy)).sendMessage(new SimpleMessage(body));
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void addConversationListener(String buddy, ConversationListener listener) {
        this.conn.getIcbmService().getImConversation(new Screenname(buddy)).addConversationListener(listener);
    }

    public void removeConversationListener(String buddy, ConversationListener listener) {
        this.conn.getIcbmService().getImConversation(new Screenname(buddy)).removeConversationListener(listener);
    }

    private Buddy findBuddyInBuddyList(BuddyList list, String screenname) {
        for (Group group : list.getGroups()) {
            for (Buddy buddy : group.getBuddiesCopy()) {
                if (!buddy.getScreenname().getFormatted().equals(screenname)) continue;
                return buddy;
            }
        }
        return null;
    }

    public void unregister() {
        if (!this.registered) {
            return;
        }
        this.conn.disconnect(true);
        this.registered = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IcqStatusEnum getBuddyStatus(String screenname) throws IllegalStateException {
        if (!this.registered) {
            throw new IllegalStateException("You need to register before querying a buddy's status");
        }
        StatusResponseRetriever responseRetriever = new StatusResponseRetriever();
        GetInfoCmd getInfoCmd = new GetInfoCmd(23L, new Screenname(screenname).getFormatted());
        this.conn.getInfoService().getOscarConnection().sendSnacRequest(getInfoCmd, responseRetriever);
        Object object = responseRetriever.waitingForResponseLock;
        synchronized (object) {
            try {
                logger.debug((Object)("waiting to receive status for " + screenname));
                responseRetriever.waitingForResponseLock.wait(100000L);
            }
            catch (InterruptedException ex) {
                logger.debug((Object)"Couldn't wait upon a response retriver", (Throwable)ex);
            }
        }
        logger.debug((Object)("Done. we'll return status " + responseRetriever.status));
        return responseRetriever.status == null ? IcqStatusEnum.OFFLINE : responseRetriever.status;
    }

    private static IcqStatusEnum icqStatusLongToString(long icqStatus, IcqStatusEnum returnOnMinus1) {
        if (icqStatus == -1L) {
            return returnOnMinus1;
        }
        if ((icqStatus & 1L) != 0L) {
            return IcqStatusEnum.AWAY;
        }
        if ((icqStatus & 2L) != 0L) {
            return IcqStatusEnum.DO_NOT_DISTURB;
        }
        if ((icqStatus & 0x20L) != 0L) {
            return IcqStatusEnum.FREE_FOR_CHAT;
        }
        if ((icqStatus & 0x100L) != 0L) {
            return IcqStatusEnum.INVISIBLE;
        }
        if ((icqStatus & 4L) != 0L) {
            return IcqStatusEnum.NOT_AVAILABLE;
        }
        if ((icqStatus & 0x10L) != 0L) {
            return IcqStatusEnum.OCCUPIED;
        }
        if ((icqStatus & 0x1000000L) == 0L) {
            return IcqStatusEnum.OFFLINE;
        }
        return IcqStatusEnum.ONLINE;
    }

    public String getIcqUIN() {
        return this.icqUIN.getFormatted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enterStatus(long icqStatus) {
        BosEventNotifier bosEventNotifier = new BosEventNotifier();
        this.conn.getBosService().addMainBosServiceListener(bosEventNotifier);
        Object object = bosEventNotifier.infoLock;
        synchronized (object) {
            this.conn.getBosService().getOscarConnection().sendSnac(new SetExtraInfoCmd(icqStatus));
            try {
                bosEventNotifier.infoLock.wait(10000L);
            }
            catch (InterruptedException ex) {
                logger.debug((Object)"Strange!");
            }
            this.conn.getBosService().removeMainBosServiceListener(bosEventNotifier);
            if (bosEventNotifier.lastUserInfo == null) {
                logger.debug((Object)"Status change was not confirmed by AIM server.");
                return false;
            }
            return true;
        }
    }

    public IcqStatusEnum getPresneceStatus() {
        return this.getBuddyStatus(this.getIcqUIN());
    }

    public AuthCmdFactory getAuthCmdFactory() {
        return this.authCmdFactory;
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) throws Throwable {
        void var6_8;
        java.util.logging.Logger.getLogger("net.kano").setLevel(Level.FINEST);
        IcqTesterAgent icqtests = new IcqTesterAgent("319305099");
        if (!icqtests.register("6pC0mmtt")) {
            System.out.println("registration failed");
            return;
        }
        Thread.sleep(1000L);
        icqtests.conn.getSsiService().getBuddyList().addRetroactiveLayoutListener(icqtests.rl);
        Thread.sleep(1000L);
        System.out.println("\n\nr u ready?");
        Thread.sleep(3000L);
        java.util.logging.Logger.getLogger("net.kano").setLevel(Level.FINEST);
        MutableBuddyList list = icqtests.conn.getSsiService().getBuddyList();
        MutableGroup grpGroup = null;
        Buddy buddyToMove = null;
        for (Group group : list.getGroups()) {
            if (group.getName().equals("grp")) {
                grpGroup = (MutableGroup)group;
            }
            List<? extends Buddy> buddies = group.getBuddiesCopy();
            System.out.println("Printing buddies for group " + group.getName());
            Thread.sleep(1000L);
            for (Buddy buddy : buddies) {
                System.out.println(buddy.getScreenname());
                if (!buddy.getScreenname().getFormatted().equals("201345337")) continue;
                buddyToMove = buddy;
            }
        }
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println("will move buddyyyyyyyyyy");
        Thread.sleep(5000L);
        ArrayList<Buddy> listToMove = new ArrayList<Buddy>();
        listToMove.add(buddyToMove);
        list.moveBuddies(listToMove, grpGroup);
        System.out.println("MOved i sega triabva da doidat eventi ");
        Thread.sleep(50000L);
        Object var6_7 = null;
        for (Group group : list.getGroups()) {
            List<? extends Buddy> list2 = group.getBuddiesCopy();
            for (Buddy buddy : list2) {
                if (!buddy.getScreenname().getFormatted().equals("201345337")) continue;
                Buddy buddy2 = buddy;
            }
        }
        if (buddyToMove == var6_8) {
            System.out.println("hahaha");
        }
    }

    public void deleteBuddy(String screenname) {
        logger.debug((Object)("Will delete buddy : " + screenname));
        MutableBuddyList joustSimBuddyList = this.conn.getSsiService().getBuddyList();
        LayoutEventCollector evtCollector = new LayoutEventCollector();
        joustSimBuddyList.addLayoutListener(evtCollector);
        List<? extends Group> grList = joustSimBuddyList.getGroups();
        boolean isDeleted = false;
        for (MutableGroup mutableGroup : grList) {
            List<? extends Buddy> bs = mutableGroup.getBuddiesCopy();
            for (Buddy buddy : bs) {
                if (!buddy.getScreenname().getFormatted().equals(screenname)) continue;
                mutableGroup.deleteBuddy(buddy);
                isDeleted = true;
            }
            if (!isDeleted) continue;
            break;
        }
        if (isDeleted) {
            evtCollector.waitForRemovedBuddy(10000);
        }
        joustSimBuddyList.removeLayoutListener(evtCollector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void addBuddy(String screenname) {
        Object lock;
        void var5_9;
        logger.debug((Object)("Will add buddy : " + screenname));
        MutableBuddyList joustSimBuddyList = this.conn.getSsiService().getBuddyList();
        List<? extends Group> grList = joustSimBuddyList.getGroups();
        for (MutableGroup mutableGroup : grList) {
            logger.debug((Object)("group : " + mutableGroup));
            List<? extends Buddy> bs = mutableGroup.getBuddiesCopy();
            for (Buddy buddy : bs) {
                logger.debug((Object)("buddy : " + buddy));
            }
        }
        Object var5_6 = null;
        if (grList.size() < 1) {
            MutableGroup mutableGroup;
            logger.debug((Object)"No groups! Will stop now");
            LayoutEventCollector evtCollector = new LayoutEventCollector();
            String groupName = "test-group";
            logger.debug((Object)("Will add group " + groupName));
            joustSimBuddyList.addLayoutListener(evtCollector);
            joustSimBuddyList.addGroup(groupName);
            evtCollector.waitForANewGroup(10000);
            joustSimBuddyList.removeLayoutListener(evtCollector);
            if (evtCollector.addedGroups.size() == 0 || (mutableGroup = (MutableGroup)evtCollector.addedGroups.get(0)) == null) {
                throw new NullPointerException("Couldn't create group " + groupName);
            }
        } else {
            MutableGroup mutableGroup = (MutableGroup)grList.get(0);
        }
        var5_9.addBuddy(screenname);
        Object object = lock = new Object();
        synchronized (object) {
            try {
                lock.wait(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void sendOfflineMessage(String buddy, String body) {
        this.conn.sendSnac(new OfflineSnacCmd(buddy, body));
    }

    void sendAuthorizationReplay(String uin, String reasonStr, boolean isAccpeted) {
        this.conn.sendSnac(new AuthReplyCmd(uin, reasonStr, isAccpeted));
    }

    public void setAuthorizationRequired() {
        logger.debug((Object)"sending auth required");
        FullUserInfoCmd cmd = new FullUserInfoCmd(this.getIcqUIN());
        cmd.writeOutByte(780, 0);
        cmd.writeOutByte(760, 0);
        this.conn.getSsiService().getOscarConnection().sendSnac(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<String, Object> getUserInfo(String uin) {
        UserInfoResponse response = new UserInfoResponse();
        this.conn.getInfoService().getOscarConnection().sendSnacRequest(FullUserInfoCmd.getFullInfoRequestCommand(this.getIcqUIN(), uin), response);
        UserInfoResponse userInfoResponse = response;
        synchronized (userInfoResponse) {
            try {
                response.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return response.info;
    }

    public void setUserInfoLastName(String lastName) {
        FullUserInfoCmd cmd = new FullUserInfoCmd(this.getIcqUIN());
        cmd.writeOutString(330, lastName);
        this.conn.getSsiService().getOscarConnection().sendSnac(cmd);
    }

    public void setUserInfoPhoneNumber(String phone) {
        FullUserInfoCmd cmd = new FullUserInfoCmd(this.getIcqUIN());
        cmd.writeOutString(630, phone);
        this.conn.getSsiService().getOscarConnection().sendSnac(cmd);
    }

    public void setUserInfoLanguage(int language1, int language2, int language3) {
        FullUserInfoCmd cmd = new FullUserInfoCmd(this.getIcqUIN());
        cmd.writeOutShort(390, language1);
        cmd.writeOutShort(390, language2);
        cmd.writeOutShort(390, language3);
        this.conn.getSsiService().getOscarConnection().sendSnac(cmd);
    }

    public void setUserInfoHomeCountry(int countryCode) {
        FullUserInfoCmd cmd = new FullUserInfoCmd(this.getIcqUIN());
        cmd.writeOutShort(420, countryCode);
        this.conn.getSsiService().getOscarConnection().sendSnac(cmd);
    }

    private static class BuddyAwaitingAuth
    extends SsiItem {
        private SsiItem originalItem = null;

        public BuddyAwaitingAuth(SsiItem originalItem) {
            super(originalItem.getName(), originalItem.getParentId(), originalItem.getId(), originalItem.getItemType(), BuddyAwaitingAuth.getSpecTlvData());
            this.originalItem = originalItem;
        }

        @Override
        public void write(OutputStream out) throws IOException {
            byte[] namebytes = BinaryTools.getAsciiBytes(this.originalItem.getName());
            BinaryTools.writeUShort(out, namebytes.length);
            out.write(namebytes);
            BinaryTools.writeUShort(out, this.originalItem.getParentId());
            BinaryTools.writeUShort(out, this.originalItem.getId());
            BinaryTools.writeUShort(out, this.originalItem.getItemType());
            ByteBlock data = this.getData();
            int len = data == null ? 0 : data.getLength();
            BinaryTools.writeUShort(out, len);
            if (data != null) {
                data.write(out);
            }
        }

        private static ByteBlock getSpecTlvData() {
            try {
                ByteArrayOutputStream o = new ByteArrayOutputStream();
                new Tlv(102).write(o);
                ByteBlock block = ByteBlock.wrap(o.toByteArray());
                return block;
            }
            catch (IOException ex) {
                logger.error((Object)"Error creating buddy awaiting auth tlv", (Throwable)ex);
                return null;
            }
        }
    }

    private class UserInfoResponse
    extends SnacRequestAdapter {
        Hashtable<String, Object> info = null;

        private UserInfoResponse() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleResponse(SnacResponseEvent e) {
            if (e.getSnacCommand() instanceof FullUserInfoCmd) {
                FullUserInfoCmd cmd = (FullUserInfoCmd)e.getSnacCommand();
                if (cmd.lastOfSequences) {
                    this.info = cmd.getInfo();
                    UserInfoResponse userInfoResponse = this;
                    synchronized (userInfoResponse) {
                        this.notifyAll();
                    }
                }
            }
        }
    }

    private class RequestAuthCmd
    extends SsiCommand {
        String uin;
        String reason;

        public RequestAuthCmd(String uin, String reason) {
            super(24);
            this.uin = uin;
            this.reason = reason;
        }

        public RequestAuthCmd(SnacPacket packet) {
            super(25);
            ByteBlock messageData = packet.getData();
            int offset = 0;
            short uinLen = BinaryTools.getUByte(messageData, offset);
            this.uin = OscarTools.getString(messageData.subBlock(++offset, uinLen), "US-ASCII");
            int reasonLen = BinaryTools.getUShort(messageData, offset += uinLen);
            this.reason = OscarTools.getString(messageData.subBlock(offset += 2, reasonLen), "US-ASCII");
        }

        @Override
        public void writeData(OutputStream out) throws IOException {
            byte[] uinBytes = BinaryTools.getAsciiBytes(this.uin);
            BinaryTools.writeUByte(out, uinBytes.length);
            out.write(uinBytes);
            if (this.reason == null) {
                this.reason = "";
            }
            byte[] reasonBytes = BinaryTools.getAsciiBytes(this.reason);
            BinaryTools.writeUShort(out, reasonBytes.length);
            out.write(reasonBytes);
        }
    }

    public class AuthCmdFactory
    extends ServerSsiCmdFactory
    implements SnacResponseListener {
        List<CmdType> SUPPORTED_TYPES = null;
        public String responseReasonStr = null;
        public String requestReasonStr = null;
        public boolean ACCEPT = false;
        public boolean isErrorAddingReceived = false;
        public boolean isRequestAccepted = false;

        public AuthCmdFactory() {
            List<CmdType> types = super.getSupportedTypes();
            ArrayList<CmdType> tempTypes = new ArrayList<CmdType>(types);
            tempTypes.add(new CmdType(19, 27));
            tempTypes.add(new CmdType(19, 25));
            this.SUPPORTED_TYPES = DefensiveTools.getUnmodifiable(tempTypes);
        }

        @Override
        public List<CmdType> getSupportedTypes() {
            return this.SUPPORTED_TYPES;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SnacCommand genSnacCommand(SnacPacket packet) {
            int command = packet.getCommand();
            if (command == 25) {
                Object lock;
                RequestAuthCmd cmd = new RequestAuthCmd(packet);
                this.requestReasonStr = cmd.reason;
                Object object = lock = new Object();
                synchronized (object) {
                    try {
                        lock.wait(2000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                logger.trace((Object)("sending authorization " + this.ACCEPT));
                IcqTesterAgent.this.sendAuthorizationReplay(String.valueOf(cmd.uin), this.responseReasonStr, this.ACCEPT);
                return cmd;
            }
            if (command == 27) {
                AuthReplyCmd cmd = new AuthReplyCmd(packet);
                this.isRequestAccepted = cmd.accepted;
                this.responseReasonStr = cmd.reason;
                return cmd;
            }
            return super.genSnacCommand(packet);
        }

        @Override
        public void handleResponse(SnacResponseEvent e) {
            if (e.getSnacCommand() instanceof SsiDataModResponse) {
                SsiDataModResponse dataModResponse = (SsiDataModResponse)e.getSnacCommand();
                int[] results = dataModResponse.getResults();
                List<SsiItem> items = ((ItemsCmd)e.getRequest().getCommand()).getItems();
                items = new LinkedList<SsiItem>(items);
                for (int i = 0; i < results.length; ++i) {
                    int result = results[i];
                    if (result != 14) continue;
                    this.isErrorAddingReceived = true;
                    SsiItem buddyItem = items.get(i);
                    String uinToAskForAuth = buddyItem.getName();
                    Vector<BuddyAwaitingAuth> buddiesToBeAdded = new Vector<BuddyAwaitingAuth>();
                    BuddyAwaitingAuth newBuddy = new BuddyAwaitingAuth(buddyItem);
                    buddiesToBeAdded.add(newBuddy);
                    CreateItemsCmd addCMD = new CreateItemsCmd(buddiesToBeAdded);
                    logger.trace((Object)("Adding buddy as awaiting authorization " + uinToAskForAuth));
                    MutableBuddyList joustSimBuddyList = IcqTesterAgent.this.conn.getSsiService().getBuddyList();
                    LayoutEventCollector evtCollector = new LayoutEventCollector();
                    joustSimBuddyList.addLayoutListener(evtCollector);
                    IcqTesterAgent.this.conn.getSsiService().getOscarConnection().sendSnac(addCMD);
                    evtCollector.waitForANewBuddy(20000);
                    joustSimBuddyList.removeLayoutListener(evtCollector);
                    logger.trace((Object)"Finished - Adding buddy as awaiting authorization");
                    IcqTesterAgent.this.conn.getSsiService().getOscarConnection().sendSnac(new RequestAuthCmd(uinToAskForAuth, this.requestReasonStr));
                }
            }
        }
    }

    private class AuthReplyCmd
    extends SsiCommand {
        private int FLAG_AUTH_ACCEPTED;
        private int FLAG_AUTH_DECLINED;
        private String uin;
        private String reason;
        private boolean accepted;

        public AuthReplyCmd(SnacPacket packet) {
            super(27);
            this.FLAG_AUTH_ACCEPTED = 1;
            this.FLAG_AUTH_DECLINED = 0;
            this.uin = null;
            this.reason = null;
            this.accepted = false;
            ByteBlock messageData = packet.getData();
            int offset = 0;
            short uinLen = BinaryTools.getUByte(messageData, offset++);
            this.uin = OscarTools.getString(messageData.subBlock(offset, uinLen), "US-ASCII");
            offset += uinLen;
            this.accepted = BinaryTools.getUByte(messageData, offset++) == 1;
            int reasonLen = BinaryTools.getUShort(messageData, offset);
            this.reason = OscarTools.getString(messageData.subBlock(offset += 2, reasonLen), "US-ASCII");
        }

        public AuthReplyCmd(String uin, String reason, boolean accepted) {
            super(26);
            this.FLAG_AUTH_ACCEPTED = 1;
            this.FLAG_AUTH_DECLINED = 0;
            this.uin = null;
            this.reason = null;
            this.accepted = false;
            this.uin = uin;
            this.reason = reason;
            this.accepted = accepted;
        }

        @Override
        public void writeData(OutputStream out) throws IOException {
            byte[] uinBytes = BinaryTools.getAsciiBytes(this.uin);
            BinaryTools.writeUByte(out, uinBytes.length);
            out.write(uinBytes);
            if (this.accepted) {
                BinaryTools.writeUByte(out, this.FLAG_AUTH_ACCEPTED);
            } else {
                BinaryTools.writeUByte(out, this.FLAG_AUTH_DECLINED);
            }
            if (this.reason == null) {
                this.reason = "";
            }
            byte[] reasonBytes = BinaryTools.getAsciiBytes(this.reason);
            BinaryTools.writeUShort(out, reasonBytes.length);
            out.write(reasonBytes);
        }
    }

    private class OfflineSnacCmd
    extends SendImIcbm {
        private static final int TYPE_OFFLINE = 6;

        protected OfflineSnacCmd(String sn, String message) {
            super(sn, message);
        }

        @Override
        protected void writeChannelData(OutputStream out) throws IOException {
            super.writeChannelData(out);
            new Tlv(6).write(out);
        }
    }

    private class RetroListener
    implements BuddyListLayoutListener,
    GroupListener {
        private RetroListener() {
        }

        @Override
        public void groupsReordered(BuddyList list, List<? extends Group> oldOrder, List<? extends Group> newOrder) {
            System.out.println("        RetroListener.groupReordered");
        }

        @Override
        public void groupAdded(BuddyList list, List<? extends Group> oldItems, List<? extends Group> newItems, Group group, List<? extends Buddy> buddies) {
            System.out.println("RetroListener.groupAdded");
            System.out.println("    group.name is=" + group.getName());
            System.out.println("index=" + newItems.indexOf(group));
            for (int i = 0; i < buddies.size(); ++i) {
                System.out.println("        buddy is=" + buddies.get(i).getScreenname().getFormatted());
                Buddy b = buddies.get(i);
                IcqTesterAgent.this.conn.getBuddyInfoTracker().addTracker(b.getScreenname(), new BuddyInfoTrackerListener(){});
            }
            group.addGroupListener(this);
        }

        @Override
        public void groupRemoved(BuddyList list, List<? extends Group> oldItems, List<? extends Group> newItems, Group group) {
            System.out.println("        RetroListener.groupRemoved");
        }

        @Override
        public void buddyAdded(BuddyList list, Group group, List<? extends Buddy> oldItems, List<? extends Buddy> newItems, Buddy buddy) {
            System.out.println("        RetroListener.buddyAdded=" + buddy);
        }

        @Override
        public void buddyRemoved(BuddyList list, Group group, List<? extends Buddy> oldItems, List<? extends Buddy> newItems, Buddy buddy) {
            System.out.println("        RetroListener.buddyRemoved" + buddy);
        }

        @Override
        public void buddiesReordered(BuddyList list, Group group, List<? extends Buddy> oldBuddies, List<? extends Buddy> newBuddies) {
            System.out.println("        RetroListener.buddiesReordered");
        }

        @Override
        public void groupNameChanged(Group group, String oldName, String newName) {
            System.out.println("        RetroListener.GroupListener.groupNameChanged. old is=" + oldName + " new is=" + newName + " group is=" + group.getName());
            System.out.println("GroupContains=" + group.getBuddiesCopy());
        }
    }

    private class GlobalBuddyListener
    implements GlobalBuddyInfoListener {
        private GlobalBuddyListener() {
        }

        @Override
        public void buddyInfoChanged(BuddyInfoManager manager, Screenname buddy, BuddyInfo info, PropertyChangeEvent event) {
            System.out.println("GlobalBuddyListener.buddyInfoChanged: propN= " + event.getPropertyName() + " for buddy: " + buddy.toString() + " info.isOnline()= " + info.isOnline() + " info.statusMessage=" + info.getStatusMessage() + " info.statusMessage=" + info.getAwayMessage());
            System.out.println("info=" + info);
        }

        @Override
        public void newBuddyInfo(BuddyInfoManager manager, Screenname buddy, BuddyInfo info) {
            System.out.println("GlobalBuddyListener.newBuddyInfo: " + buddy.toString() + " info.isOnline()= " + info.isOnline() + " info.statusMessage=" + info.getStatusMessage() + " info.statusMessage=" + info.getAwayMessage());
            System.out.println("info=" + info);
        }

        @Override
        public void receivedStatusUpdate(BuddyInfoManager manager, Screenname buddy, BuddyInfo info) {
            System.out.println("GlobalBuddyListener.receivedStatusUpdate " + buddy.toString() + " info.isOnline()= " + info.isOnline() + " info.statusMessage=" + info.getStatusMessage() + " info.statusMessage=" + info.getAwayMessage());
            System.out.println("info=" + info);
        }
    }

    private class BuddyListener
    implements BuddyServiceListener {
        private BuddyListener() {
        }

        @Override
        public void gotBuddyStatus(BuddyService service, Screenname buddy, FullUserInfo info) {
            System.out.println("BuddyListener.gotBuddyStatus " + buddy.toString() + " and status is : " + info.getIcqStatus());
            List<ExtraInfoBlock> eInfoBlocks = info.getExtraInfoBlocks();
            if (eInfoBlocks != null) {
                System.out.println("printing extra info blocks (" + eInfoBlocks.size() + ")");
                for (ExtraInfoBlock block : eInfoBlocks) {
                    System.out.println("block.toString()=" + block);
                }
            } else {
                logger.trace((Object)"no extra info.");
            }
        }

        @Override
        public void buddyOffline(BuddyService service, Screenname buddy) {
            System.out.println("BuddyListener.buddyOffline " + buddy.toString());
        }
    }

    private class LayoutEventCollector
    implements BuddyListLayoutListener {
        public Vector<Group> addedGroups = new Vector();
        public Vector<Buddy> addedBuddies = new Vector();
        public Vector<Buddy> removedBuddies = new Vector();

        private LayoutEventCollector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForANewBuddy(int milliseconds) {
            Vector<Buddy> vector = this.addedBuddies;
            synchronized (vector) {
                if (!this.addedBuddies.isEmpty()) {
                    return;
                }
                try {
                    this.addedBuddies.wait(milliseconds);
                }
                catch (InterruptedException ex) {
                    logger.warn((Object)"A strange thing happened while waiting", (Throwable)ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForANewGroup(int milliseconds) {
            Vector<Group> vector = this.addedGroups;
            synchronized (vector) {
                if (!this.addedGroups.isEmpty()) {
                    return;
                }
                try {
                    this.addedGroups.wait(milliseconds);
                }
                catch (InterruptedException ex) {
                    logger.warn((Object)"A strange thing happened while waiting", (Throwable)ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForRemovedBuddy(int milliseconds) {
            Vector<Buddy> vector = this.removedBuddies;
            synchronized (vector) {
                if (!this.removedBuddies.isEmpty()) {
                    return;
                }
                try {
                    this.removedBuddies.wait(milliseconds);
                }
                catch (InterruptedException ex) {
                    logger.warn((Object)"A strange thing happened while waiting", (Throwable)ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void groupAdded(BuddyList list, List<? extends Group> oldItems, List<? extends Group> newItems, Group group, List<? extends Buddy> buddies) {
            logger.debug((Object)("A group was added gname is=" + group.getName()));
            Vector<Group> vector = this.addedGroups;
            synchronized (vector) {
                this.addedGroups.add(group);
                this.addedGroups.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void buddyAdded(BuddyList list, Group group, List<? extends Buddy> oldItems, List<? extends Buddy> newItems, Buddy buddy) {
            logger.debug((Object)("A buddy (" + buddy.getScreenname() + ")was added to group " + group.getName()));
            Vector<Buddy> vector = this.addedBuddies;
            synchronized (vector) {
                this.addedBuddies.add(buddy);
                this.addedBuddies.notifyAll();
            }
        }

        @Override
        public void groupsReordered(BuddyList list, List<? extends Group> oldOrder, List<? extends Group> newOrder) {
            logger.debug((Object)"groupsReordered");
        }

        @Override
        public void groupRemoved(BuddyList list, List<? extends Group> oldItems, List<? extends Group> newItems, Group group) {
            logger.debug((Object)("removedGroup=" + group.getName()));
        }

        @Override
        public void buddyRemoved(BuddyList list, Group group, List<? extends Buddy> oldItems, List<? extends Buddy> newItems, Buddy buddy) {
            logger.debug((Object)("removed buddy=" + buddy));
        }

        @Override
        public void buddiesReordered(BuddyList list, Group group, List<? extends Buddy> oldBuddies, List<? extends Buddy> newBuddies) {
            logger.debug((Object)("buddiesReordered in group " + group.getName()));
        }
    }

    private static class BosEventNotifier
    implements MainBosServiceListener {
        public Object extraInfoLock = new Object();
        public Object infoLock = new Object();
        public FullUserInfo lastUserInfo = null;

        private BosEventNotifier() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleYourExtraInfo(List<ExtraInfoBlock> extraInfos) {
            logger.debug((Object)("Bosiat.extrainfo=" + extraInfos));
            Object object = this.extraInfoLock;
            synchronized (object) {
                this.extraInfoLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleYourInfo(MainBosService service, FullUserInfo userInfo) {
            logger.debug((Object)("Bosiat.yourinfo=" + userInfo));
            Object object = this.infoLock;
            synchronized (object) {
                this.lastUserInfo = userInfo;
                this.infoLock.notifyAll();
            }
        }
    }

    private static class StatusResponseRetriever
    extends SnacRequestAdapter {
        private boolean ran = false;
        private IcqStatusEnum status = null;
        public Object waitingForResponseLock = new Object();

        private StatusResponseRetriever() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleResponse(SnacResponseEvent e) {
            SnacCommand snac = e.getSnacCommand();
            logger.debug((Object)("Received a response to our status request: " + snac));
            Object object = this;
            synchronized (object) {
                if (this.ran) {
                    return;
                }
                this.ran = true;
            }
            if (snac instanceof UserInfoCmd) {
                UserInfoCmd uic = (UserInfoCmd)snac;
                FullUserInfo userInfo = uic.getUserInfo();
                if (userInfo != null) {
                    this.status = IcqTesterAgent.icqStatusLongToString(userInfo.getIcqStatus(), IcqStatusEnum.ONLINE);
                    logger.debug((Object)("status is " + this.status + "=" + userInfo.getIcqStatus()));
                    List<ExtraInfoBlock> eInfoBlocks = userInfo.getExtraInfoBlocks();
                    if (eInfoBlocks != null) {
                        System.out.println("printing extra info blocks (" + eInfoBlocks.size() + ")");
                        for (ExtraInfoBlock block : eInfoBlocks) {
                            System.out.println("block.toString()=" + block.toString());
                        }
                    } else {
                        System.out.println("no extra info.");
                    }
                    Iterator<ExtraInfoBlock> iterator = this.waitingForResponseLock;
                    synchronized (iterator) {
                        this.waitingForResponseLock.notifyAll();
                    }
                }
            } else if (snac instanceof SnacError) {
                this.status = IcqStatusEnum.OFFLINE;
                logger.debug((Object)("status is" + this.status));
                object = this.waitingForResponseLock;
                synchronized (object) {
                    this.waitingForResponseLock.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleTimeout(SnacRequestTimeoutEvent event) {
            Object object = this;
            synchronized (object) {
                if (this.ran) {
                    return;
                }
                this.ran = true;
            }
            object = this.waitingForResponseLock;
            synchronized (object) {
                this.waitingForResponseLock.notifyAll();
            }
        }
    }

    private class AimConnStateListener
    implements StateListener {
        private AimConnStateListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void handleStateChange(StateEvent event) {
            Object object = IcqTesterAgent.this.connectionLock;
            synchronized (object) {
                AimConnection conn = event.getAimConnection();
                logger.debug((Object)("EchoUser change state from:" + event.getOldState() + " to " + event.getNewState()));
                if (event.getNewState() == State.ONLINE) {
                    IcqTesterAgent.this.icbmService = conn.getIcbmService();
                    IcqTesterAgent.this.connectionLock.notifyAll();
                    IcqTesterAgent.this.icbmService.getOscarConnection().getSnacProcessor().getCmdFactoryMgr().getDefaultFactoryList().registerAll(IcqTesterAgent.this.authCmdFactory);
                    IcqTesterAgent.this.icbmService.getOscarConnection().getSnacProcessor().getCmdFactoryMgr().getDefaultFactoryList().registerAll(FullUserInfoCmd.getCommandFactory());
                    IcqTesterAgent.this.icbmService.getOscarConnection().getSnacProcessor().addGlobalResponseListener(IcqTesterAgent.this.authCmdFactory);
                } else if (event.getNewState() == State.FAILED || event.getNewState() == State.DISCONNECTED) {
                    logger.error((Object)("AIM Connection DISCONNECTED for " + IcqTesterAgent.this.getIcqUIN() + "!"));
                    IcqTesterAgent.this.connectionLock.notifyAll();
                }
            }
        }
    }
}

