/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.hid;

import java.awt.GraphicsEnvironment;
import java.awt.Robot;
import net.java.sip.communicator.impl.hid.NativeKeyboard;
import net.java.sip.communicator.service.hid.HIDService;
import net.java.sip.communicator.util.Logger;
import org.jitsi.util.OSUtils;

public class HIDServiceImpl
implements HIDService {
    private final Logger logger;
    private Robot robot;
    private NativeKeyboard nativeKeyboard;

    protected HIDServiceImpl() {
        block2: {
            this.logger = Logger.getLogger(HIDServiceImpl.class);
            this.robot = null;
            this.nativeKeyboard = null;
            try {
                this.robot = new Robot();
                this.nativeKeyboard = new NativeKeyboard();
            }
            catch (Throwable e) {
                if (GraphicsEnvironment.isHeadless()) break block2;
                this.logger.error((Object)"Error when creating Robot/NativeKeyboard instance", e);
            }
        }
    }

    public void keyPress(int keycode) {
        if ((OSUtils.IS_WINDOWS || OSUtils.IS_MAC) && (keycode == 18 || keycode == 16 || keycode == 65406)) {
            return;
        }
        if (keycode == 65406) {
            this.symbolPress("altgr");
        } else {
            this.robot.keyPress(keycode);
        }
    }

    public void keyRelease(int keycode) {
        if (keycode == 65406) {
            this.symbolRelease("altgr");
        } else {
            this.robot.keyRelease(keycode);
        }
    }

    public void keyPress(char key) {
        if (key >= '\u0001' && key <= '\u001a') {
            key = (char)(key + 64);
            this.robot.keyPress(key);
            return;
        }
        this.nativeKeyboard.keyPress(key);
    }

    public void keyRelease(char key) {
        if (key >= '\u0001' && key <= '\u001a') {
            key = (char)(key + 64);
            this.robot.keyRelease(key);
            return;
        }
        if (this.nativeKeyboard != null) {
            this.nativeKeyboard.keyRelease(key);
        }
    }

    private void symbolPress(String symbol) {
        if (this.nativeKeyboard != null) {
            this.nativeKeyboard.symbolPress(symbol);
        }
    }

    private void symbolRelease(String symbol) {
        if (this.nativeKeyboard != null) {
            this.nativeKeyboard.symbolRelease(symbol);
        }
    }

    public void mousePress(int btns) {
        this.robot.mousePress(btns);
    }

    public void mouseRelease(int btns) {
        this.robot.mouseRelease(btns);
    }

    public void mouseMove(int x, int y) {
        this.robot.mouseMove(x, y);
    }

    public void mouseWheel(int rotation) {
        this.robot.mouseWheel(rotation);
    }
}

