/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.contactsource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.service.contactsource.ContactSourceActivator;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import org.jitsi.util.StringUtils;

public class ContactDetail {
    private final Category category;
    protected String contactDetailValue;
    private String detailDisplayName;
    private final Collection<SubCategory> subCategories = new LinkedList<SubCategory>();
    private Map<Class<? extends OperationSet>, ProtocolProviderService> preferredProviders;
    private Map<Class<? extends OperationSet>, String> preferredProtocols;
    private List<Class<? extends OperationSet>> supportedOpSets = null;

    public ContactDetail(String contactDetailValue) {
        this(contactDetailValue, null, null, null);
    }

    public ContactDetail(String contactDetailValue, String detailDisplayName) {
        this(contactDetailValue, detailDisplayName, null, null);
    }

    public ContactDetail(String contactDetailValue, Category category) {
        this(contactDetailValue, null, category, null);
    }

    public ContactDetail(String contactDetailValue, String detailDisplayName, Category category) {
        this(contactDetailValue, detailDisplayName, category, null);
    }

    public ContactDetail(String contactDetailValue, Category category, SubCategory[] subCategories) {
        this(contactDetailValue, null, category, subCategories);
    }

    public ContactDetail(String contactDetailValue, String detailDisplayName, Category category, SubCategory[] subCategories) {
        this.contactDetailValue = contactDetailValue;
        this.detailDisplayName = !StringUtils.isNullOrEmpty((String)detailDisplayName) ? detailDisplayName : (category == Category.Phone ? ContactSourceActivator.getPhoneNumberI18nService().formatForDisplay(contactDetailValue) : contactDetailValue);
        this.category = category;
        if (subCategories != null) {
            for (SubCategory subCategory : subCategories) {
                if (subCategory == null || this.subCategories.contains((Object)subCategory)) continue;
                this.subCategories.add(subCategory);
            }
        }
    }

    public void setPreferredProviders(Map<Class<? extends OperationSet>, ProtocolProviderService> preferredProviders) {
        this.preferredProviders = preferredProviders;
    }

    public void setPreferredProtocols(Map<Class<? extends OperationSet>, String> preferredProtocols) {
        this.preferredProtocols = preferredProtocols;
        for (Class<? extends OperationSet> opsetClass : preferredProtocols.keySet()) {
            if (this.supportedOpSets != null && this.supportedOpSets.contains(opsetClass)) continue;
            this.addSupportedOpSet(opsetClass);
        }
    }

    public void setSupportedOpSets(List<Class<? extends OperationSet>> supportedOpSets) {
        this.supportedOpSets = supportedOpSets;
    }

    public void addSupportedOpSet(Class<? extends OperationSet> supportedOpSet) {
        if (this.supportedOpSets == null) {
            this.supportedOpSets = new ArrayList<Class<? extends OperationSet>>(2);
        }
        this.supportedOpSets.add(supportedOpSet);
    }

    public Category getCategory() {
        return this.category;
    }

    public String getDetail() {
        return this.contactDetailValue;
    }

    public String getDisplayName() {
        return this.detailDisplayName;
    }

    public ProtocolProviderService getPreferredProtocolProvider(Class<? extends OperationSet> opSetClass) {
        if (this.preferredProviders != null && this.preferredProviders.size() > 0) {
            return this.preferredProviders.get(opSetClass);
        }
        return null;
    }

    public String getPreferredProtocol(Class<? extends OperationSet> opSetClass) {
        if (this.preferredProtocols != null && this.preferredProtocols.size() > 0) {
            return this.preferredProtocols.get(opSetClass);
        }
        return null;
    }

    public List<Class<? extends OperationSet>> getSupportedOperationSets() {
        return this.supportedOpSets;
    }

    public boolean containsSubCategory(SubCategory subCategory) {
        return this.subCategories.contains((Object)subCategory);
    }

    public Collection<SubCategory> getSubCategories() {
        return Collections.unmodifiableCollection(this.subCategories);
    }

    public static enum SubCategory {
        Name("Name"),
        LastName("LastName"),
        Nickname("Nickname"),
        HomePage("HomePage"),
        Home("Home"),
        Mobile("Mobile"),
        Work("Work"),
        Fax("Fax"),
        Other("Other"),
        AIM("AIM"),
        ICQ("ICQ"),
        Jabber("XMPP"),
        Skype("Skype"),
        Yahoo("Yahoo"),
        GoogleTalk("GoogleTalk"),
        Country("Country"),
        State("State"),
        City("City"),
        Street("Street"),
        PostalCode("PostalCode"),
        JobTitle("JobTitle");

        private final String value;

        private SubCategory(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public static SubCategory fromString(String value) {
            if (value != null) {
                for (SubCategory subCategory : SubCategory.values()) {
                    if (!value.equalsIgnoreCase(subCategory.value())) continue;
                    return subCategory;
                }
                return null;
            }
            return null;
        }
    }

    public static enum Category {
        Personal("Personal"),
        Web("Web"),
        Organization("Organization"),
        Email("Email"),
        InstantMessaging("InstantMessaging"),
        Phone("Phone"),
        Address("Address");

        private final String value;

        private Category(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public static Category fromString(String value) {
            if (value != null) {
                for (Category category : Category.values()) {
                    if (!value.equalsIgnoreCase(category.value())) continue;
                    return category;
                }
                return null;
            }
            return null;
        }
    }
}

