/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.otr.authdialog;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.otr.OtrActivator;
import net.java.sip.communicator.plugin.otr.OtrContactManager;
import net.java.sip.communicator.plugin.otr.authdialog.KnownFingerprintsTableModel;
import net.java.sip.communicator.service.protocol.Contact;

public class KnownFingerprintsPanel
extends TransparentPanel {
    private static final long serialVersionUID = 0L;
    private JButton btnVerifyFingerprint;
    private JButton btnForgetFingerprint;
    private JTable contactsTable;

    public KnownFingerprintsPanel() {
        this.initComponents();
        this.setPreferredSize(new Dimension(400, 200));
        this.openContact(this.getSelectedContact(), this.getSelectedFingerprint());
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), OtrActivator.resourceService.getI18NString("plugin.otr.configform.KNOWN_FINGERPRINTS")));
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.contactsTable = new JTable();
        this.contactsTable.setModel(new KnownFingerprintsTableModel());
        this.contactsTable.setSelectionMode(0);
        this.contactsTable.setCellSelectionEnabled(false);
        this.contactsTable.setColumnSelectionAllowed(false);
        this.contactsTable.setRowSelectionAllowed(true);
        this.contactsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                KnownFingerprintsPanel.this.openContact(KnownFingerprintsPanel.this.getSelectedContact(), KnownFingerprintsPanel.this.getSelectedFingerprint());
            }
        });
        JScrollPane pnlContacts = new JScrollPane(this.contactsTable);
        this.add(pnlContacts);
        TransparentPanel pnlButtons = new TransparentPanel();
        this.add((Component)pnlButtons);
        this.btnVerifyFingerprint = new JButton();
        this.btnVerifyFingerprint.setText(OtrActivator.resourceService.getI18NString("plugin.otr.configform.VERIFY_FINGERPRINT"));
        this.btnVerifyFingerprint.setEnabled(false);
        this.btnVerifyFingerprint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                OtrActivator.scOtrKeyManager.verify(OtrContactManager.getOtrContact(KnownFingerprintsPanel.this.getSelectedContact(), null), KnownFingerprintsPanel.this.getSelectedFingerprint());
                KnownFingerprintsPanel.this.openContact(KnownFingerprintsPanel.this.getSelectedContact(), KnownFingerprintsPanel.this.getSelectedFingerprint());
                KnownFingerprintsPanel.this.contactsTable.updateUI();
            }
        });
        pnlButtons.add(this.btnVerifyFingerprint);
        this.btnForgetFingerprint = new JButton();
        this.btnForgetFingerprint.setText(OtrActivator.resourceService.getI18NString("plugin.otr.configform.FORGET_FINGERPRINT"));
        this.btnForgetFingerprint.setEnabled(false);
        this.btnForgetFingerprint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                OtrActivator.scOtrKeyManager.unverify(OtrContactManager.getOtrContact(KnownFingerprintsPanel.this.getSelectedContact(), null), KnownFingerprintsPanel.this.getSelectedFingerprint());
                KnownFingerprintsPanel.this.openContact(KnownFingerprintsPanel.this.getSelectedContact(), KnownFingerprintsPanel.this.getSelectedFingerprint());
                KnownFingerprintsPanel.this.contactsTable.updateUI();
            }
        });
        pnlButtons.add(this.btnForgetFingerprint);
    }

    private Contact getSelectedContact() {
        KnownFingerprintsTableModel model = (KnownFingerprintsTableModel)this.contactsTable.getModel();
        int index = this.contactsTable.getSelectedRow();
        if (index < 0 || index > model.getRowCount()) {
            return null;
        }
        return model.getContactFromRow(index);
    }

    private String getSelectedFingerprint() {
        KnownFingerprintsTableModel model = (KnownFingerprintsTableModel)this.contactsTable.getModel();
        int index = this.contactsTable.getSelectedRow();
        if (index < 0 || index > model.getRowCount()) {
            return null;
        }
        return model.getFingerprintFromRow(index);
    }

    private void openContact(Contact contact, String fingerprint) {
        if (contact == null || fingerprint == null) {
            this.btnForgetFingerprint.setEnabled(false);
            this.btnVerifyFingerprint.setEnabled(false);
        } else {
            boolean verified = OtrActivator.scOtrKeyManager.isVerified(contact, fingerprint);
            this.btnForgetFingerprint.setEnabled(verified);
            this.btnVerifyFingerprint.setEnabled(!verified);
        }
    }
}

