/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import net.java.sip.communicator.impl.protocol.jabber.IncomingFileTransferRequestJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetPersistentPresenceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OutgoingFileTransferJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.extensions.thumbnail.FileElement;
import net.java.sip.communicator.impl.protocol.jabber.extensions.thumbnail.ThumbnailElement;
import net.java.sip.communicator.impl.protocol.jabber.extensions.thumbnail.ThumbnailIQ;
import net.java.sip.communicator.service.protocol.AbstractFileTransfer;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.FileTransfer;
import net.java.sip.communicator.service.protocol.IncomingFileTransferRequest;
import net.java.sip.communicator.service.protocol.OperationNotSupportedException;
import net.java.sip.communicator.service.protocol.OperationSetFileTransfer;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.FileTransferCreatedEvent;
import net.java.sip.communicator.service.protocol.event.FileTransferListener;
import net.java.sip.communicator.service.protocol.event.FileTransferRequestEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.util.Logger;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smackx.filetransfer.FileTransfer;
import org.jivesoftware.smackx.filetransfer.FileTransferManager;
import org.jivesoftware.smackx.filetransfer.FileTransferNegotiator;
import org.jivesoftware.smackx.filetransfer.FileTransferRequest;
import org.jivesoftware.smackx.filetransfer.OutgoingFileTransfer;
import org.jivesoftware.smackx.packet.StreamInitiation;

public class OperationSetFileTransferJabberImpl
implements OperationSetFileTransfer {
    private static final Logger logger = Logger.getLogger(OperationSetFileTransferJabberImpl.class);
    private final ProtocolProviderServiceJabberImpl jabberProvider;
    private OperationSetPersistentPresenceJabberImpl opSetPersPresence = null;
    private FileTransferManager manager = null;
    private FileTransferRequestListener fileTransferRequestListener;
    private Vector<FileTransferListener> fileTransferListeners = new Vector();

    public OperationSetFileTransferJabberImpl(ProtocolProviderServiceJabberImpl provider) {
        this.jabberProvider = provider;
        provider.addRegistrationStateChangeListener(new RegistrationStateListener());
        FileTransferNegotiator.IBB_ONLY = true;
    }

    public FileTransfer sendFile(Contact toContact, File file) throws IllegalStateException, IllegalArgumentException, OperationNotSupportedException {
        return this.sendFile(toContact, file, null);
    }

    FileTransfer sendFile(Contact toContact, File file, String gw) throws IllegalStateException, IllegalArgumentException, OperationNotSupportedException {
        OutgoingFileTransferJabberImpl outgoingTransfer = null;
        try {
            this.assertConnected();
            if (file.length() > this.getMaximumFileLength()) {
                throw new IllegalArgumentException("File length exceeds the allowed one for this protocol");
            }
            String fullJid = null;
            OperationSetMultiUserChat mucOpSet = (OperationSetMultiUserChat)this.jabberProvider.getOperationSet(OperationSetMultiUserChat.class);
            if (mucOpSet != null && mucOpSet.isPrivateMessagingContact(toContact.getAddress())) {
                fullJid = toContact.getAddress();
            } else {
                Iterator iter = this.jabberProvider.getConnection().getRoster().getPresences(toContact.getAddress());
                int bestPriority = -1;
                PresenceStatus jabberStatus = null;
                while (iter.hasNext()) {
                    PresenceStatus tempStatus;
                    int priority;
                    Presence presence = (Presence)iter.next();
                    if (!this.jabberProvider.isFeatureListSupported(presence.getFrom(), "http://jabber.org/protocol/si", "http://jabber.org/protocol/si/profile/file-transfer")) continue;
                    int n = priority = presence.getPriority() == Integer.MIN_VALUE ? 0 : presence.getPriority();
                    if (priority > bestPriority) {
                        bestPriority = priority;
                        fullJid = presence.getFrom();
                        jabberStatus = OperationSetPersistentPresenceJabberImpl.jabberStatusToPresenceStatus(presence, this.jabberProvider);
                        continue;
                    }
                    if (priority != bestPriority || jabberStatus == null || (tempStatus = OperationSetPersistentPresenceJabberImpl.jabberStatusToPresenceStatus(presence, this.jabberProvider)).compareTo(jabberStatus) <= 0) continue;
                    fullJid = presence.getFrom();
                    jabberStatus = tempStatus;
                }
            }
            if (fullJid == null) {
                throw new OperationNotSupportedException("Contact client or server does not support file transfers.");
            }
            if (gw != null && !fullJid.contains("@") && !fullJid.endsWith(gw)) {
                fullJid = fullJid + "@" + gw;
            }
            OutgoingFileTransfer transfer = this.manager.createOutgoingFileTransfer(fullJid);
            outgoingTransfer = new OutgoingFileTransferJabberImpl(toContact, file, transfer, this.jabberProvider);
            FileTransferCreatedEvent event = new FileTransferCreatedEvent((FileTransfer)outgoingTransfer, new Date());
            this.fireFileTransferCreated(event);
            transfer.sendFile(file, "Sending file");
            new FileTransferProgressThread((org.jivesoftware.smackx.filetransfer.FileTransfer)transfer, outgoingTransfer).start();
        }
        catch (XMPPException e) {
            logger.error((Object)"Failed to send file.", (Throwable)e);
        }
        return outgoingTransfer;
    }

    public FileTransfer sendFile(Contact toContact, Contact fromContact, String remotePath, String localPath) throws IllegalStateException, IllegalArgumentException, OperationNotSupportedException {
        return this.sendFile(toContact, new File(localPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileTransferListener(FileTransferListener listener) {
        Vector<FileTransferListener> vector = this.fileTransferListeners;
        synchronized (vector) {
            if (!this.fileTransferListeners.contains(listener)) {
                this.fileTransferListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileTransferListener(FileTransferListener listener) {
        Vector<FileTransferListener> vector = this.fileTransferListeners;
        synchronized (vector) {
            this.fileTransferListeners.remove(listener);
        }
    }

    private void assertConnected() throws IllegalStateException {
        if (this.jabberProvider == null) {
            throw new IllegalStateException("The provider must be non-null and signed on the service before being able to send a file.");
        }
        if (!this.jabberProvider.isRegistered()) {
            if (this.opSetPersPresence.getPresenceStatus().isOnline()) {
                this.opSetPersPresence.fireProviderStatusChangeEvent(this.opSetPersPresence.getPresenceStatus(), (PresenceStatus)this.jabberProvider.getJabberStatusEnum().getStatus("Offline"));
            }
            throw new IllegalStateException("The provider must be signed on the service before being able to send a file.");
        }
    }

    public long getMaximumFileLength() {
        return 0x80000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireFileTransferRequest(FileTransferRequestEvent event) {
        Iterator<FileTransferListener> listeners = null;
        Vector<FileTransferListener> vector = this.fileTransferListeners;
        synchronized (vector) {
            listeners = new ArrayList<FileTransferListener>(this.fileTransferListeners).iterator();
        }
        while (listeners.hasNext()) {
            FileTransferListener listener = listeners.next();
            listener.fileTransferRequestReceived(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireFileTransferRequestRejected(FileTransferRequestEvent event) {
        Iterator<FileTransferListener> listeners = null;
        Vector<FileTransferListener> vector = this.fileTransferListeners;
        synchronized (vector) {
            listeners = new ArrayList<FileTransferListener>(this.fileTransferListeners).iterator();
        }
        while (listeners.hasNext()) {
            FileTransferListener listener = listeners.next();
            listener.fileTransferRequestRejected(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireFileTransferCreated(FileTransferCreatedEvent event) {
        Iterator<FileTransferListener> listeners = null;
        Vector<FileTransferListener> vector = this.fileTransferListeners;
        synchronized (vector) {
            listeners = new ArrayList<FileTransferListener>(this.fileTransferListeners).iterator();
        }
        while (listeners.hasNext()) {
            FileTransferListener listener = listeners.next();
            listener.fileTransferCreated(event);
        }
    }

    private static int parseJabberStatus(FileTransfer.Status jabberStatus) {
        if (jabberStatus.equals((Object)FileTransfer.Status.complete)) {
            return 0;
        }
        if (jabberStatus.equals((Object)FileTransfer.Status.cancelled)) {
            return 1;
        }
        if (jabberStatus.equals((Object)FileTransfer.Status.in_progress) || jabberStatus.equals((Object)FileTransfer.Status.negotiated)) {
            return 4;
        }
        if (jabberStatus.equals((Object)FileTransfer.Status.error)) {
            return 2;
        }
        if (jabberStatus.equals((Object)FileTransfer.Status.refused)) {
            return 3;
        }
        if (jabberStatus.equals((Object)FileTransfer.Status.negotiating_transfer) || jabberStatus.equals((Object)FileTransfer.Status.negotiating_stream)) {
            return 6;
        }
        return 5;
    }

    static {
        Connection.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(Connection connection) {
                FileTransferNegotiator.getInstanceFor((Connection)connection);
            }
        });
    }

    protected static class FileTransferProgressThread
    extends Thread {
        private final org.jivesoftware.smackx.filetransfer.FileTransfer jabberTransfer;
        private final AbstractFileTransfer fileTransfer;
        private long initialFileSize;

        public FileTransferProgressThread(org.jivesoftware.smackx.filetransfer.FileTransfer jabberTransfer, AbstractFileTransfer transfer, long initialFileSize) {
            this.jabberTransfer = jabberTransfer;
            this.fileTransfer = transfer;
            this.initialFileSize = initialFileSize;
        }

        public FileTransferProgressThread(org.jivesoftware.smackx.filetransfer.FileTransfer jabberTransfer, AbstractFileTransfer transfer) {
            this.jabberTransfer = jabberTransfer;
            this.fileTransfer = transfer;
        }

        @Override
        public void run() {
            long progress;
            int status;
            String statusReason = "";
            block2: while (true) {
                try {
                    while (true) {
                        Thread.sleep(10L);
                        status = OperationSetFileTransferJabberImpl.parseJabberStatus(this.jabberTransfer.getStatus());
                        progress = this.fileTransfer.getTransferedBytes();
                        if (status == 2 || status == 0 || status == 1 || status == 3) {
                            if (this.fileTransfer instanceof OutgoingFileTransferJabberImpl) {
                                ((OutgoingFileTransferJabberImpl)this.fileTransfer).removeThumbnailRequestListener();
                            }
                            if (status != 0 || this.fileTransfer.getStatus() != 6) break block2;
                            this.fileTransfer.fireStatusChangeEvent(4, "Status changed");
                            this.fileTransfer.fireProgressChangeEvent(System.currentTimeMillis(), progress);
                            break block2;
                        }
                        this.fileTransfer.fireStatusChangeEvent(status, "Status changed");
                        this.fileTransfer.fireProgressChangeEvent(System.currentTimeMillis(), progress);
                    }
                }
                catch (InterruptedException e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)"Unable to sleep thread.", (Throwable)e);
                    continue;
                }
                break;
            }
            if (this.jabberTransfer.getError() != null) {
                logger.error((Object)("An error occured while transfering file: " + this.jabberTransfer.getError().getMessage()));
            }
            if (this.jabberTransfer.getException() != null) {
                XMPPError error;
                logger.error((Object)"An exception occured while transfering file: ", (Throwable)this.jabberTransfer.getException());
                if (this.jabberTransfer.getException() instanceof XMPPException && (error = ((XMPPException)((Object)this.jabberTransfer.getException())).getXMPPError()) != null && (error.getCode() == 406 || error.getCode() == 403)) {
                    status = 3;
                }
                statusReason = this.jabberTransfer.getException().getMessage();
            }
            if (this.initialFileSize > 0L && status == 0 && this.fileTransfer.getTransferedBytes() < this.initialFileSize) {
                status = 1;
            }
            this.fileTransfer.fireStatusChangeEvent(status, statusReason);
            this.fileTransfer.fireProgressChangeEvent(System.currentTimeMillis(), progress);
        }
    }

    private class FileTransferRequestListener
    implements PacketListener {
        private FileTransferRequestListener() {
        }

        public void processPacket(Packet packet) {
            ThumbnailElement thumbnailElement;
            if (!(packet instanceof StreamInitiation)) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Incoming Jabber file transfer request.");
            }
            StreamInitiation streamInitiation = (StreamInitiation)packet;
            FileTransferRequest jabberRequest = new FileTransferRequest(OperationSetFileTransferJabberImpl.this.manager, streamInitiation);
            IncomingFileTransferRequestJabberImpl incomingFileTransferRequest = new IncomingFileTransferRequestJabberImpl(OperationSetFileTransferJabberImpl.this.jabberProvider, OperationSetFileTransferJabberImpl.this, jabberRequest);
            StreamInitiation.File file = streamInitiation.getFile();
            boolean isThumbnailedFile = false;
            if (file instanceof FileElement && (thumbnailElement = ((FileElement)file).getThumbnailElement()) != null) {
                isThumbnailedFile = true;
                incomingFileTransferRequest.createThumbnailListeners(thumbnailElement.getCid());
                ThumbnailIQ thumbnailRequest = new ThumbnailIQ(streamInitiation.getTo(), streamInitiation.getFrom(), thumbnailElement.getCid(), IQ.Type.GET);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Sending thumbnail request:" + thumbnailRequest.toXML()));
                }
                OperationSetFileTransferJabberImpl.this.jabberProvider.getConnection().sendPacket((Packet)thumbnailRequest);
            }
            if (!isThumbnailedFile) {
                FileTransferRequestEvent fileTransferRequestEvent = new FileTransferRequestEvent((OperationSetFileTransfer)OperationSetFileTransferJabberImpl.this, (IncomingFileTransferRequest)incomingFileTransferRequest, new Date());
                OperationSetFileTransferJabberImpl.this.fireFileTransferRequest(fileTransferRequestEvent);
            }
        }
    }

    private class RegistrationStateListener
    implements RegistrationStateChangeListener {
        private RegistrationStateListener() {
        }

        public void registrationStateChanged(RegistrationStateChangeEvent evt) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The provider changed state from: " + evt.getOldState() + " to: " + evt.getNewState()));
            }
            if (evt.getNewState() == RegistrationState.REGISTERED) {
                OperationSetFileTransferJabberImpl.this.opSetPersPresence = (OperationSetPersistentPresenceJabberImpl)OperationSetFileTransferJabberImpl.this.jabberProvider.getOperationSet(OperationSetPersistentPresence.class);
                OperationSetFileTransferJabberImpl.this.manager = new FileTransferManager(OperationSetFileTransferJabberImpl.this.jabberProvider.getConnection());
                OperationSetFileTransferJabberImpl.this.fileTransferRequestListener = new FileTransferRequestListener();
                ProviderManager.getInstance().addIQProvider("si", "http://jabber.org/protocol/si", (Object)new FileElement());
                ProviderManager.getInstance().addIQProvider("data", "urn:xmpp:bob", (Object)new ThumbnailIQ());
                OperationSetFileTransferJabberImpl.this.jabberProvider.getConnection().addPacketListener((PacketListener)OperationSetFileTransferJabberImpl.this.fileTransferRequestListener, (PacketFilter)new AndFilter(new PacketFilter[]{new PacketTypeFilter(StreamInitiation.class), new IQTypeFilter(IQ.Type.SET)}));
            } else if (evt.getNewState() == RegistrationState.UNREGISTERED) {
                ProviderManager providerManager;
                if (OperationSetFileTransferJabberImpl.this.fileTransferRequestListener != null && OperationSetFileTransferJabberImpl.this.jabberProvider.getConnection() != null) {
                    OperationSetFileTransferJabberImpl.this.jabberProvider.getConnection().removePacketListener((PacketListener)OperationSetFileTransferJabberImpl.this.fileTransferRequestListener);
                }
                if ((providerManager = ProviderManager.getInstance()) != null) {
                    ProviderManager.getInstance().removeIQProvider("si", "http://jabber.org/protocol/si");
                    ProviderManager.getInstance().removeIQProvider("data", "urn:xmpp:bob");
                }
                OperationSetFileTransferJabberImpl.this.fileTransferRequestListener = null;
                OperationSetFileTransferJabberImpl.this.manager = null;
            }
        }
    }
}

