/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.Collection;
import java.util.HashSet;
import net.java.sip.communicator.impl.protocol.jabber.JingleNodesCandidate;
import net.java.sip.communicator.util.Logger;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.ice.Component;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.harvest.AbstractCandidateHarvester;
import org.ice4j.socket.IceSocketWrapper;
import org.jivesoftware.smack.XMPPConnection;
import org.xmpp.jnodes.smack.JingleChannelIQ;
import org.xmpp.jnodes.smack.SmackServiceNode;
import org.xmpp.jnodes.smack.TrackerEntry;

public class JingleNodesHarvester
extends AbstractCandidateHarvester {
    private static final Logger logger = Logger.getLogger((String)JingleNodesHarvester.class.getName());
    private SmackServiceNode serviceNode = null;
    private TransportAddress localAddressSecond = null;
    private TransportAddress relayedAddressSecond = null;

    public JingleNodesHarvester(SmackServiceNode serviceNode) {
        this.serviceNode = serviceNode;
    }

    public synchronized Collection<LocalCandidate> harvest(Component component) {
        TrackerEntry preferred;
        logger.info((Object)"harvest Jingle Nodes");
        HashSet<LocalCandidate> candidates = new HashSet<LocalCandidate>();
        String ip = null;
        int port = -1;
        if (this.localAddressSecond != null && this.relayedAddressSecond != null) {
            JingleNodesCandidate candidate = this.createJingleNodesCandidate(this.relayedAddressSecond, component, this.localAddressSecond);
            if (component.addLocalCandidate((LocalCandidate)candidate)) {
                candidates.add(candidate);
            }
            this.localAddressSecond = null;
            this.relayedAddressSecond = null;
            return candidates;
        }
        XMPPConnection conn = this.serviceNode.getConnection();
        JingleChannelIQ ciq = null;
        if (this.serviceNode != null && (preferred = this.serviceNode.getPreferedRelay()) != null) {
            ciq = SmackServiceNode.getChannel((XMPPConnection)conn, (String)preferred.getJid());
        }
        if (ciq != null) {
            ip = ciq.getHost();
            port = ciq.getRemoteport();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("JN relay: " + ip + " remote port:" + port + " local port: " + ciq.getLocalport()));
            }
            if (ip == null || ciq.getRemoteport() == 0) {
                logger.warn((Object)"JN relay ignored because ip was null or port 0");
                return candidates;
            }
            int scopeIndex = ip.indexOf(37);
            if (scopeIndex > 0) {
                logger.warn((Object)("Dropping scope from assumed IPv6 address " + ip));
                ip = ip.substring(0, scopeIndex);
            }
            TransportAddress relayedAddress = new TransportAddress(ip, port, Transport.UDP);
            TransportAddress localAddress = new TransportAddress(ip, ciq.getLocalport(), Transport.UDP);
            JingleNodesCandidate local = this.createJingleNodesCandidate(relayedAddress, component, localAddress);
            this.relayedAddressSecond = new TransportAddress(ip, port + 1, Transport.UDP);
            this.localAddressSecond = new TransportAddress(ip, ciq.getLocalport() + 1, Transport.UDP);
            if (component.addLocalCandidate((LocalCandidate)local)) {
                candidates.add(local);
            }
        }
        return candidates;
    }

    protected JingleNodesCandidate createJingleNodesCandidate(TransportAddress transportAddress, Component component, TransportAddress localEndPoint) {
        JingleNodesCandidate cand = null;
        try {
            cand = new JingleNodesCandidate(transportAddress, component, localEndPoint);
            IceSocketWrapper stunSocket = cand.getStunSocket(null);
            cand.getStunStack().addSocket(stunSocket);
        }
        catch (Throwable e) {
            logger.debug((Object)("Exception occurred when creating JingleNodesCandidate: " + e));
        }
        return cand;
    }
}

