/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.ps;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.xmlgraphics.ps.PSCommandMap;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.PSProcSet;
import org.apache.xmlgraphics.ps.PSResource;

public final class PSProcSets {
    public static final PSResource STD_PROCSET;
    public static final PSResource EPS_PROCSET;
    public static final PSCommandMap STD_COMMAND_MAP;

    private PSProcSets() {
    }

    public static void writeStdProcSet(PSGenerator pSGenerator) throws IOException {
        ((StdProcSet)STD_PROCSET).writeTo(pSGenerator);
    }

    public static void writeFOPStdProcSet(PSGenerator pSGenerator) throws IOException {
        PSProcSets.writeStdProcSet(pSGenerator);
    }

    public static void writeEPSProcSet(PSGenerator pSGenerator) throws IOException {
        ((EPSProcSet)EPS_PROCSET).writeTo(pSGenerator);
    }

    public static void writeFOPEPSProcSet(PSGenerator pSGenerator) throws IOException {
        PSProcSets.writeEPSProcSet(pSGenerator);
    }

    static {
        EPS_PROCSET = new EPSProcSet();
        StdProcSet stdProcSet = new StdProcSet();
        STD_PROCSET = stdProcSet;
        STD_COMMAND_MAP = stdProcSet;
    }

    private static class EPSProcSet
    extends PSProcSet {
        public EPSProcSet() {
            super("Apache XML Graphics EPS ProcSet", 1.0f, 0);
        }

        public void writeTo(PSGenerator pSGenerator) throws IOException {
            pSGenerator.writeDSCComment("BeginResource", new Object[]{"procset", this.getName(), Float.toString(this.getVersion()), Integer.toString(this.getRevision())});
            pSGenerator.writeDSCComment("Version", new Object[]{Float.toString(this.getVersion()), Integer.toString(this.getRevision())});
            pSGenerator.writeDSCComment("Copyright", "Copyright 2002-2003 The Apache Software Foundation. License terms: http://www.apache.org/licenses/LICENSE-2.0");
            pSGenerator.writeDSCComment("Title", "EPS procedures used by the Apache XML Graphics project (Batik and FOP)");
            pSGenerator.writeln("/BeginEPSF { %def");
            pSGenerator.writeln("/b4_Inc_state save def         % Save state for cleanup");
            pSGenerator.writeln("/dict_count countdictstack def % Count objects on dict stack");
            pSGenerator.writeln("/op_count count 1 sub def      % Count objects on operand stack");
            pSGenerator.writeln("userdict begin                 % Push userdict on dict stack");
            pSGenerator.writeln("/showpage { } def              % Redefine showpage, { } = null proc");
            pSGenerator.writeln("0 setgray 0 setlinecap         % Prepare graphics state");
            pSGenerator.writeln("1 setlinewidth 0 setlinejoin");
            pSGenerator.writeln("10 setmiterlimit [ ] 0 setdash newpath");
            pSGenerator.writeln("/languagelevel where           % If level not equal to 1 then");
            pSGenerator.writeln("{pop languagelevel             % set strokeadjust and");
            pSGenerator.writeln("1 ne                           % overprint to their defaults.");
            pSGenerator.writeln("{false setstrokeadjust false setoverprint");
            pSGenerator.writeln("} if");
            pSGenerator.writeln("} if");
            pSGenerator.writeln("} bd");
            pSGenerator.writeln("/EndEPSF { %def");
            pSGenerator.writeln("count op_count sub {pop} repeat            % Clean up stacks");
            pSGenerator.writeln("countdictstack dict_count sub {end} repeat");
            pSGenerator.writeln("b4_Inc_state restore");
            pSGenerator.writeln("} bd");
            pSGenerator.writeDSCComment("EndResource");
            pSGenerator.getResourceTracker().registerSuppliedResource(this);
        }
    }

    private static class StdProcSet
    extends PSProcSet
    implements PSCommandMap {
        private static final Map STANDARD_MACROS;

        public StdProcSet() {
            super("Apache XML Graphics Std ProcSet", 1.2f, 0);
        }

        public void writeTo(PSGenerator pSGenerator) throws IOException {
            pSGenerator.writeDSCComment("BeginResource", new Object[]{"procset", this.getName(), Float.toString(this.getVersion()), Integer.toString(this.getRevision())});
            pSGenerator.writeDSCComment("Version", new Object[]{Float.toString(this.getVersion()), Integer.toString(this.getRevision())});
            pSGenerator.writeDSCComment("Copyright", "Copyright 2001-2003,2010 The Apache Software Foundation. License terms: http://www.apache.org/licenses/LICENSE-2.0");
            pSGenerator.writeDSCComment("Title", "Basic set of procedures used by the XML Graphics project (Batik and FOP)");
            pSGenerator.writeln("/bd{bind def}bind def");
            pSGenerator.writeln("/ld{load def}bd");
            for (Map.Entry entry : STANDARD_MACROS.entrySet()) {
                pSGenerator.writeln("/" + entry.getValue() + "/" + entry.getKey() + " ld");
            }
            pSGenerator.writeln("/re {4 2 roll M");
            pSGenerator.writeln("1 index 0 rlineto");
            pSGenerator.writeln("0 exch rlineto");
            pSGenerator.writeln("neg 0 rlineto");
            pSGenerator.writeln("cp } bd");
            pSGenerator.writeln("/_ctm matrix def");
            pSGenerator.writeln("/_tm matrix def");
            pSGenerator.writeln("/BT { _ctm currentmatrix pop matrix _tm copy pop 0 0 moveto } bd");
            pSGenerator.writeln("/ET { _ctm setmatrix } bd");
            pSGenerator.writeln("/iTm { _ctm setmatrix _tm concat } bd");
            pSGenerator.writeln("/Tm { _tm astore pop iTm 0 0 moveto } bd");
            pSGenerator.writeln("/ux 0.0 def");
            pSGenerator.writeln("/uy 0.0 def");
            pSGenerator.writeln("/F {");
            pSGenerator.writeln("  /Tp exch def");
            pSGenerator.writeln("  /Tf exch def");
            pSGenerator.writeln("  Tf findfont Tp scalefont setfont");
            pSGenerator.writeln("  /cf Tf def  /cs Tp def");
            pSGenerator.writeln("} bd");
            pSGenerator.writeln("/ULS {currentpoint /uy exch def /ux exch def} bd");
            pSGenerator.writeln("/ULE {");
            pSGenerator.writeln("  /Tcx currentpoint pop def");
            pSGenerator.writeln("  gsave");
            pSGenerator.writeln("  newpath");
            pSGenerator.writeln("  cf findfont cs scalefont dup");
            pSGenerator.writeln("  /FontMatrix get 0 get /Ts exch def /FontInfo get dup");
            pSGenerator.writeln("  /UnderlinePosition get Ts mul /To exch def");
            pSGenerator.writeln("  /UnderlineThickness get Ts mul /Tt exch def");
            pSGenerator.writeln("  ux uy To add moveto  Tcx uy To add lineto");
            pSGenerator.writeln("  Tt setlinewidth stroke");
            pSGenerator.writeln("  grestore");
            pSGenerator.writeln("} bd");
            pSGenerator.writeln("/OLE {");
            pSGenerator.writeln("  /Tcx currentpoint pop def");
            pSGenerator.writeln("  gsave");
            pSGenerator.writeln("  newpath");
            pSGenerator.writeln("  cf findfont cs scalefont dup");
            pSGenerator.writeln("  /FontMatrix get 0 get /Ts exch def /FontInfo get dup");
            pSGenerator.writeln("  /UnderlinePosition get Ts mul /To exch def");
            pSGenerator.writeln("  /UnderlineThickness get Ts mul /Tt exch def");
            pSGenerator.writeln("  ux uy To add cs add moveto Tcx uy To add cs add lineto");
            pSGenerator.writeln("  Tt setlinewidth stroke");
            pSGenerator.writeln("  grestore");
            pSGenerator.writeln("} bd");
            pSGenerator.writeln("/SOE {");
            pSGenerator.writeln("  /Tcx currentpoint pop def");
            pSGenerator.writeln("  gsave");
            pSGenerator.writeln("  newpath");
            pSGenerator.writeln("  cf findfont cs scalefont dup");
            pSGenerator.writeln("  /FontMatrix get 0 get /Ts exch def /FontInfo get dup");
            pSGenerator.writeln("  /UnderlinePosition get Ts mul /To exch def");
            pSGenerator.writeln("  /UnderlineThickness get Ts mul /Tt exch def");
            pSGenerator.writeln("  ux uy To add cs 10 mul 26 idiv add moveto Tcx uy To add cs 10 mul 26 idiv add lineto");
            pSGenerator.writeln("  Tt setlinewidth stroke");
            pSGenerator.writeln("  grestore");
            pSGenerator.writeln("} bd");
            pSGenerator.writeln("/QT {");
            pSGenerator.writeln("/Y22 exch store");
            pSGenerator.writeln("/X22 exch store");
            pSGenerator.writeln("/Y21 exch store");
            pSGenerator.writeln("/X21 exch store");
            pSGenerator.writeln("currentpoint");
            pSGenerator.writeln("/Y21 load 2 mul add 3 div exch");
            pSGenerator.writeln("/X21 load 2 mul add 3 div exch");
            pSGenerator.writeln("/X21 load 2 mul /X22 load add 3 div");
            pSGenerator.writeln("/Y21 load 2 mul /Y22 load add 3 div");
            pSGenerator.writeln("/X22 load /Y22 load curveto");
            pSGenerator.writeln("} bd");
            pSGenerator.writeln("/SSPD {");
            pSGenerator.writeln("dup length /d exch dict def");
            pSGenerator.writeln("{");
            pSGenerator.writeln("/v exch def");
            pSGenerator.writeln("/k exch def");
            pSGenerator.writeln("currentpagedevice k known {");
            pSGenerator.writeln("/cpdv currentpagedevice k get def");
            pSGenerator.writeln("v cpdv ne {");
            pSGenerator.writeln("/upd false def");
            pSGenerator.writeln("/nullv v type /nulltype eq def");
            pSGenerator.writeln("/nullcpdv cpdv type /nulltype eq def");
            pSGenerator.writeln("nullv nullcpdv or");
            pSGenerator.writeln("{");
            pSGenerator.writeln("/upd true def");
            pSGenerator.writeln("} {");
            pSGenerator.writeln("/sametype v type cpdv type eq def");
            pSGenerator.writeln("sametype {");
            pSGenerator.writeln("v type /arraytype eq {");
            pSGenerator.writeln("/vlen v length def");
            pSGenerator.writeln("/cpdvlen cpdv length def");
            pSGenerator.writeln("vlen cpdvlen eq {");
            pSGenerator.writeln("0 1 vlen 1 sub {");
            pSGenerator.writeln("/i exch def");
            pSGenerator.writeln("/obj v i get def");
            pSGenerator.writeln("/cpdobj cpdv i get def");
            pSGenerator.writeln("obj cpdobj ne {");
            pSGenerator.writeln("/upd true def");
            pSGenerator.writeln("exit");
            pSGenerator.writeln("} if");
            pSGenerator.writeln("} for");
            pSGenerator.writeln("} {");
            pSGenerator.writeln("/upd true def");
            pSGenerator.writeln("} ifelse");
            pSGenerator.writeln("} {");
            pSGenerator.writeln("v type /dicttype eq {");
            pSGenerator.writeln("v {");
            pSGenerator.writeln("/dv exch def");
            pSGenerator.writeln("/dk exch def");
            pSGenerator.writeln("/cpddv cpdv dk get def");
            pSGenerator.writeln("dv cpddv ne {");
            pSGenerator.writeln("/upd true def");
            pSGenerator.writeln("exit");
            pSGenerator.writeln("} if");
            pSGenerator.writeln("} forall");
            pSGenerator.writeln("} {");
            pSGenerator.writeln("/upd true def");
            pSGenerator.writeln("} ifelse");
            pSGenerator.writeln("} ifelse");
            pSGenerator.writeln("} if");
            pSGenerator.writeln("} ifelse");
            pSGenerator.writeln("upd true eq {");
            pSGenerator.writeln("d k v put");
            pSGenerator.writeln("} if");
            pSGenerator.writeln("} if");
            pSGenerator.writeln("} if");
            pSGenerator.writeln("} forall");
            pSGenerator.writeln("d length 0 gt {");
            pSGenerator.writeln("d setpagedevice");
            pSGenerator.writeln("} if");
            pSGenerator.writeln("} bd");
            pSGenerator.writeln("/RE { % /NewFontName [NewEncodingArray] /FontName RE -");
            pSGenerator.writeln("  findfont dup length dict begin");
            pSGenerator.writeln("  {");
            pSGenerator.writeln("    1 index /FID ne");
            pSGenerator.writeln("    {def} {pop pop} ifelse");
            pSGenerator.writeln("  } forall");
            pSGenerator.writeln("  /Encoding exch def");
            pSGenerator.writeln("  /FontName 1 index def");
            pSGenerator.writeln("  currentdict definefont pop");
            pSGenerator.writeln("  end");
            pSGenerator.writeln("} bind def");
            pSGenerator.writeDSCComment("EndResource");
            pSGenerator.getResourceTracker().registerSuppliedResource(this);
        }

        @Override
        public String mapCommand(String string) {
            String string2 = (String)STANDARD_MACROS.get(string);
            return string2 != null ? string2 : string;
        }

        static {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("moveto", "M");
            hashMap.put("rmoveto", "RM");
            hashMap.put("curveto", "C");
            hashMap.put("lineto", "L");
            hashMap.put("show", "t");
            hashMap.put("ashow", "A");
            hashMap.put("closepath", "cp");
            hashMap.put("setrgbcolor", "RC");
            hashMap.put("setgray", "GC");
            hashMap.put("setcmykcolor", "CC");
            hashMap.put("newpath", "N");
            hashMap.put("setmiterlimit", "ML");
            hashMap.put("setlinewidth", "LC");
            hashMap.put("setlinewidth", "LW");
            hashMap.put("setlinejoin", "LJ");
            hashMap.put("grestore", "GR");
            hashMap.put("gsave", "GS");
            hashMap.put("fill", "f");
            hashMap.put("stroke", "S");
            hashMap.put("concat", "CT");
            STANDARD_MACROS = Collections.unmodifiableMap(hashMap);
        }
    }
}

