/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.java2d.color;

import java.awt.Color;
import java.awt.color.ColorSpace;
import org.apache.xmlgraphics.java2d.color.ColorWithAlternatives;

public class CIELabColorSpace
extends ColorSpace {
    private static final long serialVersionUID = -1821569090707520704L;
    private static final float REF_X_D65 = 95.047f;
    private static final float REF_Y_D65 = 100.0f;
    private static final float REF_Z_D65 = 108.883f;
    private static final float REF_X_D50 = 96.42f;
    private static final float REF_Y_D50 = 100.0f;
    private static final float REF_Z_D50 = 82.49f;
    private static final double D = 0.20689655172413793;
    private static final double REF_A = 1.0 / (3.0 * Math.pow(0.20689655172413793, 2.0));
    private static final double REF_B = 0.13793103448275862;
    private static final double T0 = Math.pow(0.20689655172413793, 3.0);
    private float wpX;
    private float wpY;
    private float wpZ;
    private static final String CIE_LAB_ONLY_HAS_3_COMPONENTS = "CIE Lab only has 3 components!";

    public CIELabColorSpace() {
        this(CIELabColorSpace.getD65WhitePoint());
    }

    public CIELabColorSpace(float[] fArray) {
        super(1, 3);
        this.checkNumComponents(fArray, 3);
        this.wpX = fArray[0];
        this.wpY = fArray[1];
        this.wpZ = fArray[2];
    }

    public static float[] getD65WhitePoint() {
        return new float[]{95.047f, 100.0f, 108.883f};
    }

    public static float[] getD50WhitePoint() {
        return new float[]{96.42f, 100.0f, 82.49f};
    }

    private void checkNumComponents(float[] fArray) {
        this.checkNumComponents(fArray, this.getNumComponents());
    }

    private void checkNumComponents(float[] fArray, int n) {
        if (fArray == null) {
            throw new NullPointerException("color value may not be null");
        }
        if (fArray.length != n) {
            throw new IllegalArgumentException("Expected " + n + " components, but got " + fArray.length);
        }
    }

    public float[] getWhitePoint() {
        return new float[]{this.wpX, this.wpY, this.wpZ};
    }

    @Override
    public float getMinValue(int n) {
        switch (n) {
            case 0: {
                return 0.0f;
            }
            case 1: 
            case 2: {
                return -128.0f;
            }
        }
        throw new IllegalArgumentException(CIE_LAB_ONLY_HAS_3_COMPONENTS);
    }

    @Override
    public float getMaxValue(int n) {
        switch (n) {
            case 0: {
                return 100.0f;
            }
            case 1: 
            case 2: {
                return 128.0f;
            }
        }
        throw new IllegalArgumentException(CIE_LAB_ONLY_HAS_3_COMPONENTS);
    }

    @Override
    public String getName(int n) {
        switch (n) {
            case 0: {
                return "L*";
            }
            case 1: {
                return "a*";
            }
            case 2: {
                return "b*";
            }
        }
        throw new IllegalArgumentException(CIE_LAB_ONLY_HAS_3_COMPONENTS);
    }

    @Override
    public float[] fromCIEXYZ(float[] fArray) {
        this.checkNumComponents(fArray, 3);
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        double d = f / this.wpX;
        double d2 = f2 / this.wpY;
        double d3 = f3 / this.wpZ;
        d = d > T0 ? Math.pow(d, 0.3333333333333333) : REF_A * d + 0.13793103448275862;
        d2 = d2 > T0 ? Math.pow(d2, 0.3333333333333333) : REF_A * d2 + 0.13793103448275862;
        d3 = d3 > T0 ? Math.pow(d3, 0.3333333333333333) : REF_A * d3 + 0.13793103448275862;
        float f4 = (float)(116.0 * d2 - 16.0);
        float f5 = (float)(500.0 * (d - d2));
        float f6 = (float)(200.0 * (d2 - d3));
        f4 = this.normalize(f4, 0);
        f5 = this.normalize(f5, 1);
        f6 = this.normalize(f6, 2);
        return new float[]{f4, f5, f6};
    }

    @Override
    public float[] fromRGB(float[] fArray) {
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        float[] fArray2 = colorSpace.toCIEXYZ(fArray);
        return this.fromCIEXYZ(fArray2);
    }

    @Override
    public float[] toCIEXYZ(float[] fArray) {
        this.checkNumComponents(fArray);
        float f = this.denormalize(fArray[0], 0);
        float f2 = this.denormalize(fArray[1], 1);
        float f3 = this.denormalize(fArray[2], 2);
        return this.toCIEXYZNative(f, f2, f3);
    }

    public float[] toCIEXYZNative(float f, float f2, float f3) {
        double d = (double)(f + 16.0f) / 116.0;
        double d2 = (double)(f2 / 500.0f) + d;
        double d3 = d - (double)f3 / 200.0;
        d = Math.pow(d, 3.0) > T0 ? Math.pow(d, 3.0) : (d - 0.13793103448275862) / REF_A;
        d2 = Math.pow(d2, 3.0) > T0 ? Math.pow(d2, 3.0) : (d2 - 0.13793103448275862) / REF_A;
        d3 = Math.pow(d3, 3.0) > T0 ? Math.pow(d3, 3.0) : (d3 - 0.13793103448275862) / REF_A;
        float f4 = (float)((double)this.wpX * d2 / 100.0);
        float f5 = (float)((double)this.wpY * d / 100.0);
        float f6 = (float)((double)this.wpZ * d3 / 100.0);
        return new float[]{f4, f5, f6};
    }

    @Override
    public float[] toRGB(float[] fArray) {
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        float[] fArray2 = this.toCIEXYZ(fArray);
        return colorSpace.fromCIEXYZ(fArray2);
    }

    private float getNativeValueRange(int n) {
        return this.getMaxValue(n) - this.getMinValue(n);
    }

    private float normalize(float f, int n) {
        return (f - this.getMinValue(n)) / this.getNativeValueRange(n);
    }

    private float denormalize(float f, int n) {
        return f * this.getNativeValueRange(n) + this.getMinValue(n);
    }

    public float[] toNativeComponents(float[] fArray) {
        this.checkNumComponents(fArray);
        float[] fArray2 = new float[fArray.length];
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            fArray2[i] = this.denormalize(fArray[i], i);
        }
        return fArray2;
    }

    public Color toColor(float[] fArray, float f) {
        int n = fArray.length;
        float[] fArray2 = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray2[i] = this.normalize(fArray[i], i);
        }
        return new ColorWithAlternatives(this, fArray2, f, null);
    }

    public Color toColor(float f, float f2, float f3, float f4) {
        return this.toColor(new float[]{f, f2, f3}, f4);
    }
}

