/*
 * Decompiled with CFR 0.152.
 */
package com.github.zafarkhaja.semver.expr;

import com.github.zafarkhaja.semver.expr.LexerException;
import com.github.zafarkhaja.semver.util.Stream;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Lexer {
    Lexer() {
    }

    Stream<Token> tokenize(String string) {
        ArrayList<Token> arrayList = new ArrayList<Token>();
        int n = 0;
        while (!string.isEmpty()) {
            boolean bl = false;
            for (Token.Type type : Token.Type.values()) {
                Matcher matcher = type.pattern.matcher(string);
                if (!matcher.find()) continue;
                bl = true;
                string = matcher.replaceFirst("");
                if (type != Token.Type.WHITESPACE) {
                    arrayList.add(new Token(type, matcher.group(), n));
                }
                n += matcher.end();
                break;
            }
            if (bl) continue;
            throw new LexerException(string);
        }
        arrayList.add(new Token(Token.Type.EOI, null, n));
        return new Stream<Token>(arrayList.toArray(new Token[arrayList.size()]));
    }

    static class Token {
        final Type type;
        final String lexeme;
        final int position;

        Token(Type type, String string, int n) {
            this.type = type;
            this.lexeme = string == null ? "" : string;
            this.position = n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Token)) {
                return false;
            }
            Token token = (Token)object;
            return this.type.equals(token.type) && this.lexeme.equals(token.lexeme) && this.position == token.position;
        }

        public int hashCode() {
            int n = 5;
            n = 71 * n + this.type.hashCode();
            n = 71 * n + this.lexeme.hashCode();
            n = 71 * n + this.position;
            return n;
        }

        public String toString() {
            return String.format("%s(%s) at position %d", this.type.name(), this.lexeme, this.position);
        }

        static enum Type implements Stream.ElementType<Token>
        {
            NUMERIC("0|[1-9][0-9]*"),
            DOT("\\."),
            HYPHEN("-"),
            EQUAL("="),
            NOT_EQUAL("!="),
            GREATER(">(?!=)"),
            GREATER_EQUAL(">="),
            LESS("<(?!=)"),
            LESS_EQUAL("<="),
            TILDE("~"),
            WILDCARD("[\\*xX]"),
            CARET("\\^"),
            AND("&"),
            OR("\\|"),
            NOT("!(?!=)"),
            LEFT_PAREN("\\("),
            RIGHT_PAREN("\\)"),
            WHITESPACE("\\s+"),
            EOI("?!");

            final Pattern pattern;

            private Type(String string2) {
                this.pattern = Pattern.compile("^(" + string2 + ")");
            }

            public String toString() {
                return this.name() + "(" + this.pattern + ")";
            }

            @Override
            public boolean isMatchedBy(Token token) {
                if (token == null) {
                    return false;
                }
                return this == token.type;
            }
        }
    }
}

