/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import javax.swing.text.BadLocationException;
import org.fife.ui.rtextarea.RDocument;

class RDocumentCharSequence
implements CharSequence {
    private RDocument doc;
    private int start;
    private int end;

    public RDocumentCharSequence(RDocument rDocument, int n) {
        this(rDocument, n, rDocument.getLength());
    }

    public RDocumentCharSequence(RDocument rDocument, int n, int n2) {
        this.doc = rDocument;
        this.start = n;
        this.end = n2;
    }

    @Override
    public char charAt(int n) {
        if (n < 0 || n >= this.length()) {
            throw new IndexOutOfBoundsException("Index " + n + " is not in range [0-" + this.length() + ")");
        }
        try {
            return this.doc.charAt(this.start + n);
        }
        catch (BadLocationException badLocationException) {
            throw new IndexOutOfBoundsException(badLocationException.toString());
        }
    }

    @Override
    public int length() {
        return this.end - this.start;
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("start must be >= 0 (" + n + ")");
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("end must be >= 0 (" + n2 + ")");
        }
        if (n2 > this.length()) {
            throw new IndexOutOfBoundsException("end must be <= " + this.length() + " (" + n2 + ")");
        }
        if (n > n2) {
            throw new IndexOutOfBoundsException("start (" + n + ") cannot be > end (" + n2 + ")");
        }
        int n3 = this.start + n;
        int n4 = this.start + n2;
        return new RDocumentCharSequence(this.doc, n3, n4);
    }

    @Override
    public String toString() {
        try {
            return this.doc.getText(this.start, this.length());
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return "";
        }
    }
}

