/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaHighlighter;
import org.fife.ui.rsyntaxtextarea.SquiggleUnderlineHighlightPainter;
import org.fife.ui.rsyntaxtextarea.parser.ParseResult;
import org.fife.ui.rsyntaxtextarea.parser.Parser;
import org.fife.ui.rsyntaxtextarea.parser.ParserNotice;
import org.fife.ui.rsyntaxtextarea.parser.ToolTipInfo;
import org.fife.ui.rtextarea.RDocument;
import org.fife.ui.rtextarea.RTextAreaHighlighter;

class ParserManager
implements DocumentListener,
ActionListener,
HyperlinkListener,
PropertyChangeListener {
    private RSyntaxTextArea textArea;
    private List<Parser> parsers;
    private Timer timer;
    private boolean running;
    private Parser parserForTip;
    private Position firstOffsetModded;
    private Position lastOffsetModded;
    private List<NoticeHighlightPair> noticeHighlightPairs;
    private SquiggleUnderlineHighlightPainter parserErrorHighlightPainter = new SquiggleUnderlineHighlightPainter(Color.RED);
    private static final String PROPERTY_DEBUG_PARSING = "rsta.debugParsing";
    private static final boolean DEBUG_PARSING;
    private static final int DEFAULT_DELAY_MS = 1250;

    public ParserManager(RSyntaxTextArea rSyntaxTextArea) {
        this(1250, rSyntaxTextArea);
    }

    public ParserManager(int n, RSyntaxTextArea rSyntaxTextArea) {
        this.textArea = rSyntaxTextArea;
        rSyntaxTextArea.getDocument().addDocumentListener(this);
        rSyntaxTextArea.addPropertyChangeListener("document", this);
        this.parsers = new ArrayList<Parser>(1);
        this.timer = new Timer(n, this);
        this.timer.setRepeats(false);
        this.running = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.getParserCount();
        if (n == 0) {
            return;
        }
        long l = 0L;
        if (DEBUG_PARSING) {
            l = System.currentTimeMillis();
        }
        RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)this.textArea.getDocument();
        Element element = rSyntaxDocument.getDefaultRootElement();
        int n2 = this.firstOffsetModded == null ? 0 : element.getElementIndex(this.firstOffsetModded.getOffset());
        int n3 = this.lastOffsetModded == null ? element.getElementCount() - 1 : element.getElementIndex(this.lastOffsetModded.getOffset());
        this.lastOffsetModded = null;
        this.firstOffsetModded = null;
        if (DEBUG_PARSING) {
            System.out.println("[DEBUG]: Minimum lines to parse: " + n2 + "-" + n3);
        }
        String string = this.textArea.getSyntaxEditingStyle();
        rSyntaxDocument.readLock();
        try {
            for (int i = 0; i < n; ++i) {
                Parser parser = this.getParser(i);
                if (parser.isEnabled()) {
                    ParseResult parseResult = parser.parse(rSyntaxDocument, string);
                    this.addParserNoticeHighlights(parseResult);
                    continue;
                }
                this.clearParserNoticeHighlights(parser);
            }
            this.textArea.fireParserNoticesChange();
        }
        finally {
            rSyntaxDocument.readUnlock();
        }
        if (DEBUG_PARSING) {
            float f = (float)(System.currentTimeMillis() - l) / 1000.0f;
            System.out.println("Total parsing time: " + f + " seconds");
        }
    }

    public void addParser(Parser parser) {
        if (parser != null && !this.parsers.contains(parser)) {
            if (this.running) {
                this.timer.stop();
            }
            this.parsers.add(parser);
            if (this.parsers.size() == 1) {
                ToolTipManager.sharedInstance().registerComponent(this.textArea);
            }
            if (this.running) {
                this.timer.restart();
            }
        }
    }

    private void addParserNoticeHighlights(ParseResult parseResult) {
        if (parseResult == null) {
            return;
        }
        if (DEBUG_PARSING) {
            System.out.println("[DEBUG]: Adding parser notices from " + parseResult.getParser());
        }
        if (this.noticeHighlightPairs == null) {
            this.noticeHighlightPairs = new ArrayList<NoticeHighlightPair>();
        }
        this.removeParserNotices(parseResult);
        List<ParserNotice> list = parseResult.getNotices();
        if (list.size() > 0) {
            RSyntaxTextAreaHighlighter rSyntaxTextAreaHighlighter = (RSyntaxTextAreaHighlighter)this.textArea.getHighlighter();
            for (ParserNotice parserNotice : list) {
                if (DEBUG_PARSING) {
                    System.out.println("[DEBUG]: ... adding: " + parserNotice);
                }
                try {
                    RTextAreaHighlighter.HighlightInfo highlightInfo = null;
                    if (parserNotice.getShowInEditor()) {
                        highlightInfo = rSyntaxTextAreaHighlighter.addParserHighlight(parserNotice, this.parserErrorHighlightPainter);
                    }
                    this.noticeHighlightPairs.add(new NoticeHighlightPair(parserNotice, highlightInfo));
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        }
        if (DEBUG_PARSING) {
            System.out.println("[DEBUG]: Done adding parser notices from " + parseResult.getParser());
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    private void clearParserNoticeHighlights() {
        RSyntaxTextAreaHighlighter rSyntaxTextAreaHighlighter = (RSyntaxTextAreaHighlighter)this.textArea.getHighlighter();
        if (rSyntaxTextAreaHighlighter != null) {
            rSyntaxTextAreaHighlighter.clearParserHighlights();
        }
        if (this.noticeHighlightPairs != null) {
            this.noticeHighlightPairs.clear();
        }
    }

    private void clearParserNoticeHighlights(Parser parser) {
        RSyntaxTextAreaHighlighter rSyntaxTextAreaHighlighter = (RSyntaxTextAreaHighlighter)this.textArea.getHighlighter();
        if (rSyntaxTextAreaHighlighter != null) {
            rSyntaxTextAreaHighlighter.clearParserHighlights(parser);
        }
        if (this.noticeHighlightPairs != null) {
            Iterator<NoticeHighlightPair> iterator = this.noticeHighlightPairs.iterator();
            while (iterator.hasNext()) {
                NoticeHighlightPair noticeHighlightPair = iterator.next();
                if (noticeHighlightPair.notice.getParser() != parser) continue;
                iterator.remove();
            }
        }
    }

    public void clearParsers() {
        this.timer.stop();
        this.clearParserNoticeHighlights();
        this.parsers.clear();
        this.textArea.fireParserNoticesChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceReparsing(int n) {
        Parser parser = this.getParser(n);
        RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)this.textArea.getDocument();
        String string = this.textArea.getSyntaxEditingStyle();
        rSyntaxDocument.readLock();
        try {
            if (parser.isEnabled()) {
                ParseResult parseResult = parser.parse(rSyntaxDocument, string);
                this.addParserNoticeHighlights(parseResult);
            } else {
                this.clearParserNoticeHighlights(parser);
            }
            this.textArea.fireParserNoticesChange();
        }
        finally {
            rSyntaxDocument.readUnlock();
        }
    }

    public int getDelay() {
        return this.timer.getDelay();
    }

    public Parser getParser(int n) {
        return this.parsers.get(n);
    }

    public int getParserCount() {
        return this.parsers.size();
    }

    public List<ParserNotice> getParserNotices() {
        ArrayList<ParserNotice> arrayList = new ArrayList<ParserNotice>();
        if (this.noticeHighlightPairs != null) {
            for (NoticeHighlightPair noticeHighlightPair : this.noticeHighlightPairs) {
                arrayList.add(noticeHighlightPair.notice);
            }
        }
        return arrayList;
    }

    public ToolTipInfo getToolTipText(MouseEvent mouseEvent) {
        String string = null;
        HyperlinkListener hyperlinkListener = null;
        this.parserForTip = null;
        Point point = mouseEvent.getPoint();
        int n = this.textArea.viewToModel(point);
        if (this.noticeHighlightPairs != null) {
            for (NoticeHighlightPair noticeHighlightPair : this.noticeHighlightPairs) {
                ParserNotice parserNotice = noticeHighlightPair.notice;
                if (!this.noticeContainsPosition(parserNotice, n) || !this.noticeContainsPointInView(parserNotice, point)) continue;
                string = parserNotice.getToolTipText();
                this.parserForTip = parserNotice.getParser();
                if (!(this.parserForTip instanceof HyperlinkListener)) break;
                hyperlinkListener = (HyperlinkListener)((Object)this.parserForTip);
                break;
            }
        }
        Iterator<NoticeHighlightPair> iterator = this.parserForTip == null ? null : this.parserForTip.getImageBase();
        return new ToolTipInfo(string, hyperlinkListener, (URL)((Object)iterator));
    }

    public void handleDocumentEvent(DocumentEvent documentEvent) {
        if (this.running && this.parsers.size() > 0) {
            this.timer.restart();
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (this.parserForTip != null && this.parserForTip.getHyperlinkListener() != null) {
            this.parserForTip.getHyperlinkListener().linkClicked(this.textArea, hyperlinkEvent);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        try {
            int n = documentEvent.getOffset();
            if (this.firstOffsetModded == null || n < this.firstOffsetModded.getOffset()) {
                this.firstOffsetModded = documentEvent.getDocument().createPosition(n);
            }
            n = documentEvent.getOffset() + documentEvent.getLength();
            if (this.lastOffsetModded == null || n > this.lastOffsetModded.getOffset()) {
                this.lastOffsetModded = documentEvent.getDocument().createPosition(n);
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        this.handleDocumentEvent(documentEvent);
    }

    private final boolean noticeContainsPosition(ParserNotice parserNotice, int n) {
        if (parserNotice.getKnowsOffsetAndLength()) {
            return parserNotice.containsPosition(n);
        }
        Document document = this.textArea.getDocument();
        Element element = document.getDefaultRootElement();
        int n2 = parserNotice.getLine();
        if (n2 < 0) {
            return false;
        }
        Element element2 = element.getElement(n2);
        return n >= element2.getStartOffset() && n < element2.getEndOffset();
    }

    private final boolean noticeContainsPointInView(ParserNotice parserNotice, Point point) {
        try {
            Object object;
            Object object2;
            int n;
            int n2;
            if (parserNotice.getKnowsOffsetAndLength()) {
                n2 = parserNotice.getOffset();
                n = n2 + parserNotice.getLength() - 1;
            } else {
                object2 = this.textArea.getDocument();
                object = object2.getDefaultRootElement();
                int n3 = parserNotice.getLine();
                if (n3 < 0) {
                    return false;
                }
                Element element = object.getElement(n3);
                n2 = element.getStartOffset();
                n = element.getEndOffset() - 1;
            }
            object2 = this.textArea.modelToView(n2);
            object = this.textArea.modelToView(n);
            if (((Rectangle)object2).y != ((Rectangle)object).y) {
                return true;
            }
            --((Rectangle)object2).y;
            ((Rectangle)object2).height += 2;
            return point.x >= ((Rectangle)object2).x && point.x < ((Rectangle)object).x + ((Rectangle)object).width && point.y >= ((Rectangle)object2).y && point.y < ((Rectangle)object2).y + ((Rectangle)object2).height;
        }
        catch (BadLocationException badLocationException) {
            return true;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("document".equals(string)) {
            RDocument rDocument;
            RDocument rDocument2 = (RDocument)propertyChangeEvent.getOldValue();
            if (rDocument2 != null) {
                rDocument2.removeDocumentListener(this);
            }
            if ((rDocument = (RDocument)propertyChangeEvent.getNewValue()) != null) {
                rDocument.addDocumentListener(this);
            }
        }
    }

    public boolean removeParser(Parser parser) {
        this.removeParserNotices(parser);
        boolean bl = this.parsers.remove(parser);
        if (bl) {
            this.textArea.fireParserNoticesChange();
        }
        return bl;
    }

    private void removeParserNotices(Parser parser) {
        if (this.noticeHighlightPairs != null) {
            RSyntaxTextAreaHighlighter rSyntaxTextAreaHighlighter = (RSyntaxTextAreaHighlighter)this.textArea.getHighlighter();
            Iterator<NoticeHighlightPair> iterator = this.noticeHighlightPairs.iterator();
            while (iterator.hasNext()) {
                NoticeHighlightPair noticeHighlightPair = iterator.next();
                if (noticeHighlightPair.notice.getParser() != parser || noticeHighlightPair.highlight == null) continue;
                rSyntaxTextAreaHighlighter.removeParserHighlight(noticeHighlightPair.highlight);
                iterator.remove();
            }
        }
    }

    private void removeParserNotices(ParseResult parseResult) {
        if (this.noticeHighlightPairs != null) {
            RSyntaxTextAreaHighlighter rSyntaxTextAreaHighlighter = (RSyntaxTextAreaHighlighter)this.textArea.getHighlighter();
            Iterator<NoticeHighlightPair> iterator = this.noticeHighlightPairs.iterator();
            while (iterator.hasNext()) {
                NoticeHighlightPair noticeHighlightPair = iterator.next();
                boolean bl = false;
                if (this.shouldRemoveNotice(noticeHighlightPair.notice, parseResult)) {
                    if (noticeHighlightPair.highlight != null) {
                        rSyntaxTextAreaHighlighter.removeParserHighlight(noticeHighlightPair.highlight);
                    }
                    iterator.remove();
                    bl = true;
                }
                if (!DEBUG_PARSING) continue;
                String string = bl ? "[DEBUG]: ... notice removed: " : "[DEBUG]: ... notice not removed: ";
                System.out.println(string + noticeHighlightPair.notice);
            }
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        try {
            int n = documentEvent.getOffset();
            if (this.firstOffsetModded == null || n < this.firstOffsetModded.getOffset()) {
                this.firstOffsetModded = documentEvent.getDocument().createPosition(n);
            }
            if (this.lastOffsetModded == null || n > this.lastOffsetModded.getOffset()) {
                this.lastOffsetModded = documentEvent.getDocument().createPosition(n);
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        this.handleDocumentEvent(documentEvent);
    }

    public void restartParsing() {
        this.timer.restart();
        this.running = true;
    }

    public void setDelay(int n) {
        if (this.running) {
            this.timer.stop();
        }
        this.timer.setInitialDelay(n);
        this.timer.setDelay(n);
        if (this.running) {
            this.timer.start();
        }
    }

    private final boolean shouldRemoveNotice(ParserNotice parserNotice, ParseResult parseResult) {
        if (DEBUG_PARSING) {
            System.out.println("[DEBUG]: ... ... shouldRemoveNotice " + parserNotice + ": " + (parserNotice.getParser() == parseResult.getParser()));
        }
        return parserNotice.getParser() == parseResult.getParser();
    }

    public void stopParsing() {
        this.timer.stop();
        this.running = false;
    }

    static {
        boolean bl = false;
        try {
            bl = Boolean.getBoolean(PROPERTY_DEBUG_PARSING);
        }
        catch (AccessControlException accessControlException) {
            bl = false;
        }
        DEBUG_PARSING = bl;
    }

    private static class NoticeHighlightPair {
        public ParserNotice notice;
        public RTextAreaHighlighter.HighlightInfo highlight;

        public NoticeHighlightPair(ParserNotice parserNotice, RTextAreaHighlighter.HighlightInfo highlightInfo) {
            this.notice = parserNotice;
            this.highlight = highlightInfo;
        }
    }
}

