/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.DocumentRange;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.parser.Parser;
import org.fife.ui.rsyntaxtextarea.parser.ParserNotice;
import org.fife.ui.rsyntaxtextarea.parser.TaskTagParser;

public class ErrorStrip
extends JPanel {
    private RSyntaxTextArea textArea;
    private Listener listener;
    private boolean showMarkedOccurrences;
    private boolean showMarkAll;
    private Map<Color, Color> brighterColors;
    private ParserNotice.Level levelThreshold;
    private boolean followCaret;
    private Color caretMarkerColor;
    private int caretLineY;
    private int lastLineY;
    private static final int PREFERRED_WIDTH = 14;
    private static final String MSG = "org.fife.ui.rsyntaxtextarea.ErrorStrip";
    private static final ResourceBundle msg = ResourceBundle.getBundle("org.fife.ui.rsyntaxtextarea.ErrorStrip");

    public ErrorStrip(RSyntaxTextArea rSyntaxTextArea) {
        this.textArea = rSyntaxTextArea;
        this.listener = new Listener();
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setLayout(null);
        this.addMouseListener(this.listener);
        this.setShowMarkedOccurrences(true);
        this.setShowMarkAll(true);
        this.setLevelThreshold(ParserNotice.Level.WARNING);
        this.setFollowCaret(true);
        this.setCaretMarkerColor(Color.BLACK);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.textArea.addCaretListener(this.listener);
        this.textArea.addPropertyChangeListener("RSTA.parserNotices", this.listener);
        this.textArea.addPropertyChangeListener("RSTA.markOccurrences", this.listener);
        this.textArea.addPropertyChangeListener("RSTA.markedOccurrencesChanged", this.listener);
        this.textArea.addPropertyChangeListener("RTA.markAllOccurrencesChanged", this.listener);
        this.refreshMarkers();
    }

    @Override
    public void doLayout() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Marker marker = (Marker)this.getComponent(i);
            marker.updateLocation();
        }
        this.listener.caretUpdate(null);
    }

    private Color getBrighterColor(Color color) {
        Color color2;
        if (this.brighterColors == null) {
            this.brighterColors = new HashMap<Color, Color>(5);
        }
        if ((color2 = this.brighterColors.get(color)) == null) {
            int n = ErrorStrip.possiblyBrighter(color.getRed());
            int n2 = ErrorStrip.possiblyBrighter(color.getGreen());
            int n3 = ErrorStrip.possiblyBrighter(color.getBlue());
            color2 = new Color(n, n2, n3);
            this.brighterColors.put(color, color2);
        }
        return color2;
    }

    public Color getCaretMarkerColor() {
        return this.caretMarkerColor;
    }

    public boolean getFollowCaret() {
        return this.followCaret;
    }

    @Override
    public Dimension getPreferredSize() {
        int n = this.textArea.getPreferredScrollableViewportSize().height;
        return new Dimension(14, n);
    }

    public ParserNotice.Level getLevelThreshold() {
        return this.levelThreshold;
    }

    public boolean getShowMarkAll() {
        return this.showMarkAll;
    }

    public boolean getShowMarkedOccurrences() {
        return this.showMarkedOccurrences;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        String string = null;
        int n = this.yToLine(mouseEvent.getY());
        if (n > -1) {
            string = msg.getString("Line");
            string = MessageFormat.format(string, n + 1);
        }
        return string;
    }

    private int lineToY(int n) {
        int n2 = this.textArea.getVisibleRect().height;
        float f = this.textArea.getLineCount();
        return (int)((float)(n - 1) / (f - 1.0f) * (float)(n2 - 2));
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.caretLineY > -1) {
            graphics.setColor(this.getCaretMarkerColor());
            graphics.fillRect(0, this.caretLineY, this.getWidth(), 2);
        }
    }

    private static final int possiblyBrighter(int n) {
        if (n < 255) {
            n += (int)((float)(255 - n) * 0.8f);
        }
        return n;
    }

    private void refreshMarkers() {
        List<DocumentRange> list;
        this.removeAll();
        HashMap<Integer, Marker> hashMap = new HashMap<Integer, Marker>();
        List<ParserNotice> list2 = this.textArea.getParserNotices();
        for (ParserNotice object : list2) {
            if (!object.getLevel().isEqualToOrWorseThan(this.levelThreshold) && !(object instanceof TaskTagParser.TaskNotice)) continue;
            Integer n = object.getLine();
            Marker marker = (Marker)hashMap.get(n);
            if (marker == null) {
                marker = new Marker(object);
                marker.addMouseListener(this.listener);
                hashMap.put(n, marker);
                this.add(marker);
                continue;
            }
            marker.addNotice(object);
        }
        if (this.getShowMarkedOccurrences() && this.textArea.getMarkOccurrences()) {
            list = this.textArea.getMarkedOccurrences();
            this.addMarkersForRanges(list, hashMap, this.textArea.getMarkOccurrencesColor());
        }
        if (this.getShowMarkAll()) {
            list = this.textArea.getMarkAllHighlightColor();
            List<DocumentRange> list3 = this.textArea.getMarkAllHighlightRanges();
            this.addMarkersForRanges(list3, (Map<Integer, Marker>)hashMap, (Color)((Object)list));
        }
        this.revalidate();
        this.repaint();
    }

    private void addMarkersForRanges(List<DocumentRange> list, Map<Integer, Marker> map, Color color) {
        for (DocumentRange documentRange : list) {
            int n = 0;
            try {
                n = this.textArea.getLineOfOffset(documentRange.getStartOffset());
            }
            catch (BadLocationException badLocationException) {
                continue;
            }
            MarkedOccurrenceNotice markedOccurrenceNotice = new MarkedOccurrenceNotice(documentRange, color);
            Integer n2 = n;
            Marker marker = map.get(n2);
            if (marker == null) {
                marker = new Marker(markedOccurrenceNotice);
                marker.addMouseListener(this.listener);
                map.put(n2, marker);
                this.add(marker);
                continue;
            }
            if (marker.containsMarkedOccurence()) continue;
            marker.addNotice(markedOccurrenceNotice);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.textArea.removeCaretListener(this.listener);
        this.textArea.removePropertyChangeListener("RSTA.parserNotices", this.listener);
        this.textArea.removePropertyChangeListener("RSTA.markOccurrences", this.listener);
        this.textArea.removePropertyChangeListener("RSTA.markedOccurrencesChanged", this.listener);
        this.textArea.removePropertyChangeListener("RTA.markAllOccurrencesChanged", this.listener);
    }

    public void setCaretMarkerColor(Color color) {
        if (color != null) {
            this.caretMarkerColor = color;
            this.listener.caretUpdate(null);
        }
    }

    public void setFollowCaret(boolean bl) {
        if (this.followCaret != bl) {
            if (this.followCaret) {
                this.repaint(0, this.caretLineY, this.getWidth(), 2);
            }
            this.caretLineY = -1;
            this.lastLineY = -1;
            this.followCaret = bl;
            this.listener.caretUpdate(null);
        }
    }

    public void setLevelThreshold(ParserNotice.Level level) {
        this.levelThreshold = level;
        if (this.isDisplayable()) {
            this.refreshMarkers();
        }
    }

    public void setShowMarkAll(boolean bl) {
        if (bl != this.showMarkAll) {
            this.showMarkAll = bl;
            if (this.isDisplayable()) {
                this.refreshMarkers();
            }
        }
    }

    public void setShowMarkedOccurrences(boolean bl) {
        if (bl != this.showMarkedOccurrences) {
            this.showMarkedOccurrences = bl;
            if (this.isDisplayable()) {
                this.refreshMarkers();
            }
        }
    }

    private final int yToLine(int n) {
        int n2 = -1;
        int n3 = this.textArea.getVisibleRect().height;
        if (n < n3) {
            float f = (float)n / (float)n3;
            n2 = Math.round((float)(this.textArea.getLineCount() - 1) * f);
        }
        return n2;
    }

    private class Marker
    extends JComponent {
        private List<ParserNotice> notices = new ArrayList<ParserNotice>(1);

        public Marker(ParserNotice parserNotice) {
            this.addNotice(parserNotice);
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.setSize(this.getPreferredSize());
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        public void addNotice(ParserNotice parserNotice) {
            this.notices.add(parserNotice);
        }

        public boolean containsMarkedOccurence() {
            boolean bl = false;
            for (int i = 0; i < this.notices.size(); ++i) {
                if (!(this.notices.get(i) instanceof MarkedOccurrenceNotice)) continue;
                bl = true;
                break;
            }
            return bl;
        }

        public Color getColor() {
            Color color = null;
            int n = Integer.MAX_VALUE;
            for (ParserNotice parserNotice : this.notices) {
                if (parserNotice.getLevel().getNumericValue() >= n) continue;
                n = parserNotice.getLevel().getNumericValue();
                color = parserNotice.getColor();
            }
            return color;
        }

        @Override
        public Dimension getPreferredSize() {
            int n = 10;
            return new Dimension(n, 5);
        }

        @Override
        public String getToolTipText() {
            String string = null;
            if (this.notices.size() == 1) {
                string = this.notices.get(0).getMessage();
            } else {
                StringBuilder stringBuilder = new StringBuilder("<html>");
                stringBuilder.append(msg.getString("MultipleMarkers"));
                stringBuilder.append("<br>");
                for (int i = 0; i < this.notices.size(); ++i) {
                    ParserNotice parserNotice = this.notices.get(i);
                    stringBuilder.append("&nbsp;&nbsp;&nbsp;- ");
                    stringBuilder.append(parserNotice.getMessage());
                    stringBuilder.append("<br>");
                }
                string = stringBuilder.toString();
            }
            return string;
        }

        protected void mouseClicked(MouseEvent mouseEvent) {
            ParserNotice parserNotice = this.notices.get(0);
            int n = parserNotice.getOffset();
            int n2 = parserNotice.getLength();
            if (n > -1 && n2 > -1) {
                ErrorStrip.this.textArea.setSelectionStart(n);
                ErrorStrip.this.textArea.setSelectionEnd(n + n2);
            } else {
                int n3 = parserNotice.getLine();
                try {
                    n = ErrorStrip.this.textArea.getLineStartOffset(n3);
                    ErrorStrip.this.textArea.setCaretPosition(n);
                }
                catch (BadLocationException badLocationException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(ErrorStrip.this.textArea);
                }
            }
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Color color = this.getColor();
            if (color == null) {
                color = Color.DARK_GRAY;
            }
            Color color2 = ErrorStrip.this.getBrighterColor(color);
            int n = this.getWidth();
            int n2 = this.getHeight();
            graphics.setColor(color2);
            graphics.fillRect(0, 0, n, n2);
            graphics.setColor(color);
            graphics.drawRect(0, 0, n - 1, n2 - 1);
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            ToolTipManager.sharedInstance().unregisterComponent(this);
            this.removeMouseListener(ErrorStrip.this.listener);
        }

        public void updateLocation() {
            int n = this.notices.get(0).getLine();
            int n2 = ErrorStrip.this.lineToY(n);
            this.setLocation(2, n2);
        }
    }

    private class MarkedOccurrenceNotice
    implements ParserNotice {
        private DocumentRange range;
        private Color color;

        public MarkedOccurrenceNotice(DocumentRange documentRange, Color color) {
            this.range = documentRange;
            this.color = color;
        }

        @Override
        public int compareTo(ParserNotice parserNotice) {
            return 0;
        }

        @Override
        public boolean containsPosition(int n) {
            return n >= this.range.getStartOffset() && n < this.range.getEndOffset();
        }

        public boolean equals(Object object) {
            if (!(object instanceof ParserNotice)) {
                return false;
            }
            return this.compareTo((ParserNotice)object) == 0;
        }

        @Override
        public Color getColor() {
            return this.color;
        }

        @Override
        public boolean getKnowsOffsetAndLength() {
            return true;
        }

        @Override
        public int getLength() {
            return this.range.getEndOffset() - this.range.getStartOffset();
        }

        @Override
        public ParserNotice.Level getLevel() {
            return ParserNotice.Level.INFO;
        }

        @Override
        public int getLine() {
            try {
                return ErrorStrip.this.textArea.getLineOfOffset(this.range.getStartOffset()) + 1;
            }
            catch (BadLocationException badLocationException) {
                return 0;
            }
        }

        @Override
        public String getMessage() {
            String string = null;
            try {
                String string2 = ErrorStrip.this.textArea.getText(this.range.getStartOffset(), this.getLength());
                string = msg.getString("OccurrenceOf");
                string = MessageFormat.format(string, string2);
            }
            catch (BadLocationException badLocationException) {
                UIManager.getLookAndFeel().provideErrorFeedback(ErrorStrip.this.textArea);
            }
            return string;
        }

        @Override
        public int getOffset() {
            return this.range.getStartOffset();
        }

        @Override
        public Parser getParser() {
            return null;
        }

        @Override
        public boolean getShowInEditor() {
            return false;
        }

        @Override
        public String getToolTipText() {
            return null;
        }

        public int hashCode() {
            return 0;
        }
    }

    private class Listener
    extends MouseAdapter
    implements PropertyChangeListener,
    CaretListener {
        private Rectangle visibleRect = new Rectangle();

        private Listener() {
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            if (ErrorStrip.this.getFollowCaret()) {
                int n = ErrorStrip.this.textArea.getCaretLineNumber();
                float f = (float)n / (float)(ErrorStrip.this.textArea.getLineCount() - 1);
                ErrorStrip.this.textArea.computeVisibleRect(this.visibleRect);
                ErrorStrip.this.caretLineY = (int)((float)this.visibleRect.height * f);
                if (ErrorStrip.this.caretLineY != ErrorStrip.this.lastLineY) {
                    ErrorStrip.this.repaint(0, ErrorStrip.this.lastLineY, ErrorStrip.this.getWidth(), 2);
                    ErrorStrip.this.repaint(0, ErrorStrip.this.caretLineY, ErrorStrip.this.getWidth(), 2);
                    ErrorStrip.this.lastLineY = ErrorStrip.this.caretLineY;
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Component component = (Component)mouseEvent.getSource();
            if (component instanceof Marker) {
                ((Marker)component).mouseClicked(mouseEvent);
                return;
            }
            int n = ErrorStrip.this.yToLine(mouseEvent.getY());
            if (n > -1) {
                try {
                    int n2 = ErrorStrip.this.textArea.getLineStartOffset(n);
                    ErrorStrip.this.textArea.setCaretPosition(n2);
                }
                catch (BadLocationException badLocationException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(ErrorStrip.this.textArea);
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("RSTA.markOccurrences".equals(string)) {
                if (ErrorStrip.this.getShowMarkedOccurrences()) {
                    ErrorStrip.this.refreshMarkers();
                }
            } else if ("RSTA.parserNotices".equals(string)) {
                ErrorStrip.this.refreshMarkers();
            } else if ("RSTA.markedOccurrencesChanged".equals(string)) {
                if (ErrorStrip.this.getShowMarkedOccurrences()) {
                    ErrorStrip.this.refreshMarkers();
                }
            } else if ("RTA.markAllOccurrencesChanged".equals(string) && ErrorStrip.this.getShowMarkAll()) {
                ErrorStrip.this.refreshMarkers();
            }
        }
    }
}

