/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model;

import com.thoughtworks.qdox.JavaClassContext;
import com.thoughtworks.qdox.model.ClassLibrary;
import com.thoughtworks.qdox.model.IndentBuffer;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaClassParent;
import com.thoughtworks.qdox.model.JavaPackage;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class JavaSource
implements Serializable,
JavaClassParent {
    private static final Set PRIMITIVE_TYPES = new HashSet();
    private JavaPackage packge;
    private List imports = new LinkedList();
    private String[] importsArray;
    private List classes = new LinkedList();
    private JavaClass[] classesArray;
    private JavaClassContext context;
    private Map resolvedTypeCache = new HashMap();
    private URL url;

    public JavaSource() {
        this(new JavaClassContext((ClassLibrary)null));
    }

    public JavaSource(JavaClassContext javaClassContext) {
        this.context = javaClassContext;
    }

    public void setURL(URL uRL) {
        this.url = uRL;
    }

    public URL getURL() {
        return this.url;
    }

    public void setFile(File file) {
        try {
            this.setURL(file.toURL());
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalStateException(malformedURLException.getMessage());
        }
    }

    public File getFile() {
        return new File(this.url.getFile());
    }

    public JavaPackage getPackage() {
        return this.packge;
    }

    public void setPackage(JavaPackage javaPackage) {
        this.packge = javaPackage;
    }

    public void addImport(String string) {
        this.imports.add(string);
        this.importsArray = null;
    }

    public String[] getImports() {
        if (this.importsArray == null) {
            this.importsArray = new String[this.imports.size()];
            this.imports.toArray(this.importsArray);
        }
        return this.importsArray;
    }

    @Override
    public void addClass(JavaClass javaClass) {
        javaClass.setSource(this);
        this.classes.add(javaClass);
        this.classesArray = null;
    }

    public JavaClass[] getClasses() {
        if (this.classesArray == null) {
            this.classesArray = new JavaClass[this.classes.size()];
            this.classes.toArray(this.classesArray);
        }
        return this.classesArray;
    }

    @Override
    public JavaClassContext getJavaClassContext() {
        return this.context;
    }

    public void setClassLibrary(ClassLibrary classLibrary) {
        this.context.setClassLibrary(classLibrary);
    }

    public String getCodeBlock() {
        IndentBuffer indentBuffer = new IndentBuffer();
        if (this.packge != null) {
            indentBuffer.write("package ");
            indentBuffer.write(this.packge.getName());
            indentBuffer.write(';');
            indentBuffer.newline();
            indentBuffer.newline();
        }
        String[] stringArray = this.getImports();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            indentBuffer.write("import ");
            indentBuffer.write(stringArray[i]);
            indentBuffer.write(';');
            indentBuffer.newline();
        }
        if (stringArray != null && stringArray.length > 0) {
            indentBuffer.newline();
        }
        JavaClass[] javaClassArray = this.getClasses();
        for (int i = 0; i < javaClassArray.length; ++i) {
            if (i > 0) {
                indentBuffer.newline();
            }
            javaClassArray[i].write(indentBuffer);
        }
        return indentBuffer.toString();
    }

    public String toString() {
        return this.getCodeBlock();
    }

    @Override
    public String resolveType(String string) {
        if (this.resolvedTypeCache.containsKey(string)) {
            return (String)this.resolvedTypeCache.get(string);
        }
        String string2 = this.resolveTypeInternal(string);
        if (string2 != null) {
            this.resolvedTypeCache.put(string, string2);
        }
        return string2;
    }

    private String resolveTypeInternal(String string) {
        String string2 = null;
        if (PRIMITIVE_TYPES.contains(string)) {
            string2 = string;
        } else {
            String string3 = string;
            String string4 = string.replace('.', '$');
            int n = string.indexOf(46);
            if (n >= 0) {
                string3 = string.substring(0, n);
            }
            if ((string2 = this.resolveImportedType(string, string4, true)) != null || (string2 = this.resolveImportedType(string3, string4, false)) != null || (string2 = this.resolveFullyQualifiedType(string)) != null || this.context.getClassLibrary() != null && ((string2 = this.resolveFromLibrary(this.getClassNamePrefix() + string4)) != null || (string2 = this.resolveFromLibrary("java.lang." + string4)) != null) || (string2 = this.resolveImportedType("*", string4, false)) == null) {
                // empty if block
            }
        }
        return string2;
    }

    private String resolveImportedType(String string, String string2, boolean bl) {
        String[] stringArray = this.getImports();
        String string3 = null;
        String string4 = "." + string;
        for (int i = 0; i < stringArray.length && string3 == null; ++i) {
            String string5;
            String string6 = stringArray[i];
            if (string6.startsWith("static ")) {
                string6 = string6.substring(7);
            }
            if (!string6.equals(string) && (bl || !string6.endsWith(string4)) || (string3 = this.resolveFullyQualifiedType(string5 = string6.substring(0, string6.length() - string.length()) + string2)) != null || "*".equals(string)) continue;
            string3 = string5;
        }
        return string3;
    }

    private String resolveFromLibrary(String string) {
        return this.context.getClassLibrary().contains(string) ? string : null;
    }

    private String resolveFullyQualifiedType(String string) {
        if (this.context.getClassLibrary() != null) {
            int n = string.lastIndexOf(46);
            if (n >= 0) {
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                String string4 = this.resolveFullyQualifiedType(string2 + "$" + string3);
                if (string4 != null) {
                    return string4;
                }
            }
            if (this.context.getClassLibrary().contains(string)) {
                return string;
            }
        }
        return null;
    }

    @Override
    public String getClassNamePrefix() {
        if (this.getPackage() == null) {
            return "";
        }
        return this.getPackage().getName() + ".";
    }

    @Override
    public JavaSource getParentSource() {
        return this;
    }

    @Override
    public JavaClass getNestedClassByName(String string) {
        JavaClass javaClass = null;
        ListIterator listIterator = this.classes.listIterator();
        while (listIterator.hasNext()) {
            JavaClass javaClass2 = (JavaClass)listIterator.next();
            if (!javaClass2.getName().equals(string)) continue;
            javaClass = javaClass2;
            break;
        }
        return javaClass;
    }

    public ClassLibrary getClassLibrary() {
        return this.context.getClassLibrary();
    }

    public String getPackageName() {
        return this.packge == null ? "" : this.packge.getName();
    }

    static {
        PRIMITIVE_TYPES.add("boolean");
        PRIMITIVE_TYPES.add("byte");
        PRIMITIVE_TYPES.add("char");
        PRIMITIVE_TYPES.add("double");
        PRIMITIVE_TYPES.add("float");
        PRIMITIVE_TYPES.add("int");
        PRIMITIVE_TYPES.add("long");
        PRIMITIVE_TYPES.add("short");
        PRIMITIVE_TYPES.add("void");
    }
}

