/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model;

import com.thoughtworks.qdox.model.AbstractBaseJavaEntity;
import com.thoughtworks.qdox.model.Type;
import com.thoughtworks.qdox.model.annotation.AnnotationValue;
import com.thoughtworks.qdox.model.annotation.AnnotationVisitor;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class Annotation
implements AnnotationValue,
Serializable {
    private final Type type;
    private final int lineNumber;
    private final Map properties = new LinkedHashMap();
    private final Map namedParameters = new LinkedHashMap();
    private AbstractBaseJavaEntity context;

    public Annotation(Type type, AbstractBaseJavaEntity abstractBaseJavaEntity, Map map, int n) {
        this.type = type;
        this.context = abstractBaseJavaEntity;
        this.lineNumber = n;
        if (this.properties != null) {
            for (Map.Entry entry : this.properties.entrySet()) {
                String string = (String)entry.getKey();
                AnnotationValue annotationValue = (AnnotationValue)entry.getValue();
                this.setProperty(string, annotationValue);
            }
        }
    }

    public Annotation(Type type, int n) {
        this(type, null, null, n);
    }

    public void setProperty(String string, AnnotationValue annotationValue) {
        this.properties.put(string, annotationValue);
        this.namedParameters.put(string, annotationValue.getParameterValue());
    }

    public Type getType() {
        return this.type;
    }

    public Object getNamedParameter(String string) {
        return this.namedParameters.get(string);
    }

    public Map getNamedParameterMap() {
        return this.namedParameters;
    }

    public final AbstractBaseJavaEntity getContext() {
        return this.context;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public Object accept(AnnotationVisitor annotationVisitor) {
        return annotationVisitor.visitAnnotation(this);
    }

    @Override
    public Object getParameterValue() {
        return this;
    }

    public Map getPropertyMap() {
        return this.properties;
    }

    public AnnotationValue getProperty(String string) {
        return (AnnotationValue)this.properties.get(string);
    }

    public void setContext(AbstractBaseJavaEntity abstractBaseJavaEntity) {
        this.context = abstractBaseJavaEntity;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('@');
        stringBuffer.append(this.type.getValue());
        stringBuffer.append('(');
        if (!this.namedParameters.isEmpty()) {
            Iterator iterator = this.namedParameters.entrySet().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next() + ",");
            }
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

