/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io;

import com.fasterxml.jackson.core.io.IOContext;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class UTF32Reader
extends Reader {
    protected static final int LAST_VALID_UNICODE_CHAR = 0x10FFFF;
    protected static final char NC = '\u0000';
    protected final IOContext _context;
    protected InputStream _in;
    protected byte[] _buffer;
    protected int _ptr;
    protected int _length;
    protected final boolean _bigEndian;
    protected char _surrogate = '\u0000';
    protected int _charCount;
    protected int _byteCount;
    protected final boolean _managedBuffers;
    protected char[] _tmpBuf;

    public UTF32Reader(IOContext iOContext, InputStream inputStream, byte[] byArray, int n, int n2, boolean bl) {
        this._context = iOContext;
        this._in = inputStream;
        this._buffer = byArray;
        this._ptr = n;
        this._length = n2;
        this._bigEndian = bl;
        this._managedBuffers = inputStream != null;
    }

    @Override
    public void close() throws IOException {
        InputStream inputStream = this._in;
        if (inputStream != null) {
            this._in = null;
            this.freeBuffers();
            inputStream.close();
        }
    }

    @Override
    public int read() throws IOException {
        if (this._tmpBuf == null) {
            this._tmpBuf = new char[1];
        }
        if (this.read(this._tmpBuf, 0, 1) < 1) {
            return -1;
        }
        return this._tmpBuf[0];
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3;
        if (this._buffer == null) {
            return -1;
        }
        if (n2 < 1) {
            return n2;
        }
        if (n < 0 || n + n2 > cArray.length) {
            this.reportBounds(cArray, n, n2);
        }
        n2 += n;
        int n4 = n;
        if (this._surrogate != '\u0000') {
            cArray[n4++] = this._surrogate;
            this._surrogate = '\u0000';
        } else {
            n3 = this._length - this._ptr;
            if (n3 < 4 && !this.loadMore(n3)) {
                return -1;
            }
        }
        while (n4 < n2) {
            n3 = this._ptr;
            int n5 = this._bigEndian ? this._buffer[n3] << 24 | (this._buffer[n3 + 1] & 0xFF) << 16 | (this._buffer[n3 + 2] & 0xFF) << 8 | this._buffer[n3 + 3] & 0xFF : this._buffer[n3] & 0xFF | (this._buffer[n3 + 1] & 0xFF) << 8 | (this._buffer[n3 + 2] & 0xFF) << 16 | this._buffer[n3 + 3] << 24;
            this._ptr += 4;
            if (n5 > 65535) {
                if (n5 > 0x10FFFF) {
                    this.reportInvalid(n5, n4 - n, "(above " + Integer.toHexString(0x10FFFF) + ") ");
                }
                cArray[n4++] = (char)(55296 + ((n5 -= 65536) >> 10));
                n5 = 0xDC00 | n5 & 0x3FF;
                if (n4 >= n2) {
                    this._surrogate = (char)n5;
                    break;
                }
            }
            cArray[n4++] = (char)n5;
            if (this._ptr < this._length) continue;
            break;
        }
        n2 = n4 - n;
        this._charCount += n2;
        return n2;
    }

    private void reportUnexpectedEOF(int n, int n2) throws IOException {
        int n3 = this._byteCount + n;
        int n4 = this._charCount;
        throw new CharConversionException("Unexpected EOF in the middle of a 4-byte UTF-32 char: got " + n + ", needed " + n2 + ", at char #" + n4 + ", byte #" + n3 + ")");
    }

    private void reportInvalid(int n, int n2, String string) throws IOException {
        int n3 = this._byteCount + this._ptr - 1;
        int n4 = this._charCount + n2;
        throw new CharConversionException("Invalid UTF-32 character 0x" + Integer.toHexString(n) + string + " at char #" + n4 + ", byte #" + n3 + ")");
    }

    private boolean loadMore(int n) throws IOException {
        int n2;
        this._byteCount += this._length - n;
        if (n > 0) {
            if (this._ptr > 0) {
                System.arraycopy(this._buffer, this._ptr, this._buffer, 0, n);
                this._ptr = 0;
            }
            this._length = n;
        } else {
            this._ptr = 0;
            int n3 = n2 = this._in == null ? -1 : this._in.read(this._buffer);
            if (n2 < 1) {
                this._length = 0;
                if (n2 < 0) {
                    if (this._managedBuffers) {
                        this.freeBuffers();
                    }
                    return false;
                }
                this.reportStrangeStream();
            }
            this._length = n2;
        }
        while (this._length < 4) {
            int n4 = n2 = this._in == null ? -1 : this._in.read(this._buffer, this._length, this._buffer.length - this._length);
            if (n2 < 1) {
                if (n2 < 0) {
                    if (this._managedBuffers) {
                        this.freeBuffers();
                    }
                    this.reportUnexpectedEOF(this._length, 4);
                }
                this.reportStrangeStream();
            }
            this._length += n2;
        }
        return true;
    }

    private void freeBuffers() {
        byte[] byArray = this._buffer;
        if (byArray != null) {
            this._buffer = null;
            this._context.releaseReadIOBuffer(byArray);
        }
    }

    private void reportBounds(char[] cArray, int n, int n2) throws IOException {
        throw new ArrayIndexOutOfBoundsException("read(buf," + n + "," + n2 + "), cbuf[" + cArray.length + "]");
    }

    private void reportStrangeStream() throws IOException {
        throw new IOException("Strange I/O stream, returned 0 bytes on read");
    }
}

