/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AggregateFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import javax.annotation.Nullable;

@GwtCompatible
abstract class CollectionFuture<V, C>
extends AggregateFuture<V, C> {
    CollectionFuture() {
    }

    abstract class CollectionFutureRunningState
    extends AggregateFuture.RunningState {
        private List<Optional<V>> values;

        CollectionFutureRunningState(ImmutableCollection<? extends ListenableFuture<? extends V>> immutableCollection, boolean bl) {
            super(immutableCollection, bl, true);
            this.values = (List)((Object)(immutableCollection.isEmpty() ? ImmutableList.of() : Lists.newArrayListWithCapacity(immutableCollection.size())));
            for (int i = 0; i < immutableCollection.size(); ++i) {
                this.values.add(null);
            }
        }

        final void collectOneValue(boolean bl, int n, @Nullable V v) {
            List list = this.values;
            if (list != null) {
                list.set(n, Optional.fromNullable(v));
            } else {
                Preconditions.checkState(bl || CollectionFuture.this.isCancelled(), "Future was done before all dependencies completed");
            }
        }

        @Override
        final void handleAllCompleted() {
            List list = this.values;
            if (list != null) {
                CollectionFuture.this.set(this.combine(list));
            } else {
                Preconditions.checkState(CollectionFuture.this.isDone());
            }
        }

        @Override
        void releaseResourcesAfterFailure() {
            super.releaseResourcesAfterFailure();
            this.values = null;
        }

        abstract C combine(List<Optional<V>> var1);
    }
}

