/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.io.AppendableWriter;
import com.google.common.io.LineProcessor;
import com.google.common.io.LineReader;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;

@Beta
public final class CharStreams {
    private static final int BUF_SIZE = 2048;

    private CharStreams() {
    }

    public static long copy(Readable readable, Appendable appendable) throws IOException {
        Preconditions.checkNotNull(readable);
        Preconditions.checkNotNull(appendable);
        CharBuffer charBuffer = CharBuffer.allocate(2048);
        long l = 0L;
        while (readable.read(charBuffer) != -1) {
            charBuffer.flip();
            appendable.append(charBuffer);
            l += (long)charBuffer.remaining();
            charBuffer.clear();
        }
        return l;
    }

    public static String toString(Readable readable) throws IOException {
        return CharStreams.toStringBuilder(readable).toString();
    }

    private static StringBuilder toStringBuilder(Readable readable) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        CharStreams.copy(readable, stringBuilder);
        return stringBuilder;
    }

    public static List<String> readLines(Readable readable) throws IOException {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        LineReader lineReader = new LineReader(readable);
        while ((string = lineReader.readLine()) != null) {
            arrayList.add(string);
        }
        return arrayList;
    }

    public static <T> T readLines(Readable readable, LineProcessor<T> lineProcessor) throws IOException {
        String string;
        Preconditions.checkNotNull(readable);
        Preconditions.checkNotNull(lineProcessor);
        LineReader lineReader = new LineReader(readable);
        while ((string = lineReader.readLine()) != null && lineProcessor.processLine(string)) {
        }
        return lineProcessor.getResult();
    }

    public static void skipFully(Reader reader, long l) throws IOException {
        Preconditions.checkNotNull(reader);
        while (l > 0L) {
            long l2 = reader.skip(l);
            if (l2 == 0L) {
                throw new EOFException();
            }
            l -= l2;
        }
    }

    public static Writer nullWriter() {
        return NullWriter.INSTANCE;
    }

    public static Writer asWriter(Appendable appendable) {
        if (appendable instanceof Writer) {
            return (Writer)appendable;
        }
        return new AppendableWriter(appendable);
    }

    static Reader asReader(final Readable readable) {
        Preconditions.checkNotNull(readable);
        if (readable instanceof Reader) {
            return (Reader)readable;
        }
        return new Reader(){

            @Override
            public int read(char[] cArray, int n, int n2) throws IOException {
                return this.read(CharBuffer.wrap(cArray, n, n2));
            }

            @Override
            public int read(CharBuffer charBuffer) throws IOException {
                return readable.read(charBuffer);
            }

            @Override
            public void close() throws IOException {
                if (readable instanceof Closeable) {
                    ((Closeable)((Object)readable)).close();
                }
            }
        };
    }

    private static final class NullWriter
    extends Writer {
        private static final NullWriter INSTANCE = new NullWriter();

        private NullWriter() {
        }

        @Override
        public void write(int n) {
        }

        @Override
        public void write(char[] cArray) {
            Preconditions.checkNotNull(cArray);
        }

        @Override
        public void write(char[] cArray, int n, int n2) {
            Preconditions.checkPositionIndexes(n, n + n2, cArray.length);
        }

        @Override
        public void write(String string) {
            Preconditions.checkNotNull(string);
        }

        @Override
        public void write(String string, int n, int n2) {
            Preconditions.checkPositionIndexes(n, n + n2, string.length());
        }

        @Override
        public Writer append(CharSequence charSequence) {
            Preconditions.checkNotNull(charSequence);
            return this;
        }

        @Override
        public Writer append(CharSequence charSequence, int n, int n2) {
            Preconditions.checkPositionIndexes(n, n2, charSequence.length());
            return this;
        }

        @Override
        public Writer append(char c) {
            return this;
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }

        public String toString() {
            return "CharStreams.nullWriter()";
        }
    }
}

