/*
 * Decompiled with CFR 0.152.
 */
package javax.persistence.spi;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceProviderResolver;
import org.apache.geronimo.osgi.locator.ProviderLocator;

public class PersistenceProviderResolverHolder {
    private static PersistenceProviderResolver persistenceResolver = new DefaultPersistenceProviderResolver();

    public static PersistenceProviderResolver getPersistenceProviderResolver() {
        return persistenceResolver;
    }

    public static void setPersistenceProviderResolver(PersistenceProviderResolver persistenceProviderResolver) {
        if (persistenceResolver != null) {
            persistenceResolver.clearCachedProviders();
            persistenceResolver = null;
        }
        persistenceResolver = persistenceProviderResolver != null ? persistenceProviderResolver : new DefaultPersistenceProviderResolver();
    }

    private static class DefaultPersistenceProviderResolver
    implements PersistenceProviderResolver {
        private static final String SERVICES_FILENAME = "META-INF/services/" + PersistenceProvider.class.getName();
        private volatile WeakHashMap<ClassLoader, List<PersistenceProvider>> providerCache = new WeakHashMap();

        private DefaultPersistenceProviderResolver() {
        }

        @Override
        public List<PersistenceProvider> getPersistenceProviders() {
            List<PersistenceProvider> list;
            ClassLoader classLoader = PrivClassLoader.get(null);
            if (classLoader == null) {
                classLoader = PrivClassLoader.get(DefaultPersistenceProviderResolver.class);
            }
            if ((list = this.providerCache.get(classLoader)) == null) {
                list = new ArrayList<PersistenceProvider>();
                try {
                    List list2 = ProviderLocator.getServices((String)PersistenceProvider.class.getName(), this.getClass(), (ClassLoader)classLoader);
                    for (Object e : list2) {
                        list.add((PersistenceProvider)e);
                    }
                    this.providerCache.put(classLoader, list);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new PersistenceException("Failed to load provider from META-INF/services", classNotFoundException);
                }
                catch (InstantiationException instantiationException) {
                    throw new PersistenceException("Failed to load provider from META-INF/services", instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new PersistenceException("Failed to load provider from META-INF/services", illegalAccessException);
                }
                catch (Exception exception) {
                    throw new PersistenceException("Failed to load provider from META-INF/services", exception);
                }
            }
            return list;
        }

        @Override
        public void clearCachedProviders() {
            this.providerCache.clear();
        }

        private static class PrivClassLoader
        implements PrivilegedAction<ClassLoader> {
            private final Class<?> c;

            public static ClassLoader get(Class<?> clazz) {
                PrivClassLoader privClassLoader = new PrivClassLoader(clazz);
                if (System.getSecurityManager() != null) {
                    return AccessController.doPrivileged(privClassLoader);
                }
                return privClassLoader.run();
            }

            private PrivClassLoader(Class<?> clazz) {
                this.c = clazz;
            }

            @Override
            public ClassLoader run() {
                if (this.c != null) {
                    return this.c.getClassLoader();
                }
                return Thread.currentThread().getContextClassLoader();
            }
        }
    }
}

