/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;

public class StringUtils {
    private static final String SINGLE_QUOTE = "'";
    private static final String DOUBLE_QUOTE = "\"";
    private static final char SLASH_CHAR = '/';
    private static final char BACKSLASH_CHAR = '\\';

    public static StringBuffer stringSubstitution(String string, Map<? super String, ?> map, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string == null || string.length() == 0) {
            return stringBuffer;
        }
        if (map == null || map.size() == 0) {
            return stringBuffer.append(string);
        }
        int n = string.length();
        int n2 = 0;
        block3: while (n2 < n) {
            char c = string.charAt(n2);
            int n3 = 32;
            switch (c) {
                case '$': {
                    StringBuilder stringBuilder = new StringBuilder();
                    n3 = string.charAt(n2 + 1);
                    if (n3 == 123) {
                        ++n2;
                        ++n2;
                        while (n2 < string.length() && ((c = string.charAt(n2)) == '_' || c == '.' || c == '-' || c == '+' || Character.isLetterOrDigit(c))) {
                            stringBuilder.append(c);
                            ++n2;
                        }
                        if (stringBuilder.length() >= 0) {
                            String string2;
                            Object obj = map.get(stringBuilder.toString());
                            if (obj instanceof File) {
                                string2 = StringUtils.fixFileSeparatorChar(((File)obj).getAbsolutePath());
                            } else {
                                String string3 = string2 = obj != null ? obj.toString() : null;
                            }
                            if (string2 != null) {
                                stringBuffer.append(string2);
                            } else if (bl) {
                                stringBuffer.append("${").append(stringBuilder.toString()).append("}");
                            } else {
                                throw new RuntimeException("No value found for : " + stringBuilder);
                            }
                            n3 = string.charAt(n2);
                            if (n3 != 125) {
                                throw new RuntimeException("Delimiter not found for : " + stringBuilder);
                            }
                        }
                        ++n2;
                        continue block3;
                    }
                    stringBuffer.append(c);
                    ++n2;
                    continue block3;
                }
            }
            stringBuffer.append(c);
            ++n2;
        }
        return stringBuffer;
    }

    public static String[] split(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String fixFileSeparatorChar(String string) {
        return string.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    public static String toString(String[] stringArray, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    public static String quoteArgument(String string) {
        String string2 = string.trim();
        while (string2.startsWith(SINGLE_QUOTE) || string2.startsWith(DOUBLE_QUOTE)) {
            string2 = string2.substring(1);
        }
        while (string2.endsWith(SINGLE_QUOTE) || string2.endsWith(DOUBLE_QUOTE)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (string2.indexOf(DOUBLE_QUOTE) > -1) {
            if (string2.indexOf(SINGLE_QUOTE) > -1) {
                throw new IllegalArgumentException("Can't handle single and double quotes in same argument");
            }
            return stringBuilder.append(SINGLE_QUOTE).append(string2).append(SINGLE_QUOTE).toString();
        }
        if (string2.indexOf(SINGLE_QUOTE) > -1 || string2.indexOf(" ") > -1) {
            return stringBuilder.append(DOUBLE_QUOTE).append(string2).append(DOUBLE_QUOTE).toString();
        }
        return string2;
    }

    public static boolean isQuoted(String string) {
        return string.startsWith(SINGLE_QUOTE) && string.endsWith(SINGLE_QUOTE) || string.startsWith(DOUBLE_QUOTE) && string.endsWith(DOUBLE_QUOTE);
    }
}

