/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec;

import java.util.Locale;

public final class OS {
    private static final String FAMILY_OS_400 = "os/400";
    private static final String FAMILY_Z_OS = "z/os";
    private static final String FAMILY_WIN9X = "win9x";
    private static final String FAMILY_OPENVMS = "openvms";
    private static final String FAMILY_UNIX = "unix";
    private static final String FAMILY_TANDEM = "tandem";
    private static final String FAMILY_MAC = "mac";
    private static final String FAMILY_DOS = "dos";
    private static final String FAMILY_NETWARE = "netware";
    private static final String FAMILY_OS_2 = "os/2";
    private static final String FAMILY_WINDOWS = "windows";
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
    private static final String OS_ARCH = System.getProperty("os.arch").toLowerCase(Locale.US);
    private static final String OS_VERSION = System.getProperty("os.version").toLowerCase(Locale.US);
    private static final String PATH_SEP = System.getProperty("path.separator");

    private OS() {
    }

    private static boolean isFamily(String string) {
        return OS.isOs(string, null, null, null);
    }

    public static boolean isFamilyDOS() {
        return OS.isFamily(FAMILY_DOS);
    }

    public static boolean isFamilyMac() {
        return OS.isFamily(FAMILY_MAC);
    }

    public static boolean isFamilyNetware() {
        return OS.isFamily(FAMILY_NETWARE);
    }

    public static boolean isFamilyOS2() {
        return OS.isFamily(FAMILY_OS_2);
    }

    public static boolean isFamilyTandem() {
        return OS.isFamily(FAMILY_TANDEM);
    }

    public static boolean isFamilyUnix() {
        return OS.isFamily(FAMILY_UNIX);
    }

    public static boolean isFamilyWindows() {
        return OS.isFamily(FAMILY_WINDOWS);
    }

    public static boolean isFamilyWin9x() {
        return OS.isFamily(FAMILY_WIN9X);
    }

    public static boolean isFamilyZOS() {
        return OS.isFamily(FAMILY_Z_OS);
    }

    public static boolean isFamilyOS400() {
        return OS.isFamily(FAMILY_OS_400);
    }

    public static boolean isFamilyOpenVms() {
        return OS.isFamily(FAMILY_OPENVMS);
    }

    public static boolean isName(String string) {
        return OS.isOs(null, string, null, null);
    }

    public static boolean isArch(String string) {
        return OS.isOs(null, null, string, null);
    }

    public static boolean isVersion(String string) {
        return OS.isOs(null, null, null, string);
    }

    public static boolean isOs(String string, String string2, String string3, String string4) {
        boolean bl = false;
        if (string != null || string2 != null || string3 != null || string4 != null) {
            boolean bl2 = true;
            boolean bl3 = true;
            boolean bl4 = true;
            boolean bl5 = true;
            if (string != null) {
                if (string.equals(FAMILY_WINDOWS)) {
                    bl2 = OS_NAME.indexOf(FAMILY_WINDOWS) > -1;
                } else if (string.equals(FAMILY_OS_2)) {
                    bl2 = OS_NAME.indexOf(FAMILY_OS_2) > -1;
                } else if (string.equals(FAMILY_NETWARE)) {
                    bl2 = OS_NAME.indexOf(FAMILY_NETWARE) > -1;
                } else if (string.equals(FAMILY_DOS)) {
                    bl2 = PATH_SEP.equals(";") && !OS.isFamily(FAMILY_NETWARE);
                } else if (string.equals(FAMILY_MAC)) {
                    bl2 = OS_NAME.indexOf(FAMILY_MAC) > -1;
                } else if (string.equals(FAMILY_TANDEM)) {
                    bl2 = OS_NAME.indexOf("nonstop_kernel") > -1;
                } else if (string.equals(FAMILY_UNIX)) {
                    bl2 = PATH_SEP.equals(":") && !OS.isFamily(FAMILY_OPENVMS) && (!OS.isFamily(FAMILY_MAC) || OS_NAME.endsWith("x"));
                } else if (string.equals(FAMILY_WIN9X)) {
                    bl2 = OS.isFamily(FAMILY_WINDOWS) && (OS_NAME.indexOf("95") >= 0 || OS_NAME.indexOf("98") >= 0 || OS_NAME.indexOf("me") >= 0 || OS_NAME.indexOf("ce") >= 0);
                } else if (string.equals(FAMILY_Z_OS)) {
                    bl2 = OS_NAME.indexOf(FAMILY_Z_OS) > -1 || OS_NAME.indexOf("os/390") > -1;
                } else if (string.equals(FAMILY_OS_400)) {
                    bl2 = OS_NAME.indexOf(FAMILY_OS_400) > -1;
                } else if (string.equals(FAMILY_OPENVMS)) {
                    bl2 = OS_NAME.indexOf(FAMILY_OPENVMS) > -1;
                } else {
                    throw new IllegalArgumentException("Don't know how to detect os family \"" + string + "\"");
                }
            }
            if (string2 != null) {
                bl3 = string2.equals(OS_NAME);
            }
            if (string3 != null) {
                bl4 = string3.equals(OS_ARCH);
            }
            if (string4 != null) {
                bl5 = string4.equals(OS_VERSION);
            }
            bl = bl2 && bl3 && bl4 && bl5;
        }
        return bl;
    }
}

