/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ExplodingInputStream;
import org.apache.commons.compress.archivers.zip.GeneralPurposeBit;
import org.apache.commons.compress.archivers.zip.UnshrinkingInputStream;
import org.apache.commons.compress.archivers.zip.UnsupportedZipFeatureException;
import org.apache.commons.compress.archivers.zip.Zip64ExtendedInformationExtraField;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipEightByteInteger;
import org.apache.commons.compress.archivers.zip.ZipEncoding;
import org.apache.commons.compress.archivers.zip.ZipEncodingHelper;
import org.apache.commons.compress.archivers.zip.ZipLong;
import org.apache.commons.compress.archivers.zip.ZipMethod;
import org.apache.commons.compress.archivers.zip.ZipShort;
import org.apache.commons.compress.archivers.zip.ZipUtil;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.utils.ArchiveUtils;
import org.apache.commons.compress.utils.IOUtils;

public class ZipArchiveInputStream
extends ArchiveInputStream {
    private final ZipEncoding zipEncoding;
    final String encoding;
    private final boolean useUnicodeExtraFields;
    private final InputStream in;
    private final Inflater inf = new Inflater(true);
    private final ByteBuffer buf = ByteBuffer.allocate(512);
    private CurrentEntry current = null;
    private boolean closed = false;
    private boolean hitCentralDirectory = false;
    private ByteArrayInputStream lastStoredEntry = null;
    private boolean allowStoredEntriesWithDataDescriptor = false;
    private static final int LFH_LEN = 30;
    private static final int CFH_LEN = 46;
    private static final long TWO_EXP_32 = 0x100000000L;
    private final byte[] lfhBuf = new byte[30];
    private final byte[] skipBuf = new byte[1024];
    private final byte[] shortBuf = new byte[2];
    private final byte[] wordBuf = new byte[4];
    private final byte[] twoDwordBuf = new byte[16];
    private int entriesRead = 0;
    private static final byte[] LFH = ZipLong.LFH_SIG.getBytes();
    private static final byte[] CFH = ZipLong.CFH_SIG.getBytes();
    private static final byte[] DD = ZipLong.DD_SIG.getBytes();

    public ZipArchiveInputStream(InputStream inputStream) {
        this(inputStream, "UTF8");
    }

    public ZipArchiveInputStream(InputStream inputStream, String string) {
        this(inputStream, string, true);
    }

    public ZipArchiveInputStream(InputStream inputStream, String string, boolean bl) {
        this(inputStream, string, bl, false);
    }

    public ZipArchiveInputStream(InputStream inputStream, String string, boolean bl, boolean bl2) {
        this.encoding = string;
        this.zipEncoding = ZipEncodingHelper.getZipEncoding(string);
        this.useUnicodeExtraFields = bl;
        this.in = new PushbackInputStream(inputStream, this.buf.capacity());
        this.allowStoredEntriesWithDataDescriptor = bl2;
        this.buf.limit(0);
    }

    public ZipArchiveEntry getNextZipEntry() throws IOException {
        boolean bl = true;
        if (this.closed || this.hitCentralDirectory) {
            return null;
        }
        if (this.current != null) {
            this.closeEntry();
            bl = false;
        }
        try {
            if (bl) {
                this.readFirstLocalFileHeader(this.lfhBuf);
            } else {
                this.readFully(this.lfhBuf);
            }
        }
        catch (EOFException eOFException) {
            return null;
        }
        ZipLong zipLong = new ZipLong(this.lfhBuf);
        if (zipLong.equals(ZipLong.CFH_SIG) || zipLong.equals(ZipLong.AED_SIG)) {
            this.hitCentralDirectory = true;
            this.skipRemainderOfArchive();
            return null;
        }
        if (!zipLong.equals(ZipLong.LFH_SIG)) {
            throw new ZipException(String.format("Unexpected record signature: 0X%X", zipLong.getValue()));
        }
        int n = 4;
        this.current = new CurrentEntry();
        int n2 = ZipShort.getValue(this.lfhBuf, n);
        this.current.entry.setPlatform(n2 >> 8 & 0xF);
        GeneralPurposeBit generalPurposeBit = GeneralPurposeBit.parse(this.lfhBuf, n += 2);
        boolean bl2 = generalPurposeBit.usesUTF8ForNames();
        ZipEncoding zipEncoding = bl2 ? ZipEncodingHelper.UTF8_ZIP_ENCODING : this.zipEncoding;
        this.current.hasDataDescriptor = generalPurposeBit.usesDataDescriptor();
        this.current.entry.setGeneralPurposeBit(generalPurposeBit);
        this.current.entry.setMethod(ZipShort.getValue(this.lfhBuf, n += 2));
        long l = ZipUtil.dosToJavaTime(ZipLong.getValue(this.lfhBuf, n += 2));
        this.current.entry.setTime(l);
        n += 4;
        ZipLong zipLong2 = null;
        ZipLong zipLong3 = null;
        if (!this.current.hasDataDescriptor) {
            this.current.entry.setCrc(ZipLong.getValue(this.lfhBuf, n));
            zipLong3 = new ZipLong(this.lfhBuf, n += 4);
            zipLong2 = new ZipLong(this.lfhBuf, n += 4);
            n += 4;
        } else {
            n += 12;
        }
        int n3 = ZipShort.getValue(this.lfhBuf, n);
        int n4 = ZipShort.getValue(this.lfhBuf, n += 2);
        n += 2;
        byte[] byArray = new byte[n3];
        this.readFully(byArray);
        this.current.entry.setName(zipEncoding.decode(byArray), byArray);
        byte[] byArray2 = new byte[n4];
        this.readFully(byArray2);
        this.current.entry.setExtra(byArray2);
        if (!bl2 && this.useUnicodeExtraFields) {
            ZipUtil.setNameAndCommentFromExtraFields(this.current.entry, byArray, null);
        }
        this.processZip64Extra(zipLong2, zipLong3);
        if (this.current.entry.getCompressedSize() != -1L) {
            if (this.current.entry.getMethod() == ZipMethod.UNSHRINKING.getCode()) {
                this.current.in = new UnshrinkingInputStream(new BoundedInputStream(this.in, this.current.entry.getCompressedSize()));
            } else if (this.current.entry.getMethod() == ZipMethod.IMPLODING.getCode()) {
                this.current.in = new ExplodingInputStream(this.current.entry.getGeneralPurposeBit().getSlidingDictionarySize(), this.current.entry.getGeneralPurposeBit().getNumberOfShannonFanoTrees(), new BoundedInputStream(this.in, this.current.entry.getCompressedSize()));
            } else if (this.current.entry.getMethod() == ZipMethod.BZIP2.getCode()) {
                this.current.in = new BZip2CompressorInputStream(new BoundedInputStream(this.in, this.current.entry.getCompressedSize()));
            }
        }
        ++this.entriesRead;
        return this.current.entry;
    }

    private void readFirstLocalFileHeader(byte[] byArray) throws IOException {
        this.readFully(byArray);
        ZipLong zipLong = new ZipLong(byArray);
        if (zipLong.equals(ZipLong.DD_SIG)) {
            throw new UnsupportedZipFeatureException(UnsupportedZipFeatureException.Feature.SPLITTING);
        }
        if (zipLong.equals(ZipLong.SINGLE_SEGMENT_SPLIT_MARKER)) {
            byte[] byArray2 = new byte[4];
            this.readFully(byArray2);
            System.arraycopy(byArray, 4, byArray, 0, 26);
            System.arraycopy(byArray2, 0, byArray, 26, 4);
        }
    }

    private void processZip64Extra(ZipLong zipLong, ZipLong zipLong2) {
        Zip64ExtendedInformationExtraField zip64ExtendedInformationExtraField = (Zip64ExtendedInformationExtraField)this.current.entry.getExtraField(Zip64ExtendedInformationExtraField.HEADER_ID);
        this.current.usesZip64 = zip64ExtendedInformationExtraField != null;
        if (!this.current.hasDataDescriptor) {
            if (zip64ExtendedInformationExtraField != null && (zipLong2.equals(ZipLong.ZIP64_MAGIC) || zipLong.equals(ZipLong.ZIP64_MAGIC))) {
                this.current.entry.setCompressedSize(zip64ExtendedInformationExtraField.getCompressedSize().getLongValue());
                this.current.entry.setSize(zip64ExtendedInformationExtraField.getSize().getLongValue());
            } else {
                this.current.entry.setCompressedSize(zipLong2.getValue());
                this.current.entry.setSize(zipLong.getValue());
            }
        }
    }

    @Override
    public ArchiveEntry getNextEntry() throws IOException {
        return this.getNextZipEntry();
    }

    @Override
    public boolean canReadEntryData(ArchiveEntry archiveEntry) {
        if (archiveEntry instanceof ZipArchiveEntry) {
            ZipArchiveEntry zipArchiveEntry = (ZipArchiveEntry)archiveEntry;
            return ZipUtil.canHandleEntryData(zipArchiveEntry) && this.supportsDataDescriptorFor(zipArchiveEntry);
        }
        return false;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.closed) {
            throw new IOException("The stream is closed");
        }
        if (this.current == null) {
            return -1;
        }
        if (n > byArray.length || n2 < 0 || n < 0 || byArray.length - n < n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        ZipUtil.checkRequestedFeatures(this.current.entry);
        if (!this.supportsDataDescriptorFor(this.current.entry)) {
            throw new UnsupportedZipFeatureException(UnsupportedZipFeatureException.Feature.DATA_DESCRIPTOR, this.current.entry);
        }
        if (this.current.entry.getMethod() == 0) {
            n3 = this.readStored(byArray, n, n2);
        } else if (this.current.entry.getMethod() == 8) {
            n3 = this.readDeflated(byArray, n, n2);
        } else if (this.current.entry.getMethod() == ZipMethod.UNSHRINKING.getCode() || this.current.entry.getMethod() == ZipMethod.IMPLODING.getCode() || this.current.entry.getMethod() == ZipMethod.BZIP2.getCode()) {
            n3 = this.current.in.read(byArray, n, n2);
        } else {
            throw new UnsupportedZipFeatureException(ZipMethod.getMethodByCode(this.current.entry.getMethod()), this.current.entry);
        }
        if (n3 >= 0) {
            this.current.crc.update(byArray, n, n3);
        }
        return n3;
    }

    private int readStored(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.current.hasDataDescriptor) {
            if (this.lastStoredEntry == null) {
                this.readStoredEntry();
            }
            return this.lastStoredEntry.read(byArray, n, n2);
        }
        long l = this.current.entry.getSize();
        if (this.current.bytesRead >= l) {
            return -1;
        }
        if (this.buf.position() >= this.buf.limit()) {
            this.buf.position(0);
            n3 = this.in.read(this.buf.array());
            if (n3 == -1) {
                return -1;
            }
            this.buf.limit(n3);
            this.count(n3);
            this.current.bytesReadFromStream += n3;
        }
        n3 = Math.min(this.buf.remaining(), n2);
        if (l - this.current.bytesRead < (long)n3) {
            n3 = (int)(l - this.current.bytesRead);
        }
        this.buf.get(byArray, n, n3);
        this.current.bytesRead += n3;
        return n3;
    }

    private int readDeflated(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.readFromInflater(byArray, n, n2);
        if (n3 <= 0) {
            if (this.inf.finished()) {
                return -1;
            }
            if (this.inf.needsDictionary()) {
                throw new ZipException("This archive needs a preset dictionary which is not supported by Commons Compress.");
            }
            if (n3 == -1) {
                throw new IOException("Truncated ZIP file");
            }
        }
        return n3;
    }

    private int readFromInflater(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        do {
            if (this.inf.needsInput()) {
                int n4 = this.fill();
                if (n4 > 0) {
                    this.current.bytesReadFromStream += this.buf.limit();
                } else {
                    if (n4 != -1) break;
                    return -1;
                }
            }
            try {
                n3 = this.inf.inflate(byArray, n, n2);
            }
            catch (DataFormatException dataFormatException) {
                throw (IOException)new ZipException(dataFormatException.getMessage()).initCause(dataFormatException);
            }
        } while (n3 == 0 && this.inf.needsInput());
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            try {
                this.in.close();
            }
            finally {
                this.inf.end();
            }
        }
    }

    @Override
    public long skip(long l) throws IOException {
        if (l >= 0L) {
            long l2;
            int n;
            for (l2 = 0L; l2 < l; l2 += (long)n) {
                long l3 = l - l2;
                n = this.read(this.skipBuf, 0, (int)((long)this.skipBuf.length > l3 ? l3 : (long)this.skipBuf.length));
                if (n != -1) continue;
                return l2;
            }
            return l2;
        }
        throw new IllegalArgumentException();
    }

    public static boolean matches(byte[] byArray, int n) {
        if (n < ZipArchiveOutputStream.LFH_SIG.length) {
            return false;
        }
        return ZipArchiveInputStream.checksig(byArray, ZipArchiveOutputStream.LFH_SIG) || ZipArchiveInputStream.checksig(byArray, ZipArchiveOutputStream.EOCD_SIG) || ZipArchiveInputStream.checksig(byArray, ZipArchiveOutputStream.DD_SIG) || ZipArchiveInputStream.checksig(byArray, ZipLong.SINGLE_SEGMENT_SPLIT_MARKER.getBytes());
    }

    private static boolean checksig(byte[] byArray, byte[] byArray2) {
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    private void closeEntry() throws IOException {
        if (this.closed) {
            throw new IOException("The stream is closed");
        }
        if (this.current == null) {
            return;
        }
        if (this.currentEntryHasOutstandingBytes()) {
            this.drainCurrentEntryData();
        } else {
            this.skip(Long.MAX_VALUE);
            long l = this.current.entry.getMethod() == 8 ? this.getBytesInflated() : this.current.bytesRead;
            int n = (int)(this.current.bytesReadFromStream - l);
            if (n > 0) {
                this.pushback(this.buf.array(), this.buf.limit() - n, n);
                this.current.bytesReadFromStream -= n;
            }
            if (this.currentEntryHasOutstandingBytes()) {
                this.drainCurrentEntryData();
            }
        }
        if (this.lastStoredEntry == null && this.current.hasDataDescriptor) {
            this.readDataDescriptor();
        }
        this.inf.reset();
        this.buf.clear().flip();
        this.current = null;
        this.lastStoredEntry = null;
    }

    private boolean currentEntryHasOutstandingBytes() {
        return this.current.bytesReadFromStream <= this.current.entry.getCompressedSize() && !this.current.hasDataDescriptor;
    }

    private void drainCurrentEntryData() throws IOException {
        long l;
        for (long i = this.current.entry.getCompressedSize() - this.current.bytesReadFromStream; i > 0L; i -= l) {
            l = this.in.read(this.buf.array(), 0, (int)Math.min((long)this.buf.capacity(), i));
            if (l < 0L) {
                throw new EOFException("Truncated ZIP entry: " + ArchiveUtils.sanitize(this.current.entry.getName()));
            }
            this.count(l);
        }
    }

    private long getBytesInflated() {
        long l = this.inf.getBytesRead();
        if (this.current.bytesReadFromStream >= 0x100000000L) {
            while (l + 0x100000000L <= this.current.bytesReadFromStream) {
                l += 0x100000000L;
            }
        }
        return l;
    }

    private int fill() throws IOException {
        if (this.closed) {
            throw new IOException("The stream is closed");
        }
        int n = this.in.read(this.buf.array());
        if (n > 0) {
            this.buf.limit(n);
            this.count(this.buf.limit());
            this.inf.setInput(this.buf.array(), 0, this.buf.limit());
        }
        return n;
    }

    private void readFully(byte[] byArray) throws IOException {
        int n = IOUtils.readFully(this.in, byArray);
        this.count(n);
        if (n < byArray.length) {
            throw new EOFException();
        }
    }

    private void readDataDescriptor() throws IOException {
        this.readFully(this.wordBuf);
        ZipLong zipLong = new ZipLong(this.wordBuf);
        if (ZipLong.DD_SIG.equals(zipLong)) {
            this.readFully(this.wordBuf);
            zipLong = new ZipLong(this.wordBuf);
        }
        this.current.entry.setCrc(zipLong.getValue());
        this.readFully(this.twoDwordBuf);
        ZipLong zipLong2 = new ZipLong(this.twoDwordBuf, 8);
        if (zipLong2.equals(ZipLong.CFH_SIG) || zipLong2.equals(ZipLong.LFH_SIG)) {
            this.pushback(this.twoDwordBuf, 8, 8);
            this.current.entry.setCompressedSize(ZipLong.getValue(this.twoDwordBuf));
            this.current.entry.setSize(ZipLong.getValue(this.twoDwordBuf, 4));
        } else {
            this.current.entry.setCompressedSize(ZipEightByteInteger.getLongValue(this.twoDwordBuf));
            this.current.entry.setSize(ZipEightByteInteger.getLongValue(this.twoDwordBuf, 8));
        }
    }

    private boolean supportsDataDescriptorFor(ZipArchiveEntry zipArchiveEntry) {
        return !zipArchiveEntry.getGeneralPurposeBit().usesDataDescriptor() || this.allowStoredEntriesWithDataDescriptor && zipArchiveEntry.getMethod() == 0 || zipArchiveEntry.getMethod() == 8;
    }

    private void readStoredEntry() throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        boolean bl = false;
        int n3 = n = this.current.usesZip64 ? 20 : 12;
        while (!bl) {
            int n4 = this.in.read(this.buf.array(), n2, 512 - n2);
            if (n4 <= 0) {
                throw new IOException("Truncated ZIP file");
            }
            if (n4 + n2 < 4) {
                n2 += n4;
                continue;
            }
            bl = this.bufferContainsSignature(byteArrayOutputStream, n2, n4, n);
            if (bl) continue;
            n2 = this.cacheBytesRead(byteArrayOutputStream, n2, n4, n);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.lastStoredEntry = new ByteArrayInputStream(byArray);
    }

    private boolean bufferContainsSignature(ByteArrayOutputStream byteArrayOutputStream, int n, int n2, int n3) throws IOException {
        boolean bl = false;
        int n4 = 0;
        for (int i = 0; !bl && i < n2 - 4; ++i) {
            if (this.buf.array()[i] != LFH[0] || this.buf.array()[i + 1] != LFH[1]) continue;
            if (this.buf.array()[i + 2] == LFH[2] && this.buf.array()[i + 3] == LFH[3] || this.buf.array()[i] == CFH[2] && this.buf.array()[i + 3] == CFH[3]) {
                n4 = n + n2 - i - n3;
                bl = true;
            } else if (this.buf.array()[i + 2] == DD[2] && this.buf.array()[i + 3] == DD[3]) {
                n4 = n + n2 - i;
                bl = true;
            }
            if (!bl) continue;
            this.pushback(this.buf.array(), n + n2 - n4, n4);
            byteArrayOutputStream.write(this.buf.array(), 0, i);
            this.readDataDescriptor();
        }
        return bl;
    }

    private int cacheBytesRead(ByteArrayOutputStream byteArrayOutputStream, int n, int n2, int n3) {
        int n4 = n + n2 - n3 - 3;
        if (n4 > 0) {
            byteArrayOutputStream.write(this.buf.array(), 0, n4);
            System.arraycopy(this.buf.array(), n4, this.buf.array(), 0, n3 + 3);
            n = n3 + 3;
        } else {
            n += n2;
        }
        return n;
    }

    private void pushback(byte[] byArray, int n, int n2) throws IOException {
        ((PushbackInputStream)this.in).unread(byArray, n, n2);
        this.pushedBackBytes(n2);
    }

    private void skipRemainderOfArchive() throws IOException {
        this.realSkip((long)this.entriesRead * 46L - 30L);
        this.findEocdRecord();
        this.realSkip(16L);
        this.readFully(this.shortBuf);
        this.realSkip(ZipShort.getValue(this.shortBuf));
    }

    private void findEocdRecord() throws IOException {
        int n = -1;
        boolean bl = false;
        while (bl || (n = this.readOneByte()) > -1) {
            bl = false;
            if (!this.isFirstByteOfEocdSig(n)) continue;
            n = this.readOneByte();
            if (n != ZipArchiveOutputStream.EOCD_SIG[1]) {
                if (n == -1) break;
                bl = this.isFirstByteOfEocdSig(n);
                continue;
            }
            n = this.readOneByte();
            if (n != ZipArchiveOutputStream.EOCD_SIG[2]) {
                if (n == -1) break;
                bl = this.isFirstByteOfEocdSig(n);
                continue;
            }
            n = this.readOneByte();
            if (n == -1 || n == ZipArchiveOutputStream.EOCD_SIG[3]) break;
            bl = this.isFirstByteOfEocdSig(n);
        }
    }

    private void realSkip(long l) throws IOException {
        if (l >= 0L) {
            int n;
            for (long i = 0L; i < l; i += (long)n) {
                long l2 = l - i;
                n = this.in.read(this.skipBuf, 0, (int)((long)this.skipBuf.length > l2 ? l2 : (long)this.skipBuf.length));
                if (n == -1) {
                    return;
                }
                this.count(n);
            }
            return;
        }
        throw new IllegalArgumentException();
    }

    private int readOneByte() throws IOException {
        int n = this.in.read();
        if (n != -1) {
            this.count(1);
        }
        return n;
    }

    private boolean isFirstByteOfEocdSig(int n) {
        return n == ZipArchiveOutputStream.EOCD_SIG[0];
    }

    private class BoundedInputStream
    extends InputStream {
        private final InputStream in;
        private final long max;
        private long pos = 0L;

        public BoundedInputStream(InputStream inputStream, long l) {
            this.max = l;
            this.in = inputStream;
        }

        @Override
        public int read() throws IOException {
            if (this.max >= 0L && this.pos >= this.max) {
                return -1;
            }
            int n = this.in.read();
            ++this.pos;
            ZipArchiveInputStream.this.count(1);
            ZipArchiveInputStream.this.current.bytesReadFromStream++;
            return n;
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.max >= 0L && this.pos >= this.max) {
                return -1;
            }
            long l = this.max >= 0L ? Math.min((long)n2, this.max - this.pos) : (long)n2;
            int n3 = this.in.read(byArray, n, (int)l);
            if (n3 == -1) {
                return -1;
            }
            this.pos += (long)n3;
            ZipArchiveInputStream.this.count(n3);
            ZipArchiveInputStream.this.current.bytesReadFromStream += n3;
            return n3;
        }

        @Override
        public long skip(long l) throws IOException {
            long l2 = this.max >= 0L ? Math.min(l, this.max - this.pos) : l;
            long l3 = this.in.skip(l2);
            this.pos += l3;
            return l3;
        }

        @Override
        public int available() throws IOException {
            if (this.max >= 0L && this.pos >= this.max) {
                return 0;
            }
            return this.in.available();
        }
    }

    private static final class CurrentEntry {
        private final ZipArchiveEntry entry = new ZipArchiveEntry();
        private boolean hasDataDescriptor;
        private boolean usesZip64;
        private long bytesRead;
        private long bytesReadFromStream;
        private final CRC32 crc = new CRC32();
        private InputStream in;

        private CurrentEntry() {
        }
    }
}

