/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.service;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceSelector;

public class DefaultServiceSelector
implements ServiceSelector {
    private final HashMap m_objects = new HashMap();
    private boolean m_readOnly;
    private final String m_role;

    public DefaultServiceSelector() {
        this("");
    }

    public DefaultServiceSelector(String string) {
        if (null == string) {
            throw new NullPointerException(string);
        }
        this.m_role = string;
    }

    public Object select(Object object) throws ServiceException {
        Object v = this.m_objects.get(object);
        if (null != v) {
            return v;
        }
        throw new ServiceException(this.m_role + "/" + object.toString(), "Unable to provide implementation");
    }

    public boolean isSelectable(Object object) {
        boolean bl = false;
        try {
            this.release(this.select(object));
            bl = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    public void release(Object object) {
    }

    public void put(Object object, Object object2) {
        this.checkWriteable();
        this.m_objects.put(object, object2);
    }

    protected final Map getObjectMap() {
        return this.m_objects;
    }

    public void makeReadOnly() {
        this.m_readOnly = true;
    }

    protected final void checkWriteable() throws IllegalStateException {
        if (this.m_readOnly) {
            throw new IllegalStateException("ServiceSelector is read only and can not be modified");
        }
    }
}

