/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import org.apache.avalon.framework.CascadingThrowable;

public final class ExceptionUtil {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String GET_CAUSE_NAME = "getCause";
    private static final Class[] GET_CAUSE_PARAMTYPES = new Class[0];

    private ExceptionUtil() {
    }

    public static String printStackTrace(Throwable throwable) {
        return ExceptionUtil.printStackTrace(throwable, 0, true);
    }

    public static String printStackTrace(Throwable throwable, boolean bl) {
        return ExceptionUtil.printStackTrace(throwable, 0, bl);
    }

    public static String printStackTrace(Throwable throwable, int n) {
        int n2 = n;
        String[] stringArray = ExceptionUtil.captureStackTrace(throwable);
        if (0 == n2 || n2 > stringArray.length) {
            n2 = stringArray.length;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(LINE_SEPARATOR);
        }
        return stringBuffer.toString();
    }

    public static String printStackTrace(Throwable throwable, int n, boolean bl) {
        return ExceptionUtil.printStackTrace(throwable, n, bl, true);
    }

    public static String printStackTrace(Throwable throwable, int n, boolean bl, boolean bl2) {
        String string = ExceptionUtil.printStackTrace(throwable, n);
        if (!bl) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        Throwable throwable2 = ExceptionUtil.getCause(throwable, bl2);
        while (null != throwable2) {
            stringBuffer.append("rethrown from");
            stringBuffer.append(LINE_SEPARATOR);
            stringBuffer.append(ExceptionUtil.printStackTrace(throwable2, n));
            throwable2 = ExceptionUtil.getCause(throwable2, bl2);
        }
        return stringBuffer.toString();
    }

    public static Throwable getCause(Throwable throwable, boolean bl) {
        if (throwable instanceof CascadingThrowable) {
            CascadingThrowable cascadingThrowable = (CascadingThrowable)throwable;
            return cascadingThrowable.getCause();
        }
        if (bl) {
            try {
                Class<?> clazz = throwable.getClass();
                Method method = clazz.getMethod(GET_CAUSE_NAME, GET_CAUSE_PARAMTYPES);
                return (Throwable)method.invoke((Object)throwable, null);
            }
            catch (Throwable throwable2) {
                return null;
            }
        }
        return null;
    }

    public static String[] captureStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)stringWriter, true));
        return ExceptionUtil.splitStringInternal(stringWriter.toString(), LINE_SEPARATOR);
    }

    public static String[] splitString(String string, String string2) {
        return ExceptionUtil.splitStringInternal(string, string2);
    }

    private static String[] splitStringInternal(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }
}

