SCM_GLOBAL_SMOB (scm_tc16_avahi_domain_browser_type_enum, "domain-browser-type", 0);
SCM scm_avahi_domain_browser_type_enum_values = SCM_EOL;
static const char *
scm_avahi_domain_browser_type_to_c_string (AvahiDomainBrowserType c_obj)
{
  static const struct { AvahiDomainBrowserType value; const char *name; } table[] =
    {
       { AVAHI_DOMAIN_BROWSER_BROWSE, "browse" },
       { AVAHI_DOMAIN_BROWSER_BROWSE_DEFAULT, "browse-default" },
       { AVAHI_DOMAIN_BROWSER_REGISTER, "register" },
       { AVAHI_DOMAIN_BROWSER_REGISTER_DEFAULT, "register-default" },
       { AVAHI_DOMAIN_BROWSER_BROWSE_LEGACY, "browse-legacy" },
    };
  unsigned i;
  const char *name = NULL;
  for (i = 0; i < 5; i++)
    {
      if (table[i].value == c_obj)
        {
          name = table[i].name;
          break;
        }
    }
  return (name);
}
SCM_SMOB_PRINT (scm_tc16_avahi_domain_browser_type_enum, domain_browser_type_print, obj, port, pstate)
{
  scm_puts ("#<avahi-domain-browser-type-enum ", port);
  scm_puts (scm_avahi_domain_browser_type_to_c_string (scm_to_avahi_domain_browser_type (obj, 1, "domain_browser_type_print")), port);
  scm_puts (">", port);
  return 1;
}
SCM_DEFINE (scm_avahi_domain_browser_type_to_string, "domain-browser-type->string", 1, 0, 0,
            (SCM enumval),
            "Return a string describing @var{enumval}, a @code{domain-browser-type} value.")
#define FUNC_NAME s_scm_avahi_domain_browser_type_to_string
{
  AvahiDomainBrowserType c_enum;
  const char *c_string;
  c_enum = scm_to_avahi_domain_browser_type (enumval, 1, FUNC_NAME);
  c_string = scm_avahi_domain_browser_type_to_c_string (c_enum);
  return (scm_from_locale_string (c_string));
}
#undef FUNC_NAME
SCM_GLOBAL_SMOB (scm_tc16_avahi_browser_event_enum, "browser-event", 0);
SCM scm_avahi_browser_event_enum_values = SCM_EOL;
static const char *
scm_avahi_browser_event_to_c_string (AvahiBrowserEvent c_obj)
{
  static const struct { AvahiBrowserEvent value; const char *name; } table[] =
    {
       { AVAHI_BROWSER_NEW, "new" },
       { AVAHI_BROWSER_REMOVE, "remove" },
       { AVAHI_BROWSER_CACHE_EXHAUSTED, "cache-exhausted" },
       { AVAHI_BROWSER_ALL_FOR_NOW, "all-for-now" },
       { AVAHI_BROWSER_FAILURE, "failure" },
    };
  unsigned i;
  const char *name = NULL;
  for (i = 0; i < 5; i++)
    {
      if (table[i].value == c_obj)
        {
          name = table[i].name;
          break;
        }
    }
  return (name);
}
SCM_SMOB_PRINT (scm_tc16_avahi_browser_event_enum, browser_event_print, obj, port, pstate)
{
  scm_puts ("#<avahi-browser-event-enum ", port);
  scm_puts (scm_avahi_browser_event_to_c_string (scm_to_avahi_browser_event (obj, 1, "browser_event_print")), port);
  scm_puts (">", port);
  return 1;
}
SCM_DEFINE (scm_avahi_browser_event_to_string, "browser-event->string", 1, 0, 0,
            (SCM enumval),
            "Return a string describing @var{enumval}, a @code{browser-event} value.")
#define FUNC_NAME s_scm_avahi_browser_event_to_string
{
  AvahiBrowserEvent c_enum;
  const char *c_string;
  c_enum = scm_to_avahi_browser_event (enumval, 1, FUNC_NAME);
  c_string = scm_avahi_browser_event_to_c_string (c_enum);
  return (scm_from_locale_string (c_string));
}
#undef FUNC_NAME
SCM_GLOBAL_SMOB (scm_tc16_avahi_resolver_event_enum, "resolver-event", 0);
SCM scm_avahi_resolver_event_enum_values = SCM_EOL;
static const char *
scm_avahi_resolver_event_to_c_string (AvahiResolverEvent c_obj)
{
  static const struct { AvahiResolverEvent value; const char *name; } table[] =
    {
       { AVAHI_RESOLVER_FOUND, "found" },
       { AVAHI_RESOLVER_FAILURE, "failure" },
    };
  unsigned i;
  const char *name = NULL;
  for (i = 0; i < 2; i++)
    {
      if (table[i].value == c_obj)
        {
          name = table[i].name;
          break;
        }
    }
  return (name);
}
SCM_SMOB_PRINT (scm_tc16_avahi_resolver_event_enum, resolver_event_print, obj, port, pstate)
{
  scm_puts ("#<avahi-resolver-event-enum ", port);
  scm_puts (scm_avahi_resolver_event_to_c_string (scm_to_avahi_resolver_event (obj, 1, "resolver_event_print")), port);
  scm_puts (">", port);
  return 1;
}
SCM_DEFINE (scm_avahi_resolver_event_to_string, "resolver-event->string", 1, 0, 0,
            (SCM enumval),
            "Return a string describing @var{enumval}, a @code{resolver-event} value.")
#define FUNC_NAME s_scm_avahi_resolver_event_to_string
{
  AvahiResolverEvent c_enum;
  const char *c_string;
  c_enum = scm_to_avahi_resolver_event (enumval, 1, FUNC_NAME);
  c_string = scm_avahi_resolver_event_to_c_string (c_enum);
  return (scm_from_locale_string (c_string));
}
#undef FUNC_NAME
SCM_GLOBAL_SMOB (scm_tc16_avahi_lookup_flag_enum, "lookup-flag", 0);
SCM scm_avahi_lookup_flag_enum_values = SCM_EOL;
static const char *
scm_avahi_lookup_flag_to_c_string (AvahiLookupFlags c_obj)
{
  static const struct { AvahiLookupFlags value; const char *name; } table[] =
    {
       { AVAHI_LOOKUP_USE_WIDE_AREA, "use-wide-area" },
       { AVAHI_LOOKUP_USE_MULTICAST, "use-multicast" },
       { AVAHI_LOOKUP_NO_TXT, "no-txt" },
       { AVAHI_LOOKUP_NO_ADDRESS, "no-address" },
    };
  unsigned i;
  const char *name = NULL;
  for (i = 0; i < 4; i++)
    {
      if (table[i].value == c_obj)
        {
          name = table[i].name;
          break;
        }
    }
  return (name);
}
SCM_SMOB_PRINT (scm_tc16_avahi_lookup_flag_enum, lookup_flag_print, obj, port, pstate)
{
  scm_puts ("#<avahi-lookup-flag-enum ", port);
  scm_puts (scm_avahi_lookup_flag_to_c_string (scm_to_avahi_lookup_flag (obj, 1, "lookup_flag_print")), port);
  scm_puts (">", port);
  return 1;
}
SCM_DEFINE (scm_avahi_lookup_flag_to_string, "lookup-flag->string", 1, 0, 0,
            (SCM enumval),
            "Return a string describing @var{enumval}, a @code{lookup-flag} value.")
#define FUNC_NAME s_scm_avahi_lookup_flag_to_string
{
  AvahiLookupFlags c_enum;
  const char *c_string;
  c_enum = scm_to_avahi_lookup_flag (enumval, 1, FUNC_NAME);
  c_string = scm_avahi_lookup_flag_to_c_string (c_enum);
  return (scm_from_locale_string (c_string));
}
#undef FUNC_NAME
SCM_GLOBAL_SMOB (scm_tc16_avahi_lookup_result_flag_enum, "lookup-result-flag", 0);
SCM scm_avahi_lookup_result_flag_enum_values = SCM_EOL;
static const char *
scm_avahi_lookup_result_flag_to_c_string (AvahiLookupResultFlags c_obj)
{
  static const struct { AvahiLookupResultFlags value; const char *name; } table[] =
    {
       { AVAHI_LOOKUP_RESULT_CACHED, "cached" },
       { AVAHI_LOOKUP_RESULT_WIDE_AREA, "wide-area" },
       { AVAHI_LOOKUP_RESULT_MULTICAST, "multicast" },
       { AVAHI_LOOKUP_RESULT_LOCAL, "local" },
       { AVAHI_LOOKUP_RESULT_OUR_OWN, "our-own" },
       { AVAHI_LOOKUP_RESULT_STATIC, "static" },
    };
  unsigned i;
  const char *name = NULL;
  for (i = 0; i < 6; i++)
    {
      if (table[i].value == c_obj)
        {
          name = table[i].name;
          break;
        }
    }
  return (name);
}
SCM_SMOB_PRINT (scm_tc16_avahi_lookup_result_flag_enum, lookup_result_flag_print, obj, port, pstate)
{
  scm_puts ("#<avahi-lookup-result-flag-enum ", port);
  scm_puts (scm_avahi_lookup_result_flag_to_c_string (scm_to_avahi_lookup_result_flag (obj, 1, "lookup_result_flag_print")), port);
  scm_puts (">", port);
  return 1;
}
SCM_DEFINE (scm_avahi_lookup_result_flag_to_string, "lookup-result-flag->string", 1, 0, 0,
            (SCM enumval),
            "Return a string describing @var{enumval}, a @code{lookup-result-flag} value.")
#define FUNC_NAME s_scm_avahi_lookup_result_flag_to_string
{
  AvahiLookupResultFlags c_enum;
  const char *c_string;
  c_enum = scm_to_avahi_lookup_result_flag (enumval, 1, FUNC_NAME);
  c_string = scm_avahi_lookup_result_flag_to_c_string (c_enum);
  return (scm_from_locale_string (c_string));
}
#undef FUNC_NAME
static inline void
scm_avahi_define_enums (void)
{
  SCM enum_values, enum_smob;
  enum_values = SCM_EOL;
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_domain_browser_type_enum, (scm_t_bits) AVAHI_DOMAIN_BROWSER_BROWSE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("domain-browser-type/browse", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_domain_browser_type_enum, (scm_t_bits) AVAHI_DOMAIN_BROWSER_BROWSE_DEFAULT);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("domain-browser-type/browse-default", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_domain_browser_type_enum, (scm_t_bits) AVAHI_DOMAIN_BROWSER_REGISTER);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("domain-browser-type/register", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_domain_browser_type_enum, (scm_t_bits) AVAHI_DOMAIN_BROWSER_REGISTER_DEFAULT);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("domain-browser-type/register-default", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_domain_browser_type_enum, (scm_t_bits) AVAHI_DOMAIN_BROWSER_BROWSE_LEGACY);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("domain-browser-type/browse-legacy", enum_smob);
  scm_avahi_domain_browser_type_enum_values = scm_permanent_object (enum_values);
  enum_values = SCM_EOL;
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_browser_event_enum, (scm_t_bits) AVAHI_BROWSER_NEW);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("browser-event/new", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_browser_event_enum, (scm_t_bits) AVAHI_BROWSER_REMOVE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("browser-event/remove", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_browser_event_enum, (scm_t_bits) AVAHI_BROWSER_CACHE_EXHAUSTED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("browser-event/cache-exhausted", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_browser_event_enum, (scm_t_bits) AVAHI_BROWSER_ALL_FOR_NOW);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("browser-event/all-for-now", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_browser_event_enum, (scm_t_bits) AVAHI_BROWSER_FAILURE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("browser-event/failure", enum_smob);
  scm_avahi_browser_event_enum_values = scm_permanent_object (enum_values);
  enum_values = SCM_EOL;
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_resolver_event_enum, (scm_t_bits) AVAHI_RESOLVER_FOUND);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("resolver-event/found", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_resolver_event_enum, (scm_t_bits) AVAHI_RESOLVER_FAILURE);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("resolver-event/failure", enum_smob);
  scm_avahi_resolver_event_enum_values = scm_permanent_object (enum_values);
  enum_values = SCM_EOL;
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_lookup_flag_enum, (scm_t_bits) AVAHI_LOOKUP_USE_WIDE_AREA);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("lookup-flag/use-wide-area", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_lookup_flag_enum, (scm_t_bits) AVAHI_LOOKUP_USE_MULTICAST);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("lookup-flag/use-multicast", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_lookup_flag_enum, (scm_t_bits) AVAHI_LOOKUP_NO_TXT);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("lookup-flag/no-txt", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_lookup_flag_enum, (scm_t_bits) AVAHI_LOOKUP_NO_ADDRESS);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("lookup-flag/no-address", enum_smob);
  scm_avahi_lookup_flag_enum_values = scm_permanent_object (enum_values);
  enum_values = SCM_EOL;
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_lookup_result_flag_enum, (scm_t_bits) AVAHI_LOOKUP_RESULT_CACHED);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("lookup-result-flag/cached", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_lookup_result_flag_enum, (scm_t_bits) AVAHI_LOOKUP_RESULT_WIDE_AREA);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("lookup-result-flag/wide-area", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_lookup_result_flag_enum, (scm_t_bits) AVAHI_LOOKUP_RESULT_MULTICAST);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("lookup-result-flag/multicast", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_lookup_result_flag_enum, (scm_t_bits) AVAHI_LOOKUP_RESULT_LOCAL);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("lookup-result-flag/local", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_lookup_result_flag_enum, (scm_t_bits) AVAHI_LOOKUP_RESULT_OUR_OWN);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("lookup-result-flag/our-own", enum_smob);
  SCM_NEWSMOB (enum_smob, scm_tc16_avahi_lookup_result_flag_enum, (scm_t_bits) AVAHI_LOOKUP_RESULT_STATIC);
  enum_values = scm_cons (enum_smob, enum_values);
  scm_c_define ("lookup-result-flag/static", enum_smob);
  scm_avahi_lookup_result_flag_enum_values = scm_permanent_object (enum_values);
}
