#############################################################################
#
# MODULE:   	Grass Compilation
# AUTHOR(S):	Original author unknown - probably CERL
#		Markus Neteler - Germany/Italy - neteler@itc.it
#   	    	Justin Hickey - Thailand - jhickey@hpcc.nectec.or.th
#   	    	Huidae Cho - Korea - grass4u@gmail.com
#   	    	Eric G. Miller - egm2@jps.net
# PURPOSE:  	The source file for this Makefile is in src/CMD/head/head.in.
#		It is the top part of a file called make.rules which is used
#		for compiling all GRASS modules. This part of the file provides
#		make variables that are dependent on the results of the
#		configure script.
# COPYRIGHT:    (C) 2000 by the GRASS Development Team
#
#               This program is free software under the GNU General Public
#   	    	License (>=v2). Read the file COPYING that comes with GRASS
#   	    	for details.
#
#############################################################################

############################## Make Variables ###############################

CC                  = gcc
CXX                 = c++
LEX                 = flex
YACC                = bison -y
PERL                = /usr/bin/perl
AR                  = ar
RANLIB              = ranlib
MKDIR               = mkdir -p
CHMOD               = chmod
INSTALL             = /usr/bin/install -c 
INSTALL_DATA        = ${INSTALL} -m 644

prefix              = /opt/grass
exec_prefix         = ${prefix}
ARCH                = i686-pc-linux-gnu
UNIX_BIN            = ${exec_prefix}/bin
INST_DIR            = ${prefix}

GRASS_HOME          = /opt/grass
RUN_GISBASE         = /opt/grass

GRASS_VERSION_MAJOR = 7
GRASS_VERSION_MINOR = 2
GRASS_VERSION_RELEASE = 0
GRASS_VERSION_DATE  = 2016
GRASS_VERSION_SVN   = exported

STRIPFLAG           = 
LD_SEARCH_FLAGS     = -Wl,-rpath-link,${LIB_RUNTIME_DIR}
LD_LIBRARY_PATH_VAR = LD_LIBRARY_PATH

#generate static (ST) or shared (SH)
GRASS_LIBRARY_TYPE  = shlib

#static libs:
STLIB_LD            = ${AR} cr
STLIB_PREFIX        = lib
STLIB_SUFFIX        = .a

#shared libs
SHLIB_PREFIX        = lib
SHLIB_LD            = gcc -shared
SHLIB_LDFLAGS       = -Wl,-soname,$(notdir $@)
SHLIB_CFLAGS        = -fPIC
SHLIB_SUFFIX        = .so
EXE                 = 

DEFAULT_DATABASE    =
DEFAULT_LOCATION    =

CPPFLAGS            = -D_FORTIFY_SOURCE=2
CFLAGS              = -march=i686 -mtune=generic -O2 -pipe -fstack-protector-strong 
CXXFLAGS            = -std=c++98 -march=i686 -mtune=generic -O2 -pipe -fstack-protector-strong
INCLUDE_DIRS        = 
LINK_FLAGS          =  -Wl,-O1,--sort-common,--as-needed,-z,relro -Wl,--export-dynamic

DLLIB               = -ldl
XCFLAGS             = 
XLIBPATH            = 
XLIB                =  -lSM -lICE -lX11
XEXTRALIBS          = 
USE_X11             = 1

MATHLIB             = -lm 
ICONVLIB            = 
INTLLIB             = 
SOCKLIB             = 

#ZLIB:
ZLIB                =  -lz 
ZLIBINCPATH         = 
ZLIBLIBPATH         = 

#BZIP2:
BZLIB                = 
BZLIBINCPATH         = 
BZLIBLIBPATH         = 

DBMIEXTRALIB        = 

#readline
READLINEINCPATH     = 
READLINELIBPATH     = 
READLINELIB         =  -lreadline 
HISTORYLIB          =  -lhistory 

#PostgreSQL:
PQINCPATH           = 
PQLIBPATH           = 
PQLIB               =  -lpq 
USE_POSTGRES        = 1

#MySQL:
MYSQLINCPATH        = 
MYSQLLIBPATH        = 
MYSQLLIB            = 
MYSQLDLIB           = 

#SQLite:
SQLITEINCPATH       = 
SQLITELIBPATH       = 
SQLITELIB           =  -lsqlite3 

#ODBC:
ODBCINC             = 
ODBCLIB             = 

#Image formats:
PNGINC              = 
PNGLIB              =  -lpng  -lz  -lm
USE_PNG             = 1

TIFFINCPATH         = 
TIFFLIBPATH         = 
TIFFLIB             =  -ltiff 

#openGL files for NVIZ/r3.showdspf
OPENGLINC           = 
OPENGLLIB           =   -lGL 
OPENGLULIB          =   -lGLU 
OPENGL_X11          = 1
OPENGL_AQUA         = 
OPENGL_WINDOWS      = 
USE_OPENGL          = 1

#FFTW:
FFTWINC             = 
FFTWLIB             =  -lfftw3 -lm

#LAPACK/BLAS stuff for gmath lib:
BLASLIB             = 
BLASINC             = 
LAPACKLIB           = 
LAPACKINC           = 

#GDAL/OGR
GDALLIBS            = -L/usr/lib -lgdal
GDALCFLAGS          = -I/usr/include
USE_GDAL            = 1
USE_OGR             = 1

#NetCDF
NETCDFLIBS          = -lnetcdf
NETCDFCFLAGS        = -I/usr/include -D_FORTIFY_SOURCE=2    
USE_NETCDF          = 1

#LAS LiDAR through libLAS
LASLIBS             = 
LASCFLAGS           = 
LASINC              = 
USE_LIBLAS          = 

#LAS LiDAR through PDAL
PDALLIBS             = 
PDALCPPFLAGS         = 
PDALINC              = 
USE_PDAL             = 

#GEOS
GEOSLIBS            = -L/usr/lib -lgeos -lgeos_c 
GEOSCFLAGS          = -I/usr/include
USE_GEOS            = 1

#FreeType:
FTINC               =  -I/usr/include/freetype2
FTLIB               =  -lfreetype 

#PROJ.4:
PROJINC             =  $(GDALCFLAGS)
PROJLIB             =  -lproj 
NAD2BIN             = /usr/bin/nad2bin
PROJSHARE           = /usr/share/proj

#OPENDWG:
OPENDWGINCPATH      = 
OPENDWGLIBPATH      = 
OPENDWGLIB          = 
USE_OPENDWG         = 

#cairo
CAIROINC                  = -I/usr/include/cairo -I/usr/include/pixman-1 -I/usr/include/freetype2 -I/usr/include/libpng16 -I/usr/include/harfbuzz -I/usr/include/glib-2.0 -I/usr/lib/glib-2.0/include -I/usr/include/freetype2 -I/usr/include/harfbuzz -I/usr/include/glib-2.0 -I/usr/lib/glib-2.0/include -I/usr/include/libdrm -I/usr/include/libpng16
CAIROLIB                  = -lz -lfontconfig -lfreetype -lcairo -lXext -lXrender -lX11  
USE_CAIRO                 = 1
CAIRO_HAS_XRENDER         = 1
CAIRO_HAS_XRENDER_SURFACE = 1

#Python
PYTHON              = python2

#regex
REGEXINCPATH        = 
REGEXLIBPATH        = 
REGEXLIB            =  
USE_REGEX           = 1

#pthreads
PTHREADINCPATH      = 
PTHREADLIBPATH      = 
PTHREADLIB          =  -lpthread 
USE_PTHREAD         = 1

#OpenMP
OMPINCPATH          = 
OMPLIBPATH          = 
OMPLIB              = 
OMPCFLAGS           = 
USE_OPENMP          = 

#OpenCL
OCLINCPATH          = 
OCLLIBPATH          = 
OCLLIB              = 
USE_OPENCL          = 

#i18N
HAVE_NLS            = 1

#Large File Support (LFS)
USE_LARGEFILES      = 1
LFS_CFLAGS          = -D_LARGEFILE_SOURCE -D_FILE_OFFSET_BITS=64

#BSD sockets
HAVE_SOCKET         = 1

MINGW		    = 
MACOSX_APP	    = 
MACOSX_ARCHS        = 
MACOSX_SDK          = 

# Cross compilation
CROSS_COMPILING     =  
