/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.random;

import java.util.Random;

public class FourTapRandom
extends Random {
    private static final int TAP4A = 471;
    private static final int TAP4B = 1586;
    private static final int TAP4C = 6988;
    private static final int TAP4D = 9689;
    private static final int TAP4M = 16383;
    private int[] fourTapBuffer;
    private int n4TapJ;
    private static final long serialVersionUID = -4095251494398895580L;

    public FourTapRandom() {
        this.setSeed(System.currentTimeMillis());
    }

    public FourTapRandom(long seed) {
        this.setSeed(seed);
    }

    @Override
    public void setSeed(long seed) {
        super.setSeed(seed);
        this.fourTapBuffer = new int[16384];
        for (int j = 0; j <= 16383; ++j) {
            this.fourTapBuffer[j] = super.next(32);
        }
        this.n4TapJ = 0;
    }

    @Override
    protected int next(int bits) {
        ++this.n4TapJ;
        this.fourTapBuffer[this.n4TapJ & 0x3FFF] = this.fourTapBuffer[this.n4TapJ - 471 & 0x3FFF] ^ this.fourTapBuffer[this.n4TapJ - 1586 & 0x3FFF] ^ this.fourTapBuffer[this.n4TapJ - 6988 & 0x3FFF] ^ this.fourTapBuffer[this.n4TapJ - 9689 & 0x3FFF];
        return this.fourTapBuffer[this.n4TapJ & 0x3FFF] >>> 32 - bits;
    }
}

