/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.functions.vectorial;

import java.io.Serializable;
import org.spaceroots.mantissa.functions.ExhaustedSampleException;
import org.spaceroots.mantissa.functions.FunctionException;
import org.spaceroots.mantissa.functions.vectorial.SampledFunction;
import org.spaceroots.mantissa.functions.vectorial.SampledFunctionIterator;
import org.spaceroots.mantissa.functions.vectorial.VectorialValuedPair;

public class BasicSampledFunctionIterator
implements SampledFunctionIterator,
Serializable {
    private final SampledFunction function;
    private int next;
    private static final long serialVersionUID = -4386278658288500627L;

    public BasicSampledFunctionIterator(SampledFunction function) {
        this.function = function;
        this.next = 0;
    }

    @Override
    public int getDimension() {
        return this.function.getDimension();
    }

    @Override
    public boolean hasNext() {
        return this.next < this.function.size();
    }

    @Override
    public VectorialValuedPair nextSamplePoint() throws ExhaustedSampleException, FunctionException {
        if (this.next >= this.function.size()) {
            throw new ExhaustedSampleException(this.function.size());
        }
        int current = this.next++;
        return this.function.samplePointAt(current);
    }
}

