/*
 * Decompiled with CFR 0.152.
 */
package org.bitpedia.collider.core;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.bitpedia.collider.core.FormatHandler;
import org.bitpedia.collider.core.Submission;

public class Bitcollider {
    public static final String BC_AGENTNAME = "jBitprinter";
    public static final String BC_AGENTBUILD = "03/16/2006 18:15";
    public static final String BC_SUBMITSPECVER = "0.4";
    public static final String BC_VERSION = "0.6.0";
    public static final String ERROR_FILENOTFOUND = "File not found or permission denied.";
    public static final String ERROR_MALLOCFAILED = "Failed to allocate memory.";
    public static final String ERROR_LAUNCHBROWSER = "Cannot launch web browser.";
    public static final String ERROR_TEMPFILEERR = "Cannot create a temorary file for the bitprint submission.";
    public static final String ERROR_HASHCHECK = "The hash functions compiled into this version of the bitcollider utility are faulty!!!";
    public static final String WARNING_NOTMP3 = "This is not an MP3 file. Skipping mp3 information.";
    private Collection fmtHandlers;
    private boolean calcMd5 = false;
    private boolean calcCrc32 = false;
    private Progress progress;
    private String error;
    private String warning;
    private boolean preview;
    private boolean exitNow;

    public static final String getAgentString() {
        return "jBitprinter/0.6.0 (03/16/2006 18:15)";
    }

    public String getError() {
        return this.error;
    }

    public void setError(String string) {
        this.error = string;
    }

    public boolean isExitNow() {
        return this.exitNow;
    }

    public void setExitNow(boolean bl) {
        this.exitNow = bl;
    }

    public boolean isPreview() {
        return this.preview;
    }

    public void setPreview(boolean bl) {
        this.preview = bl;
    }

    public String getWarning() {
        return this.warning;
    }

    public void setWarning(String string) {
        this.warning = string;
    }

    public Bitcollider(Collection collection) {
        this.fmtHandlers = collection;
    }

    public FormatHandler getFormatHandler(String string) {
        for (FormatHandler formatHandler : this.fmtHandlers) {
            if (!formatHandler.supportsExtension(string)) continue;
            return formatHandler;
        }
        return null;
    }

    public Submission generateSubmission(List list, String string, boolean bl) {
        Submission submission = new Submission(this, string, bl);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().toString();
            File file = new File(string2);
            if (!file.exists()) {
                System.err.println("Cannot find file/dir " + string2 + ". Skipping.");
                continue;
            }
            if (file.isFile()) {
                boolean bl2 = submission.analyzeFile(string2, false);
                if (bl2) continue;
                continue;
            }
            if (file.isDirectory()) {
                submission.recurseDir(string2, false, false);
                continue;
            }
            System.err.println(string2 + " is not a regular file. Skipping.");
        }
        return submission;
    }

    public boolean isCalcCrc32() {
        return this.calcCrc32;
    }

    public void setCalcCrc32(boolean bl) {
        this.calcCrc32 = bl;
    }

    public boolean isCalcMd5() {
        return this.calcMd5;
    }

    public void setCalcMd5(boolean bl) {
        this.calcMd5 = bl;
    }

    public Progress getProgress() {
        return this.progress;
    }

    public void setProgress(Progress progress) {
        this.progress = progress;
    }

    public static interface Progress {
        public void progress(int var1, String var2, String var3);
    }
}

