/*
 * Decompiled with CFR 0.152.
 */
package net.contrapunctus.lzma;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Random;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import net.contrapunctus.lzma.LzmaInputStream;
import net.contrapunctus.lzma.LzmaOutputStream;

public class Benchmark {
    private static byte[][] data = null;
    private static final Random rnd = new Random(-889275714L);
    private static final Checksum ck = new Adler32();
    private static final int EXPONENT = 18;
    private static final int ITERATIONS = 512;
    private static final int BUFSIZE = 8192;

    public static void doit() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        LzmaOutputStream lzmaOutputStream = new LzmaOutputStream(byteArrayOutputStream);
        int n = 0;
        for (int i = 0; i < 512; ++i) {
            int n2 = rnd.nextInt(data.length);
            lzmaOutputStream.write(data[n2]);
            ck.update(data[n2], 0, data[n2].length);
            n += data[n2].length;
        }
        lzmaOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        long l = ck.getValue();
        System.out.printf("%d bytes written, %d bytes compressed, checksum %X\n", n, byArray.length, l);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        LzmaInputStream lzmaInputStream = new LzmaInputStream(byteArrayInputStream);
        byArray = new byte[8192];
        ck.reset();
        int n3 = lzmaInputStream.read(byArray);
        n = 0;
        while (n3 > 0) {
            n += n3;
            ck.update(byArray, 0, n3);
            n3 = lzmaInputStream.read(byArray);
        }
        System.out.printf("%d bytes decompressed, checksum %X\n", n, ck.getValue());
        assert (l == ck.getValue());
    }

    public static void main(String[] stringArray) throws IOException {
        long l = System.nanoTime();
        Benchmark.doit();
        long l2 = System.nanoTime() - l;
        System.out.printf("%d us elapsed\n", l2 /= 1000L);
    }

    static {
        data = new byte[18][];
        int n = 1;
        int n2 = 0;
        while (n2 < data.length) {
            Benchmark.data[n2] = new byte[n];
            rnd.nextBytes(data[n2]);
            ++n2;
            n *= 2;
        }
    }
}

