/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.util;

import java.text.ParseException;

public class Range {
    private boolean negInf;
    private boolean posInf;
    private long min;
    private long max;

    public Range(long num) {
        this(num, num, false, false);
    }

    public Range(long min, long max) {
        this(min, max, false, false);
    }

    public Range(long min, boolean posInf) {
        this(min, Long.MAX_VALUE, false, posInf);
        if (!posInf) {
            throw new IllegalArgumentException("posInf must be true");
        }
    }

    public Range(boolean negInf, long max) {
        this(Long.MIN_VALUE, max, negInf, false);
        if (!negInf) {
            throw new IllegalArgumentException("negInf must be true");
        }
    }

    public Range(boolean negInf, boolean posInf) {
        this(Long.MIN_VALUE, Long.MAX_VALUE, negInf, posInf);
        if (!negInf || !posInf) {
            throw new IllegalArgumentException("negInf && posInf must be true");
        }
    }

    private Range(long min, long max, boolean negInf, boolean posInf) {
        if (min > max) {
            throw new IllegalArgumentException("min cannot be greater than max");
        }
        if (min == 0L && max == 0L) {
            System.err.println("Range.debug: 0-0 range detected. Did you intend to this? :");
            new Exception().printStackTrace();
        }
        this.min = min;
        this.max = max;
        this.negInf = negInf;
        this.posInf = posInf;
    }

    public boolean isMinNegInf() {
        return this.negInf;
    }

    public boolean isMaxPosInf() {
        return this.posInf;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public long size() {
        if (this.negInf || this.posInf) {
            return -1L;
        }
        return this.max - this.min + 1L;
    }

    public boolean contains(long i) {
        return i >= this.min && i <= this.max;
    }

    public boolean contains(Range r) {
        return r.min >= this.min && r.max <= this.max;
    }

    public int hashCode() {
        return (int)(this.min + 23L * this.max);
    }

    public boolean equals(Object obj) {
        return obj instanceof Range && ((Range)obj).min == this.min && ((Range)obj).max == this.max && ((Range)obj).negInf == this.negInf && ((Range)obj).posInf == this.posInf;
    }

    public String toString() {
        if (!this.negInf && !this.posInf && this.min == this.max) {
            return new Long(this.min).toString();
        }
        return (this.negInf ? "(" : "" + this.min) + "-" + (this.posInf ? ")" : "" + this.max);
    }

    public static final Range parse(String s) throws ParseException {
        try {
            long min = 0L;
            long max = 0L;
            boolean negInf = false;
            boolean posInf = false;
            int dashPos = s.indexOf("-", 1);
            if (dashPos == -1) {
                min = max = Long.parseLong(s);
            } else {
                if (s.indexOf("(") != -1) {
                    negInf = true;
                } else {
                    min = Long.parseLong(s.substring(0, dashPos));
                }
                if (s.indexOf(")") != -1) {
                    posInf = true;
                } else {
                    max = Long.parseLong(s.substring(dashPos + 1, s.length()));
                }
            }
            if (negInf) {
                if (posInf) {
                    return new Range(true, true);
                }
                return new Range(true, max);
            }
            if (posInf) {
                return new Range(min, true);
            }
            return new Range(min, max);
        }
        catch (RuntimeException e) {
            throw new ParseException(e.getMessage(), -1);
        }
    }
}

