/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.marshall;

import com.db4o.foundation.Closure4;
import com.db4o.internal.AbstractBufferContext;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.Handlers4;
import com.db4o.internal.HardObjectReference;
import com.db4o.internal.ReadWriteBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.activation.ActivationDepth;
import com.db4o.internal.activation.UnknownActivationDepth;
import com.db4o.internal.marshall.InternalReadContext;
import com.db4o.marshall.ReadBuffer;
import com.db4o.typehandlers.TypeHandler4;

public abstract class AbstractReadContext
extends AbstractBufferContext
implements InternalReadContext {
    protected ActivationDepth _activationDepth = UnknownActivationDepth.INSTANCE;

    protected AbstractReadContext(Transaction transaction, ReadBuffer buffer) {
        super(transaction, buffer);
    }

    protected AbstractReadContext(Transaction transaction) {
        this(transaction, null);
    }

    @Override
    public final Object read(TypeHandler4 handlerType) {
        return this.readObject(handlerType);
    }

    @Override
    public final Object readObject(TypeHandler4 handlerType) {
        final TypeHandler4 handler = Handlers4.correctHandlerVersion(this, handlerType);
        return this.slotFormat().doWithSlotIndirection(this, handler, new Closure4(){

            @Override
            public Object run() {
                return AbstractReadContext.this.readAtCurrentSeekPosition(handler);
            }
        });
    }

    @Override
    public Object readAtCurrentSeekPosition(TypeHandler4 handler) {
        ClassMetadata classMetadata;
        if (handler instanceof ClassMetadata && (classMetadata = (ClassMetadata)handler).isValueType()) {
            return classMetadata.readValueType(this.transaction(), this.readInt(), this.activationDepth().descend(classMetadata));
        }
        if (this.useDedicatedSlot(handler)) {
            return this.readObject();
        }
        return handler.read(this);
    }

    public boolean useDedicatedSlot(TypeHandler4 handler) {
        return FieldMetadata.useDedicatedSlot(this, handler);
    }

    @Override
    public final Object readObject() {
        int id = this.readInt();
        if (id == 0) {
            return null;
        }
        ClassMetadata classMetadata = this.classMetadataForId(id);
        if (null == classMetadata) {
            return null;
        }
        ActivationDepth depth = this.activationDepth().descend(classMetadata);
        if (this.peekPersisted()) {
            return this.container().peekPersisted(this.transaction(), id, depth, false);
        }
        Object obj = this.container().getByID2(this.transaction(), id);
        if (null == obj) {
            return null;
        }
        this.container().stillToActivate(this.transaction(), obj, depth);
        return obj;
    }

    private ClassMetadata classMetadataForId(int id) {
        HardObjectReference hardRef = this.container().getHardObjectReferenceById(this.transaction(), id);
        if (null == hardRef || hardRef._reference == null) {
            return null;
        }
        return hardRef._reference.classMetadata();
    }

    protected boolean peekPersisted() {
        return false;
    }

    public ActivationDepth activationDepth() {
        return this._activationDepth;
    }

    public void activationDepth(ActivationDepth depth) {
        this._activationDepth = depth;
    }

    @Override
    public ReadWriteBuffer readIndirectedBuffer() {
        int address = this.readInt();
        int length = this.readInt();
        if (address == 0) {
            return null;
        }
        return this.container().decryptedBufferByAddress(address, length);
    }
}

