/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.btree;

import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.ArrayIterator4;
import com.db4o.foundation.Function4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Iterators;
import com.db4o.foundation.NotImplementedException;
import com.db4o.foundation.SortedCollection4;
import com.db4o.internal.btree.BTreePointer;
import com.db4o.internal.btree.BTreeRange;
import com.db4o.internal.btree.BTreeRangeSingle;
import com.db4o.internal.btree.BTreeRangeVisitor;
import com.db4o.internal.btree.algebra.BTreeRangeUnionIntersect;
import com.db4o.internal.btree.algebra.BTreeRangeUnionUnion;

public class BTreeRangeUnion
implements BTreeRange {
    private final BTreeRangeSingle[] _ranges;

    public BTreeRangeUnion(BTreeRangeSingle[] ranges) {
        this(BTreeRangeUnion.toSortedCollection(ranges));
    }

    public BTreeRangeUnion(SortedCollection4 sorted) {
        if (null == sorted) {
            throw new ArgumentNullException();
        }
        this._ranges = BTreeRangeUnion.toArray(sorted);
    }

    @Override
    public void accept(BTreeRangeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean isEmpty() {
        for (int i = 0; i < this._ranges.length; ++i) {
            if (this._ranges[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static SortedCollection4 toSortedCollection(BTreeRangeSingle[] ranges) {
        if (null == ranges) {
            throw new ArgumentNullException();
        }
        SortedCollection4 collection = new SortedCollection4(BTreeRangeSingle.COMPARISON);
        for (int i = 0; i < ranges.length; ++i) {
            BTreeRangeSingle range = ranges[i];
            if (range.isEmpty()) continue;
            collection.add(range);
        }
        return collection;
    }

    private static BTreeRangeSingle[] toArray(SortedCollection4 collection) {
        return (BTreeRangeSingle[])collection.toArray(new BTreeRangeSingle[collection.size()]);
    }

    @Override
    public BTreeRange extendToFirst() {
        throw new NotImplementedException();
    }

    @Override
    public BTreeRange extendToLast() {
        throw new NotImplementedException();
    }

    @Override
    public BTreeRange extendToLastOf(BTreeRange upperRange) {
        throw new NotImplementedException();
    }

    @Override
    public BTreeRange greater() {
        throw new NotImplementedException();
    }

    @Override
    public BTreeRange intersect(BTreeRange range) {
        if (null == range) {
            throw new ArgumentNullException();
        }
        return new BTreeRangeUnionIntersect(this).dispatch(range);
    }

    @Override
    public Iterator4 pointers() {
        return Iterators.concat(Iterators.map(this._ranges, new Function4(){

            @Override
            public Object apply(Object range) {
                return ((BTreeRange)range).pointers();
            }
        }));
    }

    @Override
    public Iterator4 keys() {
        return Iterators.concat(Iterators.map(this._ranges, new Function4(){

            @Override
            public Object apply(Object range) {
                return ((BTreeRange)range).keys();
            }
        }));
    }

    @Override
    public int size() {
        int size = 0;
        for (int i = 0; i < this._ranges.length; ++i) {
            size += this._ranges[i].size();
        }
        return size;
    }

    @Override
    public BTreeRange smaller() {
        throw new NotImplementedException();
    }

    @Override
    public BTreeRange union(BTreeRange other) {
        if (null == other) {
            throw new ArgumentNullException();
        }
        return new BTreeRangeUnionUnion(this).dispatch(other);
    }

    public Iterator4 ranges() {
        return new ArrayIterator4(this._ranges);
    }

    @Override
    public BTreePointer lastPointer() {
        throw new NotImplementedException();
    }
}

