/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.activation;

import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Config4Class;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.activation.ActivationDepth;
import com.db4o.internal.activation.ActivationDepthProvider;
import com.db4o.internal.activation.ActivationMode;
import com.db4o.internal.activation.LegacyActivationDepth;

public class LegacyActivationDepthProvider
implements ActivationDepthProvider {
    public static final ActivationDepthProvider INSTANCE = new LegacyActivationDepthProvider();

    @Override
    public ActivationDepth activationDepthFor(ClassMetadata classMetadata, ActivationMode mode) {
        if (mode.isPrefetch()) {
            return new LegacyActivationDepth(classMetadata.prefetchActivationDepth(), mode);
        }
        int globalLegacyActivationDepth = this.configImpl(classMetadata).activationDepth();
        Config4Class config = classMetadata.configOrAncestorConfig();
        int defaultDepth = null == config ? globalLegacyActivationDepth : config.adjustActivationDepth(globalLegacyActivationDepth);
        return new LegacyActivationDepth(defaultDepth, mode);
    }

    @Override
    public ActivationDepth activationDepth(int depth, ActivationMode mode) {
        return new LegacyActivationDepth(depth, mode);
    }

    private Config4Impl configImpl(ClassMetadata classMetadata) {
        return classMetadata.stream().configImpl();
    }
}

