/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.internal.LatinStringIO;
import com.db4o.marshall.ReadBuffer;
import com.db4o.marshall.WriteBuffer;

public final class UnicodeStringIO
extends LatinStringIO {
    @Override
    public int bytesPerChar() {
        return 2;
    }

    @Override
    public byte encodingByte() {
        return 2;
    }

    @Override
    public int length(String str) {
        return str.length() * 2 + 0 + 4;
    }

    @Override
    public String read(ReadBuffer buffer, int length) {
        char[] chars = new char[length];
        for (int ii = 0; ii < length; ++ii) {
            chars[ii] = (char)(buffer.readByte() & 0xFF | (buffer.readByte() & 0xFF) << 8);
        }
        return new String(chars, 0, length);
    }

    @Override
    public String read(byte[] bytes) {
        int length = bytes.length / 2;
        char[] chars = new char[length];
        int j = 0;
        for (int ii = 0; ii < length; ++ii) {
            chars[ii] = (char)(bytes[j++] & 0xFF | (bytes[j++] & 0xFF) << 8);
        }
        return new String(chars, 0, length);
    }

    @Override
    public int shortLength(String str) {
        return str.length() * 2 + 4;
    }

    @Override
    public void write(WriteBuffer buffer, String str) {
        int length = str.length();
        char[] chars = new char[length];
        str.getChars(0, length, chars, 0);
        for (int i = 0; i < length; ++i) {
            buffer.writeByte((byte)(chars[i] & 0xFF));
            buffer.writeByte((byte)(chars[i] >> 8));
        }
    }

    @Override
    public byte[] write(String str) {
        int length = str.length();
        char[] chars = new char[length];
        str.getChars(0, length, chars, 0);
        byte[] bytes = new byte[length * 2];
        int j = 0;
        for (int i = 0; i < length; ++i) {
            bytes[j++] = (byte)(chars[i] & 0xFF);
            bytes[j++] = (byte)(chars[i] >> 8);
        }
        return bytes;
    }
}

