/*
 * Decompiled with CFR 0.152.
 */
package freenet.store.caching;

import freenet.keys.KeyVerifyException;
import freenet.node.SemiOrderedShutdownHook;
import freenet.store.BlockMetadata;
import freenet.store.FreenetStore;
import freenet.store.KeyCollisionException;
import freenet.store.ProxyFreenetStore;
import freenet.store.StorableBlock;
import freenet.store.StoreCallback;
import freenet.store.caching.CachingFreenetStoreTracker;
import freenet.support.ByteArrayWrapper;
import freenet.support.LRUMap;
import freenet.support.Logger;
import freenet.support.Ticker;
import freenet.support.io.NativeThread;
import java.io.IOException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class CachingFreenetStore<T extends StorableBlock>
extends ProxyFreenetStore<T> {
    private static volatile boolean logMINOR;
    private boolean shuttingDown;
    private final LRUMap<ByteArrayWrapper, Block<T>> blocksByRoutingKey;
    private final StoreCallback<T> callback;
    private final boolean collisionPossible;
    private final ReadWriteLock configLock = new ReentrantReadWriteLock();
    private final CachingFreenetStoreTracker tracker;
    private final int sizeBlock;

    public CachingFreenetStore(StoreCallback<T> callback, FreenetStore<T> backDatastore, CachingFreenetStoreTracker tracker) {
        super(backDatastore);
        this.callback = callback;
        SemiOrderedShutdownHook shutdownHook = SemiOrderedShutdownHook.get();
        this.blocksByRoutingKey = LRUMap.createSafeMap(ByteArrayWrapper.FAST_COMPARATOR);
        this.collisionPossible = callback.collisionPossible();
        this.shuttingDown = false;
        this.tracker = tracker;
        this.sizeBlock = callback.getTotalBlockSize();
        callback.setStore(this);
        shutdownHook.addEarlyJob(new NativeThread("Close CachingFreenetStore", NativeThread.HIGH_PRIORITY, true){

            @Override
            public void realRun() {
                CachingFreenetStore.this.innerClose();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T fetch(byte[] routingKey, byte[] fullKey, boolean dontPromote, boolean canReadClientCache, boolean canReadSlashdotCache, boolean ignoreOldBlocks, BlockMetadata meta) throws IOException {
        ByteArrayWrapper key = new ByteArrayWrapper(routingKey);
        Block<T> block = null;
        this.configLock.readLock().lock();
        try {
            block = this.blocksByRoutingKey.get(key);
        }
        finally {
            this.configLock.readLock().unlock();
        }
        if (block != null) {
            try {
                return this.callback.construct(block.data, block.header, routingKey, ((StorableBlock)block.block).getFullKey(), canReadClientCache, canReadSlashdotCache, meta, null);
            }
            catch (KeyVerifyException e) {
                Logger.error(this, "Error in fetching for CachingFreenetStore: " + e, (Throwable)e);
            }
        }
        return this.backDatastore.fetch(routingKey, fullKey, dontPromote, canReadClientCache, canReadSlashdotCache, ignoreOldBlocks, meta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean probablyInStore(byte[] routingKey) {
        ByteArrayWrapper key = new ByteArrayWrapper(routingKey);
        Block<T> block = null;
        this.configLock.readLock().lock();
        try {
            block = this.blocksByRoutingKey.get(key);
        }
        finally {
            this.configLock.readLock().unlock();
        }
        return block != null || this.backDatastore.probablyInStore(routingKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(T block, byte[] data, byte[] header, boolean overwrite, boolean isOldBlock) throws IOException, KeyCollisionException {
        byte[] routingKey = block.getRoutingKey();
        ByteArrayWrapper key = new ByteArrayWrapper(routingKey);
        Block storeBlock = new Block();
        storeBlock.block = block;
        storeBlock.data = data;
        storeBlock.header = header;
        storeBlock.overwrite = overwrite;
        storeBlock.isOldBlock = isOldBlock;
        boolean cacheIt = true;
        this.configLock.writeLock().lock();
        try {
            if (!this.shuttingDown) {
                Block<T> previousBlock = this.blocksByRoutingKey.get(key);
                if (!this.collisionPossible || overwrite) {
                    if (previousBlock == null) {
                        cacheIt = this.tracker.add(this.sizeBlock);
                    }
                    if (cacheIt) {
                        this.blocksByRoutingKey.push(key, storeBlock);
                    }
                } else {
                    if (previousBlock != null) {
                        if (block.equals(previousBlock.block)) {
                            return;
                        }
                        throw new KeyCollisionException();
                    }
                    if (this.backDatastore.probablyInStore(routingKey)) {
                        cacheIt = false;
                    } else {
                        cacheIt = this.tracker.add(this.sizeBlock);
                        if (cacheIt) {
                            this.blocksByRoutingKey.push(key, storeBlock);
                        }
                    }
                }
            } else {
                cacheIt = false;
            }
        }
        finally {
            this.configLock.writeLock().unlock();
        }
        if (!cacheIt) {
            this.backDatastore.put(block, data, header, overwrite, isOldBlock);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long pushLeastRecentlyBlock() {
        ByteArrayWrapper key;
        Block<T> block;
        block13: {
            block = null;
            key = null;
            this.configLock.writeLock().lock();
            try {
                block = this.blocksByRoutingKey.peekValue();
                if (block == null) {
                    long l = -1L;
                    return l;
                }
                key = this.blocksByRoutingKey.peekKey();
            }
            finally {
                this.configLock.writeLock().unlock();
            }
            try {
                this.backDatastore.put((StorableBlock)block.block, block.data, block.header, block.overwrite, block.isOldBlock);
            }
            catch (IOException e) {
                Logger.error(this, "Error in pushAll for CachingFreenetStore: " + e, (Throwable)e);
            }
            catch (KeyCollisionException e) {
                if (!logMINOR) break block13;
                Logger.minor(this, "KeyCollisionException in pushAll for CachingFreenetStore: " + e, (Throwable)e);
            }
        }
        this.configLock.writeLock().lock();
        try {
            Block<T> currentVersionOfBlock = this.blocksByRoutingKey.get(key);
            if (currentVersionOfBlock != null && ((StorableBlock)currentVersionOfBlock.block).equals(block.block) && this.blocksByRoutingKey.removeKey(key)) {
                long l = this.sizeBlock;
                return l;
            }
        }
        finally {
            this.configLock.writeLock().unlock();
        }
        return 0L;
    }

    @Override
    public boolean start(Ticker ticker, boolean longStart) throws IOException {
        this.tracker.registerCachingFS(this);
        return this.backDatastore.start(ticker, longStart);
    }

    @Override
    public void close() {
        this.innerClose();
        this.backDatastore.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerClose() {
        this.configLock.writeLock().lock();
        try {
            this.shuttingDown = true;
            this.tracker.unregisterCachingFS(this);
        }
        finally {
            this.configLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isEmpty() {
        boolean isEmpty;
        this.configLock.readLock().lock();
        try {
            isEmpty = this.blocksByRoutingKey.isEmpty();
        }
        finally {
            this.configLock.readLock().unlock();
        }
        return isEmpty;
    }

    static {
        Logger.registerClass(CachingFreenetStore.class);
    }

    private static final class Block<T> {
        T block;
        byte[] data;
        byte[] header;
        boolean overwrite;
        boolean isOldBlock;

        private Block() {
        }
    }
}

