/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.simulator;

import freenet.crypt.DummyRandomSource;
import freenet.crypt.RandomSource;
import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.keys.CHKEncodeException;
import freenet.keys.ClientCHKBlock;
import freenet.keys.ClientKSK;
import freenet.keys.ClientKey;
import freenet.keys.ClientKeyBlock;
import freenet.keys.FreenetURI;
import freenet.keys.InsertableClientSSK;
import freenet.keys.KeyDecodeException;
import freenet.keys.SSKEncodeException;
import freenet.node.FSParseException;
import freenet.node.LowLevelGetException;
import freenet.node.LowLevelPutException;
import freenet.node.Node;
import freenet.node.NodeInitException;
import freenet.node.NodeStarter;
import freenet.node.simulator.RealNodeRoutingTest;
import freenet.support.Logger;
import freenet.support.LoggerHook;
import freenet.support.PooledExecutor;
import freenet.support.compress.Compressor;
import freenet.support.compress.InvalidCompressionCodecException;
import freenet.support.io.ArrayBucket;
import freenet.support.io.FileUtil;
import freenet.support.math.RunningAverage;
import freenet.support.math.SimpleRunningAverage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class RealNodeRequestInsertTest
extends RealNodeRoutingTest {
    static final int NUMBER_OF_NODES = 100;
    static final int DEGREE = 10;
    static final short MAX_HTL = 5;
    static final boolean START_WITH_IDEAL_LOCATIONS = true;
    static final boolean FORCE_NEIGHBOUR_CONNECTIONS = true;
    static final boolean ENABLE_SWAPPING = false;
    static final boolean ENABLE_ULPRS = false;
    static final boolean ENABLE_PER_NODE_FAILURE_TABLES = false;
    static final boolean ENABLE_SWAP_QUEUEING = false;
    static final boolean ENABLE_PACKET_COALESCING = true;
    static final boolean ENABLE_FOAF = true;
    static final boolean FORK_ON_CACHEABLE = false;
    static final boolean DISABLE_PROBABILISTIC_HTLS = true;
    static final boolean USE_SLASHDOT_CACHE = false;
    static final boolean REAL_TIME_FLAG = false;
    static final int TARGET_SUCCESSES = 20;
    static final int BWLIMIT = 1024000;
    public static final int DARKNET_PORT_BASE = 10000;
    public static final int DARKNET_PORT_END = 10100;
    private final Node[] nodes;
    private final RandomSource random;
    private int requestNumber = 0;
    private RunningAverage requestsAvg = new SimpleRunningAverage(100, 0.0);
    private String baseString = System.currentTimeMillis() + " ";
    private int insertAttempts = 0;
    private int fetchSuccesses = 0;
    private final int targetSuccesses;

    public static void main(String[] args) throws FSParseException, PeerParseException, CHKEncodeException, LoggerHook.InvalidThresholdException, NodeInitException, ReferenceSignatureVerificationException, InterruptedException {
        int i;
        String name = "realNodeRequestInsertTest";
        File wd = new File(name);
        if (!FileUtil.removeAll(wd)) {
            System.err.println("Mass delete failed, test may not be accurate.");
            System.exit(1027);
        }
        wd.mkdir();
        NodeStarter.globalTestInit(name, false, Logger.LogLevel.ERROR, "", true);
        System.out.println("Insert/retrieve test");
        System.out.println();
        DummyRandomSource random = new DummyRandomSource(3142L);
        DummyRandomSource topologyRandom = new DummyRandomSource(3143L);
        Node[] nodes = new Node[100];
        Logger.normal(RealNodeRoutingTest.class, "Creating nodes...");
        PooledExecutor executor = new PooledExecutor();
        for (i = 0; i < 100; ++i) {
            nodes[i] = NodeStarter.createTestNode(10000 + i, 0, name, true, (short)5, 20, random, executor, 50000, 262144L, true, false, false, false, false, false, true, 1024000, true, false, true, false, null);
            Logger.normal(RealNodeRoutingTest.class, "Created node " + i);
        }
        RealNodeRequestInsertTest.makeKleinbergNetwork(nodes, true, 10, true, topologyRandom);
        Logger.normal(RealNodeRoutingTest.class, "Added random links");
        for (i = 0; i < 100; ++i) {
            nodes[i].start(false);
            System.err.println("Started node " + i + "/" + nodes.length);
        }
        RealNodeRequestInsertTest.waitForAllConnected(nodes);
        RealNodeRequestInsertTest.waitForPingAverage(0.5, nodes, new DummyRandomSource(3143L), 2000, 1000);
        random = new DummyRandomSource(3144L);
        System.out.println();
        System.out.println("Ping average > 95%, lets do some inserts/requests");
        System.out.println();
        RealNodeRequestInsertTest tester = new RealNodeRequestInsertTest(nodes, random, 20);
        while (true) {
            try {
                while (true) {
                    RealNodeRequestInsertTest.waitForAllConnected(nodes);
                    int status = tester.insertRequestTest();
                    if (status == -1) continue;
                    System.exit(status);
                }
            }
            catch (Throwable t) {
                Logger.error(RealNodeRequestInsertTest.class, "Caught " + t, t);
                continue;
            }
            break;
        }
    }

    public RealNodeRequestInsertTest(Node[] nodes, DummyRandomSource random, int targetSuccesses) {
        this.nodes = nodes;
        this.random = random;
        this.targetSuccesses = targetSuccesses;
    }

    int insertRequestTest() throws CHKEncodeException, InvalidCompressionCodecException, SSKEncodeException, IOException, KeyDecodeException {
        int node2;
        ClientKeyBlock block;
        ClientKey fetchKey;
        ClientKey insertKey;
        FreenetURI testKey;
        ++this.requestNumber;
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String dataString = this.baseString + this.requestNumber;
        int node1 = this.random.nextInt(100);
        Node randomNode = this.nodes[node1];
        boolean isSSK = true;
        byte[] buf = dataString.getBytes("UTF-8");
        if (isSSK) {
            testKey = new FreenetURI("KSK", dataString);
            insertKey = InsertableClientSSK.create(testKey);
            fetchKey = ClientKSK.create(testKey);
            block = ((InsertableClientSSK)insertKey).encode(new ArrayBucket(buf), false, false, (short)-1, buf.length, this.random, Compressor.COMPRESSOR_TYPE.DEFAULT_COMPRESSORDESCRIPTOR, false);
        } else {
            block = ClientCHKBlock.encode(buf, false, false, (short)-1, buf.length, Compressor.COMPRESSOR_TYPE.DEFAULT_COMPRESSORDESCRIPTOR, false);
            insertKey = fetchKey = block.getClientKey();
            testKey = insertKey.getURI();
        }
        System.err.println();
        System.err.println("Created random test key " + testKey + " = " + fetchKey.getNodeKey(false));
        System.err.println();
        byte[] data = dataString.getBytes("UTF-8");
        Logger.minor(RealNodeRequestInsertTest.class, "Decoded: " + new String(block.memoryDecode(), "UTF-8"));
        Logger.normal(RealNodeRequestInsertTest.class, "Insert Key: " + insertKey.getURI());
        Logger.normal(RealNodeRequestInsertTest.class, "Fetch Key: " + fetchKey.getURI());
        try {
            ++this.insertAttempts;
            randomNode.clientCore.realPut(block.getBlock(), false, false, false, false, false);
            Logger.error(RealNodeRequestInsertTest.class, "Inserted to " + node1);
        }
        catch (LowLevelPutException putEx) {
            Logger.error(RealNodeRequestInsertTest.class, "Insert failed: " + putEx);
            System.err.println("Insert failed: " + putEx);
            return 1029;
        }
        while ((node2 = this.random.nextInt(100)) == node1) {
        }
        Node fetchNode = this.nodes[node2];
        try {
            block = fetchNode.clientCore.realGetKey(fetchKey, false, false, false, false);
        }
        catch (LowLevelGetException e) {
            block = null;
        }
        if (block == null) {
            int percentSuccess = 100 * this.fetchSuccesses / this.insertAttempts;
            Logger.error(RealNodeRequestInsertTest.class, "Fetch #" + this.requestNumber + " FAILED (" + percentSuccess + "%); from " + node2);
            System.err.println("Fetch #" + this.requestNumber + " FAILED (" + percentSuccess + "%); from " + node2);
            this.requestsAvg.report(0.0);
        } else {
            byte[] results = block.memoryDecode();
            this.requestsAvg.report(1.0);
            if (Arrays.equals(results, data)) {
                ++this.fetchSuccesses;
                int percentSuccess = 100 * this.fetchSuccesses / this.insertAttempts;
                Logger.error(RealNodeRequestInsertTest.class, "Fetch #" + this.requestNumber + " from node " + node2 + " succeeded (" + percentSuccess + "%): " + new String(results));
                System.err.println("Fetch #" + this.requestNumber + " succeeded (" + percentSuccess + "%): \"" + new String(results) + '\"');
                if (this.fetchSuccesses == this.targetSuccesses) {
                    System.err.println("Succeeded, " + this.targetSuccesses + " successful fetches");
                    return 0;
                }
            } else {
                Logger.error(RealNodeRequestInsertTest.class, "Returned invalid data!: " + new String(results));
                System.err.println("Returned invalid data!: " + new String(results));
                return 1031;
            }
        }
        StringBuilder load = new StringBuilder("Running UIDs for nodes: ");
        int totalRunningUIDsAlt = 0;
        ArrayList<Long> runningUIDsList = new ArrayList<Long>();
        for (int i = 0; i < this.nodes.length; ++i) {
            load.append(i);
            load.append(':');
            this.nodes[i].tracker.addRunningUIDs(runningUIDsList);
            int runningUIDsAlt = this.nodes[i].tracker.getTotalRunningUIDsAlt();
            load.append(totalRunningUIDsAlt += runningUIDsAlt);
            if (i == this.nodes.length - 1) continue;
            load.append(' ');
        }
        System.err.println(load.toString());
        if (totalRunningUIDsAlt != 0) {
            System.err.println("Still running UIDs (alt): " + totalRunningUIDsAlt);
        }
        if (!runningUIDsList.isEmpty()) {
            System.err.println("List of running UIDs: " + Arrays.toString(runningUIDsList.toArray()));
        }
        return -1;
    }
}

