/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.simulator;

import freenet.config.SubConfig;
import freenet.crypt.DummyRandomSource;
import freenet.node.Node;
import freenet.node.NodeStarter;
import freenet.node.probe.Error;
import freenet.node.probe.Listener;
import freenet.node.probe.Type;
import freenet.node.simulator.RealNodeRequestInsertTest;
import freenet.node.simulator.RealNodeRoutingTest;
import freenet.support.Logger;
import freenet.support.PooledExecutor;
import freenet.support.io.FileUtil;
import java.io.BufferedReader;
import java.io.Console;
import java.io.File;
import java.io.InputStreamReader;
import java.text.NumberFormat;

public class RealNodeProbeTest
extends RealNodeRoutingTest {
    static final int NUMBER_OF_NODES = 100;
    static final int DEGREE = 10;
    static final short MAX_HTL = 5;
    static final boolean START_WITH_IDEAL_LOCATIONS = true;
    static final boolean FORCE_NEIGHBOUR_CONNECTIONS = true;
    static final boolean ENABLE_SWAPPING = false;
    static final boolean ENABLE_SWAP_QUEUEING = false;
    static final boolean ENABLE_FOAF = true;
    private static final boolean DO_INSERT_TEST = true;
    static final int MAX_PINGS = 2000;
    static final int OUTPUT_BANDWIDTH_LIMIT = 0;
    public static int DARKNET_PORT_BASE = RealNodeRoutingTest.DARKNET_PORT_END;
    public static final int DARKNET_PORT_END = DARKNET_PORT_BASE + 100;

    public static void main(String[] args) throws Exception {
        int i;
        System.out.println("Probe test using real nodes:");
        System.out.println();
        String dir = "realNodeProbeTest";
        File wd = new File(dir);
        if (!FileUtil.removeAll(wd)) {
            System.err.println("Mass delete failed, test may not be accurate.");
            System.exit(1027);
        }
        if (!wd.mkdir()) {
            System.err.println("Unabled to create test directory \"" + dir + "\".");
            return;
        }
        NodeStarter.globalTestInit(dir, false, Logger.LogLevel.ERROR, "", true);
        DummyRandomSource random = new DummyRandomSource(3142L);
        Node[] nodes = new Node[100];
        Logger.normal(RealNodeProbeTest.class, "Creating nodes...");
        PooledExecutor executor = new PooledExecutor();
        for (i = 0; i < 100; ++i) {
            System.err.println("Creating node " + i);
            nodes[i] = NodeStarter.createTestNode(DARKNET_PORT_BASE + i, 0, dir, true, (short)5, 0, random, executor, 50000, 262144L, true, false, false, false, false, false, true, 0, true, false, true, false, null, i == 0);
            Logger.normal(RealNodeProbeTest.class, "Created node " + i);
        }
        Logger.normal(RealNodeProbeTest.class, "Created 100 nodes");
        RealNodeProbeTest.makeKleinbergNetwork(nodes, true, 10, true, random);
        Logger.normal(RealNodeProbeTest.class, "Added random links");
        for (i = 0; i < 100; ++i) {
            System.err.println("Starting node " + i);
            nodes[i].start(false);
        }
        System.out.println();
        System.out.println("Ping average > 95%, lets do some inserts/requests");
        System.out.println();
        RealNodeProbeTest.waitForPingAverage(0.5, nodes, new DummyRandomSource(3143L), 2000, 1000);
        RealNodeRequestInsertTest tester = new RealNodeRequestInsertTest(nodes, random, 10);
        RealNodeProbeTest.waitForAllConnected(nodes);
        while (true) {
            try {
                int status;
                do {
                    RealNodeProbeTest.waitForAllConnected(nodes);
                    status = tester.insertRequestTest();
                } while (status == -1);
                System.out.println("Insert test completed with status " + status);
            }
            catch (Throwable t) {
                Logger.error(RealNodeRequestInsertTest.class, "Caught " + t, t);
                continue;
            }
            break;
        }
        final NumberFormat nf = NumberFormat.getInstance();
        Listener print = new Listener(){

            @Override
            public void onError(Error error, Byte code, boolean local) {
                System.out.print("Probe error: " + error.name());
                if (local) {
                    System.out.print(" (local)");
                }
                System.out.println(code == null ? "" : " (" + code + ")");
            }

            @Override
            public void onRefused() {
                System.out.println("Probe refused.");
            }

            @Override
            public void onOutputBandwidth(float outputBandwidth) {
                System.out.println("Probe got bandwidth limit " + nf.format(outputBandwidth) + " KiB per second.");
            }

            @Override
            public void onBuild(int build) {
                System.out.println("Probe got build " + build + ".");
            }

            @Override
            public void onIdentifier(long identifier, byte uptimePercentage) {
                System.out.println("Probe got identifier " + identifier + " with uptime percentage " + uptimePercentage + ".");
            }

            @Override
            public void onLinkLengths(float[] linkLengths) {
                System.out.print("Probe got link lengths: { ");
                float[] arr$ = linkLengths;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Float length = Float.valueOf(arr$[i$]);
                    System.out.print(length + " ");
                }
                System.out.println("}.");
            }

            @Override
            public void onLocation(float location) {
                System.out.println("Probe got location " + location + ".");
            }

            @Override
            public void onStoreSize(float storeSize) {
                System.out.println("Probe got store size " + nf.format(storeSize) + " GiB.");
            }

            @Override
            public void onUptime(float uptimePercentage) {
                System.out.print("Probe got uptime " + nf.format(uptimePercentage) + "%.");
            }

            @Override
            public void onRejectStats(byte[] stats) {
                System.out.println("Probe got reject stats:");
                System.out.println("CHK request: " + stats[0]);
                System.out.println("SSK request: " + stats[1]);
                System.out.println("CHK insert: " + stats[2]);
                System.out.println("SSK insert: " + stats[3]);
            }

            @Override
            public void onOverallBulkOutputCapacity(byte bandwidthClassForCapacityUsage, float outputBulkCapacityUsed) {
                System.out.println("Probe got output capacity " + nf.format(outputBulkCapacityUsed) + "% (bandwidth class " + bandwidthClassForCapacityUsage + ")");
            }
        };
        Type[] types = new Type[]{Type.BANDWIDTH, Type.BUILD, Type.IDENTIFIER, Type.LINK_LENGTHS, Type.LOCATION, Type.STORE_SIZE, Type.UPTIME_48H, Type.UPTIME_7D, Type.REJECT_STATS, Type.OVERALL_BULK_OUTPUT_CAPACITY_USAGE};
        int index = 0;
        byte htl = 70;
        Console console = System.console();
        BufferedReader r = console != null ? new BufferedReader(console.reader()) : new BufferedReader(new InputStreamReader(System.in));
        block8: while (true) {
            System.err.println("Sending probes from node " + index + " with HTL " + htl + ".");
            System.err.println("0) BANDWIDTH");
            System.err.println("1) BUILD");
            System.err.println("2) IDENTIFIER");
            System.err.println("3) LINK_LENGTHS");
            System.err.println("4) LOCATION");
            System.err.println("5) STORE_SIZE");
            System.err.println("6) UPTIME 48-hour");
            System.err.println("7) UPTIME 7-day");
            System.err.println("8) REJECT_STATS");
            System.err.println("9) OVERALL_BULK_OUTPUT_CAPACITY_USAGE");
            System.err.println("10) Pick another node");
            System.err.println("11) Pick another HTL");
            System.err.println("12) Pick current node's refusals");
            System.err.println("Anything else to exit.");
            System.err.println("Select: ");
            try {
                int selection = Integer.parseInt(r.readLine());
                if (selection == types.length) {
                    System.err.print("Enter new node index ([0-99]):");
                    index = Integer.valueOf(r.readLine());
                    continue;
                }
                if (selection == types.length + 1) {
                    System.err.print("Enter new HTL: ");
                    htl = Byte.valueOf(r.readLine());
                    continue;
                }
                if (selection == types.length + 2) {
                    String[] options;
                    SubConfig nodeConfig = nodes[index].config.get("node");
                    String[] arr$ = options = new String[]{"probeBandwidth", "probeBuild", "probeIdentifier", "probeLinkLengths", "probeLinkLengths", "probeUptime"};
                    int len$ = arr$.length;
                    int i$ = 0;
                    while (true) {
                        if (i$ >= len$) continue block8;
                        String option = arr$[i$];
                        System.err.print(option + ": ");
                        nodeConfig.set(option, Boolean.valueOf(r.readLine()));
                        ++i$;
                    }
                }
                nodes[index].startProbe(htl, random.nextLong(), types[selection], print);
                continue;
            }
            catch (Exception e) {
                System.out.print(e.toString());
                e.printStackTrace();
                System.exit(0);
                continue;
            }
            break;
        }
    }
}

