/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.probe;

public enum Error {
    DISCONNECTED(0),
    OVERLOAD(1),
    TIMEOUT(2),
    UNKNOWN(3),
    UNRECOGNIZED_TYPE(4),
    CANNOT_FORWARD(5);

    public final byte code;
    private static final int MAX_CODE;

    private Error(byte code) {
        this.code = code;
    }

    static boolean isValid(byte code) {
        return code >= 0 && code < MAX_CODE;
    }

    static Error valueOf(byte code) throws IllegalArgumentException {
        switch (code) {
            case 0: {
                return DISCONNECTED;
            }
            case 1: {
                return OVERLOAD;
            }
            case 2: {
                return TIMEOUT;
            }
            case 3: {
                return UNKNOWN;
            }
            case 4: {
                return UNRECOGNIZED_TYPE;
            }
            case 5: {
                return CANNOT_FORWARD;
            }
        }
        throw new IllegalArgumentException("There is no ProbeError with code " + code + ".");
    }

    static {
        MAX_CODE = Error.values().length;
    }
}

