/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.io.comm.FreenetInetAddress;
import freenet.io.comm.Peer;
import freenet.io.xfer.PacketThrottle;
import freenet.node.PeerNode;
import freenet.node.SeedClientPeerNode;
import freenet.node.SeedServerPeerNode;
import java.net.InetAddress;
import java.util.Map;

public class PeerNodeStatus {
    private final String peerAddress;
    private final String peerAddressNumerical;
    private final byte[] peerAddressBytes;
    private final int peerPort;
    private final int statusValue;
    private final String statusName;
    private final String statusCSSName;
    private final double location;
    private final double[] peersLocation;
    private final String version;
    private final int simpleVersion;
    private final long routingBackoffLengthRT;
    private final long routingBackoffLengthBulk;
    private final long routingBackedOffUntilRT;
    private final long routingBackedOffUntilBulk;
    private final boolean connected;
    private final boolean routable;
    private final boolean isFetchingARK;
    private final boolean isOpennet;
    private final double averagePingTime;
    private final double averagePingTimeCorrected;
    private final boolean publicInvalidVersion;
    private final boolean publicReverseInvalidVersion;
    private final double backedOffPercentRT;
    private final double backedOffPercentBulk;
    private String lastBackoffReasonRT;
    private String lastBackoffReasonBulk;
    private long timeLastRoutable;
    private long timeLastConnectionCompleted;
    private long peerAddedTime;
    private Map<String, Long> localMessagesReceived;
    private Map<String, Long> localMessagesSent;
    private final int hashCode;
    private final double pReject;
    private long totalBytesIn;
    private long totalBytesOut;
    private long totalBytesInSinceStartup;
    private long totalBytesOutSinceStartup;
    private double percentTimeRoutableConnection;
    private PacketThrottle throttle;
    private long clockDelta;
    private final boolean recordStatus;
    private final boolean isSeedServer;
    private final boolean isSeedClient;
    private final boolean isSearchable;
    private final long resendBytesSent;
    private final int reportedUptimePercentage;
    private final double selectionRate;
    private final long messageQueueLengthBytes;
    private final long messageQueueLengthTime;
    public final PeerNode.IncomingLoadSummaryStats incomingLoadStatsRealTime;
    public final PeerNode.IncomingLoadSummaryStats incomingLoadStatsBulk;
    public final boolean hasFullNoderef;

    PeerNodeStatus(PeerNode peerNode, boolean noHeavy) {
        Peer p = peerNode.getPeer();
        if (p == null) {
            this.peerAddress = null;
            this.peerAddressNumerical = null;
            this.peerAddressBytes = null;
            this.peerPort = -1;
        } else {
            FreenetInetAddress a = p.getFreenetAddress();
            this.peerAddress = a.toString();
            InetAddress i = a.getAddress(false);
            if (i != null) {
                this.peerAddressNumerical = i.getHostAddress();
                this.peerAddressBytes = i.getAddress();
            } else {
                this.peerAddressNumerical = null;
                this.peerAddressBytes = null;
            }
            this.peerPort = p.getPort();
        }
        this.selectionRate = peerNode.selectionRate();
        this.statusValue = peerNode.getPeerNodeStatus();
        this.statusName = peerNode.getPeerNodeStatusString();
        this.statusCSSName = peerNode.getPeerNodeStatusCSSClassName();
        this.location = peerNode.getLocation();
        this.peersLocation = peerNode.getPeersLocationArray();
        this.version = peerNode.getVersion();
        this.simpleVersion = peerNode.getSimpleVersion();
        this.routingBackoffLengthRT = peerNode.getRoutingBackoffLength(true);
        this.routingBackoffLengthBulk = peerNode.getRoutingBackoffLength(false);
        this.routingBackedOffUntilRT = peerNode.getRoutingBackedOffUntil(true);
        this.routingBackedOffUntilBulk = peerNode.getRoutingBackedOffUntil(false);
        this.connected = peerNode.isConnected();
        this.routable = peerNode.isRoutable();
        this.isFetchingARK = peerNode.isFetchingARK();
        this.isOpennet = peerNode.isOpennet();
        this.averagePingTime = peerNode.averagePingTime();
        this.averagePingTimeCorrected = peerNode.averagePingTimeCorrected();
        this.publicInvalidVersion = peerNode.publicInvalidVersion();
        this.publicReverseInvalidVersion = peerNode.publicReverseInvalidVersion();
        this.backedOffPercentRT = peerNode.backedOffPercentRT.currentValue();
        this.backedOffPercentBulk = peerNode.backedOffPercentBulk.currentValue();
        this.lastBackoffReasonRT = peerNode.getLastBackoffReason(true);
        this.lastBackoffReasonBulk = peerNode.getLastBackoffReason(false);
        this.timeLastRoutable = peerNode.timeLastRoutable();
        this.timeLastConnectionCompleted = peerNode.timeLastConnectionCompleted();
        this.peerAddedTime = peerNode.getPeerAddedTime();
        if (!noHeavy) {
            this.localMessagesReceived = peerNode.getLocalNodeReceivedMessagesFromStatistic();
            this.localMessagesSent = peerNode.getLocalNodeSentMessagesToStatistic();
        } else {
            this.localMessagesReceived = null;
            this.localMessagesSent = null;
        }
        this.hashCode = peerNode.hashCode;
        this.pReject = peerNode.getPRejected();
        this.totalBytesIn = peerNode.getTotalInputBytes();
        this.totalBytesOut = peerNode.getTotalOutputBytes();
        this.totalBytesInSinceStartup = peerNode.getTotalInputSinceStartup();
        this.totalBytesOutSinceStartup = peerNode.getTotalOutputSinceStartup();
        this.percentTimeRoutableConnection = peerNode.getPercentTimeRoutableConnection();
        this.throttle = peerNode.getThrottle();
        this.clockDelta = peerNode.getClockDelta();
        this.recordStatus = peerNode.recordStatus();
        this.isSeedClient = peerNode instanceof SeedClientPeerNode;
        this.isSeedServer = peerNode instanceof SeedServerPeerNode;
        this.isSearchable = peerNode.isRealConnection();
        this.resendBytesSent = peerNode.getResendBytesSent();
        this.reportedUptimePercentage = peerNode.getUptime();
        this.messageQueueLengthBytes = peerNode.getMessageQueueLengthBytes();
        this.messageQueueLengthTime = peerNode.getProbableSendQueueTime();
        this.incomingLoadStatsRealTime = peerNode.getIncomingLoadStats(true);
        this.incomingLoadStatsBulk = peerNode.getIncomingLoadStats(false);
        this.hasFullNoderef = peerNode.hasFullNoderef();
    }

    public long getMessageQueueLengthBytes() {
        return this.messageQueueLengthBytes;
    }

    public long getMessageQueueLengthTime() {
        return this.messageQueueLengthTime;
    }

    public Map<String, Long> getLocalMessagesReceived() {
        return this.localMessagesReceived;
    }

    public Map<String, Long> getLocalMessagesSent() {
        return this.localMessagesSent;
    }

    public long getPeerAddedTime() {
        return this.peerAddedTime;
    }

    public static int getPeerStatusCount(PeerNodeStatus[] peerNodeStatuses, int status) {
        int count = 0;
        for (PeerNodeStatus peerNodeStatus : peerNodeStatuses) {
            if (peerNodeStatus.getStatusValue() != status) continue;
            ++count;
        }
        return count;
    }

    public long getTimeLastConnectionCompleted() {
        return this.timeLastConnectionCompleted;
    }

    public double getBackedOffPercent(boolean realTime) {
        return realTime ? this.backedOffPercentRT : this.backedOffPercentBulk;
    }

    public String getLastBackoffReason(boolean realTime) {
        return realTime ? this.lastBackoffReasonRT : this.lastBackoffReasonBulk;
    }

    public long getTimeLastRoutable() {
        return this.timeLastRoutable;
    }

    public boolean isPublicInvalidVersion() {
        return this.publicInvalidVersion;
    }

    public boolean isPublicReverseInvalidVersion() {
        return this.publicReverseInvalidVersion;
    }

    public double getAveragePingTime() {
        return this.averagePingTime;
    }

    public double getAveragePingTimeCorrected() {
        return this.averagePingTimeCorrected;
    }

    public long getRoutingBackedOffUntil(boolean realTime) {
        return realTime ? this.routingBackedOffUntilRT : this.routingBackedOffUntilBulk;
    }

    public double getLocation() {
        return this.location;
    }

    public double[] getPeersLocation() {
        return this.peersLocation;
    }

    public String getPeerAddress() {
        return this.peerAddress;
    }

    public String getPeerAddressNumerical() {
        return this.peerAddressNumerical;
    }

    public byte[] getPeerAddressBytes() {
        return this.peerAddressBytes;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public long getRoutingBackoffLength(boolean realTime) {
        return realTime ? this.routingBackoffLengthRT : this.routingBackoffLengthBulk;
    }

    public String getStatusCSSName() {
        return this.statusCSSName;
    }

    public String getStatusName() {
        return this.statusName;
    }

    public int getStatusValue() {
        return this.statusValue;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isRoutable() {
        return this.routable;
    }

    public boolean isFetchingARK() {
        return this.isFetchingARK;
    }

    public boolean isOpennet() {
        return this.isOpennet;
    }

    public int getSimpleVersion() {
        return this.simpleVersion;
    }

    public String toString() {
        return this.statusName + ' ' + this.peerAddress + ':' + this.peerPort + ' ' + this.location + ' ' + this.version + " RT backoff: " + this.routingBackoffLengthRT + " (" + Math.max(this.routingBackedOffUntilRT - System.currentTimeMillis(), 0L) + " ) bulk backoff: " + this.routingBackoffLengthBulk + " (" + Math.max(this.routingBackedOffUntilBulk - System.currentTimeMillis(), 0L) + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public double getPReject() {
        return this.pReject;
    }

    public long getTotalInputBytes() {
        return this.totalBytesIn;
    }

    public long getTotalOutputBytes() {
        return this.totalBytesOut;
    }

    public long getTotalInputSinceStartup() {
        return this.totalBytesInSinceStartup;
    }

    public long getTotalOutputSinceStartup() {
        return this.totalBytesOutSinceStartup;
    }

    public double getPercentTimeRoutableConnection() {
        return this.percentTimeRoutableConnection;
    }

    public PacketThrottle getThrottle() {
        return this.throttle;
    }

    public long getClockDelta() {
        return this.clockDelta;
    }

    public boolean recordStatus() {
        return this.recordStatus;
    }

    public boolean isSeedServer() {
        return this.isSeedServer;
    }

    public boolean isSeedClient() {
        return this.isSeedClient;
    }

    public boolean isSearchable() {
        return this.isSearchable;
    }

    public long getResendBytesSent() {
        return this.resendBytesSent;
    }

    public int getReportedUptimePercentage() {
        return this.reportedUptimePercentage;
    }

    public double getSelectionRate() {
        return this.selectionRate;
    }
}

